/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import jsc.swt.plot.LinearAxisModel;
import jsc.swt.plot2d.AxesPlot;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.plot2d.StandardMarker;
import jsc.swt.virtualgraphics.Polyline;
import jsc.swt.virtualgraphics.VLine;
import jsc.swt.virtualgraphics.VPoint;
import jsc.util.Scale;

public class ProportionPlot2D
extends AxesPlot {
    int numberOfTrials;
    double targetProportion;
    int trialCount;
    Polyline polyline;
    PlotObject curve;
    PlotObject line = null;
    Color curveColour;
    Stroke lineStroke;
    Color lineColour;
    Stroke curveStroke;
    String xTitle;
    int xTicks;

    public ProportionPlot2D(String string, String string2, int n, String string3, int n2, int n3, Color color, Stroke stroke, double d, Color color2, Stroke stroke2) {
        super(new LinearAxisModel(string2, new Scale(0.0, n3, n, false), "##"), new LinearAxisModel(string3, new Scale(0.0, 1.0, n2, false), "#.##"), string);
        this.curveColour = color;
        this.curveStroke = stroke;
        this.lineColour = color2;
        this.lineStroke = stroke2;
        this.numberOfTrials = n3;
        this.xTitle = string2;
        this.xTicks = n;
        this.targetProportion = d;
        this.setAntialiasing(false);
        this.setPreferredSize(new Dimension(400, 300));
        this.setTargetProportion(d);
    }

    public double addProportion(int n) {
        if (this.trialCount >= this.numberOfTrials) {
            return -1.0;
        }
        ++this.trialCount;
        double d = (double)n / (double)this.trialCount;
        if (d < 0.0 || d > 1.0) {
            System.out.println("numberOfSuccesses = " + n + " trialCount = " + this.trialCount + " proportion = " + d);
            throw new IllegalArgumentException("Invalid number of successes.");
        }
        if (this.trialCount == 1) {
            VPoint vPoint = new VPoint(1.0, d);
            this.polyline = new Polyline(vPoint, this.numberOfTrials + 1);
            this.addObject(new StandardMarker(vPoint, 4, 5, this.curveColour));
        } else {
            this.polyline.lineTo(new VPoint(this.trialCount, d));
            this.removeObject(this.curve);
            this.curve = new PlotShape(this.polyline, this.curveColour, this.curveStroke);
            this.addObject(this.curve);
        }
        this.repaint();
        return d;
    }

    public int getTrialCount() {
        return this.trialCount;
    }

    public void clear() {
        this.trialCount = 0;
        this.removeAllObjects();
    }

    public void rescale(int n, int n2) {
        this.numberOfTrials = n;
        this.xTicks = n2;
        this.rescaleHorizontal(new LinearAxisModel(this.xTitle, new Scale(0.0, n, n2, false), "##"));
        this.removeAllObjects();
        this.setTargetProportion(this.targetProportion);
    }

    public void setTargetProportion(double d) {
        if (d > 0.0 && d < 1.0) {
            this.line = new PlotShape(new VLine(new VPoint(0.0, d), new VPoint(this.numberOfTrials, d)), this.lineColour, this.lineStroke);
            this.addObject(this.line);
        } else {
            if (this.line != null) {
                this.removeObject(this.line);
            }
            this.line = null;
        }
        this.repaint();
    }
}

