/*
 * Decompiled with CFR 0.152.
 */
package jsc.tests;

import jsc.combinatorics.Enumerator;
import jsc.combinatorics.Selection;
import jsc.distributions.Tail;
import jsc.event.StatisticEvent;
import jsc.event.StatisticListener;
import jsc.independentsamples.MannWhitneyTest;
import jsc.statistics.PermutableStatistic;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class PermutationTest
implements SignificanceTest {
    private long critCount = 0L;
    private double totalRepCount = 0.0;
    private final double tObs;
    private double SP = 0.0;
    private final Tail tail;
    private final int N;
    private final double permCount;
    private Enumerator perm;
    private PermutableStatistic permutableStatistic;
    private StatisticListener statisticListener;

    public PermutationTest(PermutableStatistic permutableStatistic, Tail tail, boolean bl, int n, double d, StatisticListener statisticListener) {
        this.tail = tail;
        this.permutableStatistic = permutableStatistic;
        this.tObs = permutableStatistic.getStatistic();
        if (statisticListener != null) {
            this.statisticListener = statisticListener;
        }
        this.N = permutableStatistic.getN();
        this.perm = permutableStatistic.getEnumerator();
        this.permCount = this.perm.countSelections();
        if (bl && (double)n < this.permCount) {
            if (d <= 0.0) {
                this.calculateSP(n);
            } else {
                this.calculateSP(n, d);
            }
        } else {
            this.calculateSP();
        }
    }

    public PermutationTest(PermutableStatistic permutableStatistic, Tail tail, boolean bl, int n, double d) {
        this(permutableStatistic, tail, bl, n, d, null);
    }

    public PermutationTest(PermutableStatistic permutableStatistic, Tail tail, boolean bl, int n) {
        this(permutableStatistic, tail, bl, n, -1.0, null);
    }

    public PermutationTest(PermutableStatistic permutableStatistic, Tail tail) {
        this(permutableStatistic, tail, false, 0, 0.0, null);
    }

    public PermutationTest(PermutableStatistic permutableStatistic) {
        this(permutableStatistic, Tail.UPPER, false, 0, 0.0, null);
    }

    public double calculateSP() {
        this.critCount = 0L;
        while (this.perm.hasNext()) {
            Selection selection = this.perm.nextSelection();
            this.processPermutation(selection);
        }
        this.totalRepCount = this.permCount;
        this.SP = (double)this.critCount / this.permCount;
        return this.SP;
    }

    public double calculateSP(int n) {
        if (this.totalRepCount >= this.permCount) {
            return this.SP;
        }
        int n2 = 0;
        while (n2 < n) {
            Selection selection = this.perm.randomSelection();
            if (selection == null) break;
            this.processPermutation(selection);
            this.totalRepCount += 1.0;
            ++n2;
        }
        this.SP = (double)this.critCount / this.totalRepCount;
        return this.SP;
    }

    public double calculateSP(int n, double d) {
        double d2;
        do {
            d2 = this.SP;
            this.calculateSP(n);
        } while (Math.abs(this.SP - d2) >= d);
        return this.SP;
    }

    public double getPermutationCount() {
        return this.permCount;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.tObs;
    }

    public double getTotalRepCount() {
        return this.totalRepCount;
    }

    private void processPermutation(Selection selection) {
        double d = this.permutableStatistic.permuteStatistic(selection);
        if (this.statisticListener != null) {
            this.statisticListener.statisticCreated(new StatisticEvent(this, d));
        }
        if (this.tail == Tail.UPPER) {
            if (d >= this.tObs) {
                ++this.critCount;
            }
        } else if (this.tail == Tail.LOWER) {
            if (d <= this.tObs) {
                ++this.critCount;
            }
        } else if (Math.abs(d) >= Math.abs(this.tObs)) {
            ++this.critCount;
        }
    }

    public void setSeed(long l) {
        this.perm.setSeed(l);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{78.0, 64.0, 75.0, 45.0, 82.0};
            double[] dArray2 = new double[]{110.0, 70.0, 53.0, 51.0};
            MannWhitneyTest mannWhitneyTest = new MannWhitneyTest(dArray, dArray2, H1.LESS_THAN, 0.0, false);
            System.out.println("SP = " + mannWhitneyTest.getSP() + " U = " + mannWhitneyTest.getTestStatistic());
            PermutationTest permutationTest = new PermutationTest(mannWhitneyTest, Tail.LOWER, false, 0, 0.0, null);
            System.out.println("SP = " + permutationTest.getSP() + " tObs = " + permutationTest.getTestStatistic());
            mannWhitneyTest = new MannWhitneyTest(dArray, dArray2, H1.GREATER_THAN, 0.0, false);
            System.out.println("SP = " + mannWhitneyTest.getSP() + " U = " + mannWhitneyTest.getTestStatistic());
            permutationTest = new PermutationTest(mannWhitneyTest, Tail.LOWER, false, 0, 0.0, null);
            System.out.println("SP = " + permutationTest.getSP() + " tObs = " + permutationTest.getTestStatistic());
        }

        static class StatListener
        implements StatisticListener {
            StatListener() {
            }

            public void statisticCreated(StatisticEvent statisticEvent) {
                System.out.print(" " + statisticEvent.getStatistic());
            }
        }
    }
}

