/*
 * Decompiled with CFR 0.152.
 */
package jsc.util;

public class Polynomial {
    private final int degree;
    private final double[] p;
    private final double[] q;
    private final double[] r;

    public Polynomial(double[] dArray) {
        int n = dArray.length;
        this.degree = n - 1;
        this.p = new double[n];
        this.q = new double[this.degree];
        this.r = new double[this.degree - 1];
        int n2 = 0;
        while (n2 < n) {
            this.p[n2] = dArray[n2];
            ++n2;
        }
    }

    public double eval(double d) {
        this.q[this.degree - 1] = this.p[this.degree];
        int n = this.degree - 1;
        while (n >= 1) {
            this.q[n - 1] = this.p[n] + d * this.q[n];
            --n;
        }
        return this.p[0] + d * this.q[0];
    }

    public double[] evalDerivative(double d) {
        double[] dArray = new double[2];
        dArray[0] = this.eval(d);
        if (this.degree == 1) {
            dArray[1] = this.p[1];
        } else {
            this.r[this.degree - 2] = this.q[this.degree - 1];
            int n = this.degree - 2;
            while (n >= 1) {
                this.r[n - 1] = this.q[n] + d * this.r[n];
                --n;
            }
            dArray[1] = this.q[0] + d * this.r[0];
        }
        return dArray;
    }

    public double getCoefficient(int n) {
        return this.p[n];
    }

    public int getDegree() {
        return this.degree;
    }
}

