/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.hypermodules.internal.FindPaths;
import org.cytoscape.hypermodules.internal.HypermodulesHeuristicAlgorithm;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.TaskMonitor;

public class OriginalTest {
    private CytoscapeUtils utils;
    private String expandOption;
    private String statTest;
    private ArrayList<String[]> sampleValues;
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> otherValues;
    private CyNetwork network;
    private String foregroundvariable;
    private TaskMonitor tm;

    public OriginalTest(String expandOption, String statTest, String foregroundvariable, ArrayList<String[]> sampleValues, ArrayList<String[]> clinicalValues, ArrayList<String[]> otherValues, CytoscapeUtils utils, TaskMonitor tm, CyNetwork network) {
        this.utils = utils;
        this.expandOption = expandOption;
        this.statTest = statTest;
        this.foregroundvariable = foregroundvariable;
        this.sampleValues = sampleValues;
        this.otherValues = otherValues;
        this.clinicalValues = clinicalValues;
        this.tm = tm;
        this.network = network;
    }

    public HashMap<String, HashMap<String, Double>> testHighOrLow(HashMap<String, HashMap<String, Double>> ot) {
        HashMap<String, HashMap<String, Double>> rt = new HashMap<String, HashMap<String, Double>>();
        HypermodulesHeuristicAlgorithm ha = new HypermodulesHeuristicAlgorithm(this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, this.network);
        ha.initialize();
        for (String s : ot.keySet()) {
            HashMap<String, Double> newMap = new HashMap<String, Double>();
            for (String t : ot.get(s).keySet()) {
                if (ha.testModuleBoolean(t) == 1) {
                    newMap.put(t, 1.0);
                    continue;
                }
                if (ha.testModuleBoolean(t) == 0) {
                    newMap.put(t, 0.0);
                    continue;
                }
                newMap.put(t, 2.0);
            }
            rt.put(s, newMap);
        }
        return rt;
    }

    public HashMap<String, HashMap<String, Double>> callTest() {
        HashMap<String, HashMap<String, Double>> rt = new HashMap<String, HashMap<String, Double>>();
        HypermodulesHeuristicAlgorithm ha = new HypermodulesHeuristicAlgorithm(this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, this.network);
        ha.initialize();
        if (this.expandOption.equals("expand")) {
            ArrayList<String> seedNames = new ArrayList<String>();
            ArrayList<CyNode> expands = new ArrayList<CyNode>();
            String seedName = "Default";
            CyNode seedExpand = null;
            for (CyNode node : CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true)) {
                seedName = (String)this.network.getRow((CyIdentifiable)node).get("name", String.class);
                seedExpand = node;
                seedNames.add(seedName);
                expands.add(seedExpand);
            }
            this.tm.setTitle("Testing on Original Network");
            int l = 1;
            for (int k = 0; k < seedNames.size(); ++k) {
                this.tm.setStatusMessage("Running Algorithm on Seed: " + (String)seedNames.get(k));
                HashMap<String, Double> oneResult = this.testSeed(ha, (String)seedNames.get(k), (CyNode)expands.get(k));
                rt.put(seedName, oneResult);
                this.tm.setProgress((double)l / (double)seedNames.size());
                ++l;
            }
        } else if (this.expandOption.equals("findMost")) {
            HashSet<String> allSeeds = new HashSet<String>();
            for (int i = 0; i < this.sampleValues.size(); ++i) {
                if (this.sampleValues.get(i)[1].equals("no_sample") || this.sampleValues.get(i)[1] == null) continue;
                allSeeds.add(this.sampleValues.get(i)[0]);
            }
            HashMap<Object, CyNode> nameAndNode = new HashMap<Object, CyNode>();
            for (CyNode nameNode : this.network.getNodeList()) {
                if (!allSeeds.contains(this.network.getRow((CyIdentifiable)nameNode).get("name", String.class))) continue;
                nameAndNode.put(this.network.getRow((CyIdentifiable)nameNode).get("name", String.class), nameNode);
            }
            System.out.println("allSeeds size: " + nameAndNode.size());
            this.tm.setTitle("Testing on Original Network");
            int k = 1;
            for (String runSeed : nameAndNode.keySet()) {
                this.tm.setStatusMessage("Running Algorithm on Seed: " + runSeed + " ( " + k + " of " + nameAndNode.size() + " )");
                HashMap<String, Double> oneResult = this.testSeed(ha, runSeed, (CyNode)nameAndNode.get(runSeed));
                rt.put(runSeed, oneResult);
                this.tm.setProgress((double)k / (double)nameAndNode.size());
                ++k;
            }
            this.tm.setTitle("Testing on Random Permutations");
            System.out.println("finished running.");
        }
        return rt;
    }

    public HashMap<String, Double> testSeed(HypermodulesHeuristicAlgorithm ha, String seedName, CyNode seedExpand) {
        HashMap<String, Double> returnMap = new HashMap();
        FindPaths pathfinder = new FindPaths(this.network, 2);
        HashSet<String> allPaths = new HashSet();
        allPaths = pathfinder.getAllPaths2(seedExpand);
        ArrayList<String> compress = ha.compressTokens(allPaths, seedName);
        HashMap<String, Double> answer = ha.mineHublets(compress);
        returnMap = answer;
        return returnMap;
    }
}

