/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.gui;

import com.google.common.collect.ArrayListMultimap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.hypermodules.internal.gui.CollapsiblePanel;
import org.cytoscape.hypermodules.internal.gui.ErrorDialog;
import org.cytoscape.hypermodules.internal.gui.NetworkSelectionPanel;
import org.cytoscape.hypermodules.internal.task.AlgorithmTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.NetworkDestroyedListener;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class MainPanel
extends JPanel
implements CytoPanelComponent,
ActionListener,
MouseListener {
    private CytoscapeUtils utils;
    private CySwingApplication swingApp;
    private static final long serialVersionUID = 1L;
    private NetworkSelectionPanel netSelect;
    private JPanel mainPanel;
    private JPanel expandOptionPanel;
    private JPanel testPanel;
    private JPanel shufflePanel;
    private JPanel samplePanel;
    private JScrollPane samplePanelScrollPane;
    private CollapsiblePanel loadSamplePanel;
    private JPanel clinicalPanel;
    private JScrollPane clinicalPanelScrollPane;
    private CollapsiblePanel loadClinicalPanel;
    private JPanel runPanel;
    private JComboBox expandComboBox;
    private JRadioButton expand;
    private JRadioButton findMost;
    private ButtonGroup options;
    private JRadioButton logRank;
    private JRadioButton fisher;
    private ButtonGroup statTest;
    private JLabel shuffle;
    private JTextField nShuffled;
    private JCheckBox headers;
    private JCheckBox clinicalheaders;
    private JButton loadSamples;
    private JTable allGeneSamples;
    private JScrollPane sampleScrollPane;
    private JButton loadClinicalData;
    private JTable clinicalTable;
    private JScrollPane clinicalScrollPane;
    private JButton run;
    private ArrayList<String[]> genes2samplesvalues;
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> otherValues;
    private ArrayList<String[]> allClinicalData;
    private String[] header;
    private String[] clinicalheader;
    private HashMap<String, Integer> columnIndices;
    private JComboBox lrpatients;
    private JComboBox lrdaysfollowup;
    private JComboBox lrvitalstatus;
    private JComboBox fpatients;
    private JComboBox fvariable;
    private JComboBox fforeground;
    private int state;
    private ArrayList<String[]> newGeneTable;
    private ArrayList<String[]> genes2samplesvaluescopy;
    private JTableHeader mutationHeader;
    private JTableHeader variableHeader;

    public MainPanel(CySwingApplication swingApp, CytoscapeUtils utils) {
        this.utils = utils;
        this.swingApp = swingApp;
        this.genes2samplesvalues = null;
        this.clinicalValues = null;
        this.makeComponents();
        this.makeLayout();
        this.state = 0;
    }

    public void makeLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.netSelect, "North");
        this.netSelect.setBorder(BorderFactory.createTitledBorder("Select Network"));
        this.netSelect.setPreferredSize(new Dimension(350, 70));
        this.add((Component)this.mainPanel, "Center");
        this.expandOptionPanel.setLayout(new BoxLayout(this.expandOptionPanel, 1));
        this.expandOptionPanel.setBorder(BorderFactory.createTitledBorder("Expand Option:"));
        this.expandOptionPanel.setMinimumSize(new Dimension(350, 75));
        this.expandOptionPanel.setMaximumSize(new Dimension(350, 75));
        this.expandOptionPanel.setPreferredSize(new Dimension(350, 75));
        this.expandOptionPanel.setAlignmentX(0.0f);
        this.findMost.setSelected(true);
        this.testPanel.setLayout(new BoxLayout(this.testPanel, 1));
        this.testPanel.setBorder(BorderFactory.createTitledBorder("Analysis Type:"));
        this.testPanel.setPreferredSize(new Dimension(350, 75));
        this.testPanel.setMinimumSize(new Dimension(350, 75));
        this.testPanel.setMaximumSize(new Dimension(350, 75));
        this.testPanel.setAlignmentX(0.0f);
        this.shufflePanel.setLayout(new BoxLayout(this.shufflePanel, 0));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.logRank.setSelected(true);
        this.add((Component)this.runPanel, "South");
        this.runPanel.setLayout(new GridBagLayout());
    }

    public void makeComponents() {
        this.netSelect = new NetworkSelectionPanel(this.utils);
        this.utils.serviceRegistrar.registerService((Object)this.netSelect, NetworkAddedListener.class, new Properties());
        this.utils.serviceRegistrar.registerService((Object)this.netSelect, NetworkDestroyedListener.class, new Properties());
        this.mainPanel = new JPanel();
        this.expandOptionPanel = new JPanel();
        this.expandComboBox = new JComboBox();
        this.expandComboBox.addItem("Expand From All Seeds");
        this.expandComboBox.addItem("Expand From Selected Seeds");
        this.expandComboBox.setSelectedItem("Expand From All Seeds");
        this.expandOptionPanel.add((Component)this.expandComboBox, "Center");
        this.expand = new JRadioButton("Expand from Selected Seeds");
        this.findMost = new JRadioButton("Find Most Correlated Module");
        this.options = new ButtonGroup();
        this.options.add(this.expand);
        this.options.add(this.findMost);
        this.testPanel = new JPanel();
        this.logRank = new JRadioButton("Survival (Log Rank Test)");
        this.fisher = new JRadioButton("Categorical Variable (Fisher's Test)");
        this.logRank.addActionListener(this);
        this.fisher.addActionListener(this);
        this.statTest = new ButtonGroup();
        this.statTest.add(this.logRank);
        this.statTest.add(this.fisher);
        this.testPanel.add(this.logRank);
        this.testPanel.add(this.fisher);
        this.shufflePanel = new JPanel();
        this.shuffle = new JLabel("Shuffle Number:");
        this.nShuffled = new JTextField("100", 5);
        this.shufflePanel.add((Component)this.shuffle, "West");
        this.shufflePanel.add((Component)this.nShuffled, "East");
        this.shufflePanel.setPreferredSize(new Dimension(350, 40));
        this.shufflePanel.setMinimumSize(new Dimension(350, 40));
        this.shufflePanel.setMaximumSize(new Dimension(350, 40));
        this.shufflePanel.setAlignmentX(0.0f);
        this.mainPanel.add(this.expandOptionPanel);
        this.mainPanel.add(this.testPanel);
        this.mainPanel.add(this.shufflePanel);
        this.samplePanelScrollPane = new JScrollPane();
        this.samplePanel = new JPanel();
        this.samplePanel.setLayout(new BoxLayout(this.samplePanel, 1));
        this.loadSamples = new JButton("Load Mutation Data");
        this.loadSamples.addActionListener(this);
        this.loadSamples.setPreferredSize(new Dimension(150, 23));
        JPanel buttonheader = new JPanel();
        buttonheader.setLayout(new GridLayout(1, 3));
        buttonheader.setPreferredSize(new Dimension(300, 30));
        buttonheader.setMaximumSize(new Dimension(300, 30));
        this.headers = new JCheckBox("CSV has Headers");
        this.headers.addActionListener(this);
        buttonheader.add(this.loadSamples);
        buttonheader.add(this.headers);
        this.samplePanel.add(buttonheader);
        this.loadSamplePanel = new CollapsiblePanel("Samples");
        this.loadSamplePanel.setPreferredSize(new Dimension(3000, 280));
        this.loadSamplePanel.setMaximumSize(new Dimension(3000, 280));
        this.samplePanel.setPreferredSize(new Dimension(300, 300));
        this.samplePanel.setMaximumSize(new Dimension(300, 300));
        this.samplePanel.add(this.loadSamplePanel);
        this.samplePanelScrollPane.setViewportView(this.samplePanel);
        this.samplePanelScrollPane.setPreferredSize(new Dimension(350, 150));
        this.sampleScrollPane = new JScrollPane();
        this.sampleScrollPane.setPreferredSize(new Dimension(300, 215));
        this.sampleScrollPane.setMaximumSize(new Dimension(300, 215));
        this.loadSamplePanel.getContentPane().add((Component)this.sampleScrollPane, "North");
        this.resetSamplePanel(null);
        this.clinicalPanelScrollPane = new JScrollPane();
        this.clinicalPanel = new JPanel();
        this.clinicalPanel.setLayout(new BoxLayout(this.clinicalPanel, 1));
        JPanel headerplusbutton = new JPanel();
        headerplusbutton.setLayout(new GridLayout(1, 2));
        headerplusbutton.setPreferredSize(new Dimension(300, 30));
        headerplusbutton.setMaximumSize(new Dimension(300, 30));
        this.loadClinicalData = new JButton("Load Clinical Data");
        this.loadClinicalData.addActionListener(this);
        this.loadClinicalData.setPreferredSize(new Dimension(150, 23));
        this.clinicalheaders = new JCheckBox("CSV has Headers");
        this.clinicalheaders.addActionListener(this);
        headerplusbutton.add(this.loadClinicalData);
        headerplusbutton.add(this.clinicalheaders);
        this.clinicalPanel.add(headerplusbutton);
        JPanel dds = new JPanel();
        dds.setLayout(new GridLayout(3, 2));
        JLabel lrpatientlabel = new JLabel("patients: ");
        this.lrpatients = new JComboBox();
        this.lrpatients.setPreferredSize(new Dimension(150, 23));
        this.lrpatients.setMaximumSize(new Dimension(150, 23));
        JLabel lrvitalstatuslabel = new JLabel("vital status: ");
        this.lrvitalstatus = new JComboBox();
        this.lrvitalstatus.setPreferredSize(new Dimension(150, 23));
        this.lrvitalstatus.setMaximumSize(new Dimension(150, 23));
        JLabel lrdflabel = new JLabel("followup times: ");
        this.lrdaysfollowup = new JComboBox();
        this.lrdaysfollowup.setPreferredSize(new Dimension(150, 23));
        this.lrdaysfollowup.setMaximumSize(new Dimension(150, 23));
        dds.add(lrpatientlabel);
        dds.add(this.lrpatients);
        dds.add(lrvitalstatuslabel);
        dds.add(this.lrvitalstatus);
        dds.add(lrdflabel);
        dds.add(this.lrdaysfollowup);
        dds.setPreferredSize(new Dimension(300, 90));
        dds.setMaximumSize(new Dimension(300, 90));
        this.clinicalPanel.add(dds);
        this.loadClinicalPanel = new CollapsiblePanel("Clinical Data");
        this.clinicalScrollPane = new JScrollPane();
        this.clinicalScrollPane.setPreferredSize(new Dimension(300, 240));
        this.clinicalScrollPane.setMaximumSize(new Dimension(300, 240));
        this.loadClinicalPanel.getContentPane().add((Component)this.clinicalScrollPane, "North");
        this.loadClinicalPanel.setPreferredSize(new Dimension(3000, 280));
        this.loadClinicalPanel.setMaximumSize(new Dimension(3000, 280));
        this.clinicalPanel.setPreferredSize(new Dimension(300, 420));
        this.clinicalPanel.setMaximumSize(new Dimension(300, 420));
        this.clinicalPanel.add(this.loadClinicalPanel);
        this.clinicalPanelScrollPane.setViewportView(this.clinicalPanel);
        this.clinicalPanelScrollPane.setPreferredSize(new Dimension(350, 250));
        this.mainPanel.add(this.samplePanelScrollPane);
        this.mainPanel.add(this.clinicalPanelScrollPane);
        this.runPanel = new JPanel();
        this.run = new JButton("Run HyperModules");
        this.run.addActionListener(this);
        this.runPanel.add(this.run);
    }

    public void resetSamplePanel(JTable table) {
        if (this.allGeneSamples != null) {
            this.mutationHeader = this.allGeneSamples.getTableHeader();
            this.mutationHeader.addMouseListener(this);
        }
        this.sampleScrollPane.setViewportView(table);
    }

    private List<FileChooserFilter> getFilters() {
        ArrayList<FileChooserFilter> filters = new ArrayList<FileChooserFilter>();
        filters.add(new FileChooserFilter("CSV", "csv"));
        filters.add(new FileChooserFilter("MAF", "maf"));
        filters.add(new FileChooserFilter("MAF.TXT", "maf.txt"));
        filters.add(new FileChooserFilter("TXT", "txt"));
        return filters;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "HyperModules";
    }

    public void extractDataFromMaf() {
        ArrayListMultimap map = ArrayListMultimap.create();
        System.out.println(this.genes2samplesvalues.size());
        System.out.println(this.genes2samplesvalues.get(0).length);
        System.out.println(this.genes2samplesvalues.get(1).length);
        System.out.println(this.genes2samplesvalues.get(2).length);
        for (int i = 1; i < this.genes2samplesvalues.size(); ++i) {
            if (this.genes2samplesvalues.get(i).length <= 15) continue;
            String[] split = this.genes2samplesvalues.get(i)[15].split("-");
            String s = split[0] + "-" + split[1] + "-" + split[2];
            map.put((Object)this.genes2samplesvalues.get(i)[0], (Object)s);
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (String s : map.keySet()) {
            Collection st = map.get((Object)s);
            Iterator it = st.iterator();
            String t = (String)it.next();
            while (it.hasNext()) {
                t = t + ":" + (String)it.next();
            }
            map2.put(s, t);
        }
        ArrayList<String[]> newgenesamples = new ArrayList<String[]>();
        for (String s : map2.keySet()) {
            String[] st = new String[]{s, (String)map2.get(s)};
            System.out.println(st[0] + "-" + st[1]);
            newgenesamples.add(st);
        }
        this.genes2samplesvalues = newgenesamples;
    }

    public void setClinicalPanelLogRank(Boolean header, int flag) {
        this.clinicalPanel = new JPanel();
        this.clinicalPanel.setLayout(new BoxLayout(this.clinicalPanel, 1));
        this.loadClinicalData = new JButton("Load Clinical Data");
        this.loadClinicalData.addActionListener(this);
        this.loadClinicalData.setPreferredSize(new Dimension(150, 23));
        JPanel headerplusbutton = new JPanel();
        headerplusbutton.setLayout(new GridLayout(1, 2));
        headerplusbutton.setPreferredSize(new Dimension(300, 30));
        headerplusbutton.setMaximumSize(new Dimension(300, 30));
        this.clinicalheaders = new JCheckBox("CSV has Headers");
        if (header.booleanValue()) {
            this.clinicalheaders.setSelected(true);
        }
        this.clinicalheaders.addActionListener(this);
        headerplusbutton.add(this.loadClinicalData);
        headerplusbutton.add(this.clinicalheaders);
        this.clinicalPanel.add(headerplusbutton);
        JPanel dropdowns = new JPanel();
        dropdowns.setLayout(new GridLayout(3, 2));
        JLabel lrpatientlabel = new JLabel("patients: ");
        this.lrpatients = new JComboBox();
        this.lrpatients.setPreferredSize(new Dimension(150, 23));
        this.lrpatients.setMaximumSize(new Dimension(150, 23));
        JLabel lrvitalstatuslabel = new JLabel("vital status: ");
        this.lrvitalstatus = new JComboBox();
        this.lrvitalstatus.setPreferredSize(new Dimension(150, 23));
        this.lrvitalstatus.setMaximumSize(new Dimension(150, 23));
        JLabel lrdflabel = new JLabel("followup times: ");
        this.lrdaysfollowup = new JComboBox();
        this.lrdaysfollowup.setPreferredSize(new Dimension(150, 23));
        this.lrdaysfollowup.setMaximumSize(new Dimension(150, 23));
        dropdowns.add(lrpatientlabel);
        dropdowns.add(this.lrpatients);
        dropdowns.add(lrvitalstatuslabel);
        dropdowns.add(this.lrvitalstatus);
        dropdowns.add(lrdflabel);
        dropdowns.add(this.lrdaysfollowup);
        dropdowns.setPreferredSize(new Dimension(300, 90));
        dropdowns.setMaximumSize(new Dimension(300, 90));
        this.clinicalPanel.add(dropdowns);
        if (flag == 1) {
            for (String h : this.columnIndices.keySet()) {
                System.out.println(h);
                this.lrpatients.addItem(h);
                this.lrvitalstatus.addItem(h);
                this.lrdaysfollowup.addItem(h);
            }
            for (String h : this.columnIndices.keySet()) {
                if (this.columnIndices.get(h) == 0) {
                    this.lrpatients.setSelectedItem(h);
                }
                if (this.columnIndices.get(h) == 1) {
                    this.lrvitalstatus.setSelectedItem(h);
                }
                if (this.columnIndices.get(h) != 2) continue;
                this.lrdaysfollowup.setSelectedItem(h);
            }
        }
        this.loadClinicalPanel = new CollapsiblePanel("Clinical Data");
        this.clinicalScrollPane = new JScrollPane();
        this.clinicalScrollPane.setPreferredSize(new Dimension(300, 240));
        this.clinicalScrollPane.setMaximumSize(new Dimension(300, 240));
        this.loadClinicalPanel.getContentPane().add((Component)this.clinicalScrollPane, "North");
        this.loadClinicalPanel.setPreferredSize(new Dimension(3000, 280));
        this.loadClinicalPanel.setMaximumSize(new Dimension(3000, 280));
        this.clinicalPanel.setPreferredSize(new Dimension(300, 420));
        this.clinicalPanel.setMaximumSize(new Dimension(300, 420));
        this.clinicalPanel.add(this.loadClinicalPanel);
        this.clinicalPanelScrollPane.setViewportView(this.clinicalPanel);
        if (flag == 1) {
            int col1 = this.columnIndices.get(this.lrpatients.getSelectedItem());
            int col2 = this.columnIndices.get(this.lrvitalstatus.getSelectedItem());
            int col3 = this.columnIndices.get(this.lrdaysfollowup.getSelectedItem());
            this.setlrtable(col1, col2, col3);
            this.lrpatients.addActionListener(this);
            this.lrvitalstatus.addActionListener(this);
            this.lrdaysfollowup.addActionListener(this);
        }
    }

    public HashSet<String> extractClinicalVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (int i = 0; i < this.otherValues.size(); ++i) {
            variables.add(this.otherValues.get(i)[1]);
        }
        return variables;
    }

    public void setClinicalPanelFisher(Boolean header, int flag) {
        this.clinicalPanel = new JPanel();
        this.clinicalPanel.setLayout(new BoxLayout(this.clinicalPanel, 1));
        this.loadClinicalData = new JButton("Load Clinical Data");
        this.loadClinicalData.addActionListener(this);
        this.loadClinicalData.setPreferredSize(new Dimension(150, 23));
        JPanel headerplusbutton = new JPanel();
        headerplusbutton.setLayout(new GridLayout(1, 2));
        headerplusbutton.setPreferredSize(new Dimension(300, 30));
        headerplusbutton.setMaximumSize(new Dimension(300, 30));
        this.clinicalheaders = new JCheckBox("CSV has Headers");
        if (header.booleanValue()) {
            this.clinicalheaders.setSelected(true);
        }
        this.clinicalheaders.addActionListener(this);
        headerplusbutton.add(this.loadClinicalData);
        headerplusbutton.add(this.clinicalheaders);
        this.clinicalPanel.add(headerplusbutton);
        JPanel drops = new JPanel();
        drops.setLayout(new GridLayout(3, 2));
        JLabel fpatientlabel = new JLabel("patients: ");
        this.fpatients = new JComboBox();
        this.fpatients.setPreferredSize(new Dimension(300, 23));
        this.fpatients.setMaximumSize(new Dimension(300, 23));
        JLabel fvariablelabel = new JLabel("clinical variable: ");
        this.fvariable = new JComboBox();
        this.fvariable.setPreferredSize(new Dimension(150, 23));
        this.fvariable.setMaximumSize(new Dimension(150, 23));
        JLabel fforegroundlabel = new JLabel("value to test:");
        this.fforeground = new JComboBox();
        this.fforeground.setPreferredSize(new Dimension(150, 23));
        this.fforeground.setMaximumSize(new Dimension(150, 23));
        drops.add(fpatientlabel);
        drops.add(this.fpatients);
        drops.add(fvariablelabel);
        drops.add(this.fvariable);
        drops.add(fforegroundlabel);
        drops.add(this.fforeground);
        drops.setPreferredSize(new Dimension(300, 90));
        drops.setMaximumSize(new Dimension(300, 90));
        this.clinicalPanel.add(drops);
        if (flag == 1) {
            for (String h : this.columnIndices.keySet()) {
                this.fpatients.addItem(h);
                this.fvariable.addItem(h);
            }
            for (String h : this.columnIndices.keySet()) {
                if (this.columnIndices.get(h) == 0) {
                    this.fpatients.setSelectedItem(h);
                }
                if (this.columnIndices.get(h) != 1) continue;
                this.fvariable.setSelectedItem(h);
            }
        }
        this.loadClinicalPanel = new CollapsiblePanel("Clinical Data");
        this.clinicalScrollPane = new JScrollPane();
        this.clinicalScrollPane.setPreferredSize(new Dimension(300, 240));
        this.clinicalScrollPane.setMaximumSize(new Dimension(300, 240));
        this.loadClinicalPanel.getContentPane().add((Component)this.clinicalScrollPane, "North");
        this.loadClinicalPanel.setPreferredSize(new Dimension(3000, 280));
        this.loadClinicalPanel.setMaximumSize(new Dimension(3000, 280));
        this.clinicalPanel.setPreferredSize(new Dimension(300, 420));
        this.clinicalPanel.setMaximumSize(new Dimension(300, 420));
        this.clinicalPanel.add(this.loadClinicalPanel);
        this.clinicalPanelScrollPane.setViewportView(this.clinicalPanel);
        if (flag == 1) {
            int col1 = this.columnIndices.get(this.fpatients.getSelectedItem());
            int col2 = this.columnIndices.get(this.fvariable.getSelectedItem());
            this.setfishertable(col1, col2);
            this.fpatients.addActionListener(this);
            this.fvariable.addActionListener(this);
        }
    }

    public void setfishertable(int one, int two) {
        this.fforeground.removeAllItems();
        this.otherValues = new ArrayList();
        for (int i = 0; i < this.allClinicalData.size(); ++i) {
            String[] add = new String[]{this.allClinicalData.get(i)[one], this.allClinicalData.get(i)[two]};
            this.otherValues.add(add);
        }
        HashSet<String> vars = this.extractClinicalVariables();
        for (String h : vars) {
            this.fforeground.addItem(h);
        }
        this.fforeground.addItem("--");
        this.fforeground.setSelectedItem("--");
        String[] t = new String[]{"Patient ID", "Clinical Variable"};
        MyModel nm = new MyModel(t);
        nm.AddCSVData(this.otherValues);
        this.clinicalTable = new JTable();
        this.clinicalTable.setModel(nm);
        this.variableHeader = this.clinicalTable.getTableHeader();
        this.variableHeader.addMouseListener(this);
        this.clinicalScrollPane.setViewportView(this.clinicalTable);
    }

    public void setlrtable(int one, int two, int three) {
        this.clinicalValues = new ArrayList();
        for (int i = 0; i < this.allClinicalData.size(); ++i) {
            String[] add = new String[]{this.allClinicalData.get(i)[one], this.allClinicalData.get(i)[two], this.allClinicalData.get(i)[three]};
            this.clinicalValues.add(add);
        }
        String[] h = new String[]{"Patient ID", "Vital", "Followup Times"};
        MyModel nm = new MyModel(h);
        nm.AddCSVData(this.clinicalValues);
        this.clinicalTable = new JTable();
        this.clinicalTable.setModel(nm);
        this.variableHeader = this.clinicalTable.getTableHeader();
        this.variableHeader.addMouseListener(this);
        this.clinicalScrollPane.setViewportView(this.clinicalTable);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File DataFile2;
        int col3;
        int col2;
        int col1;
        if (ae.getSource() == this.lrpatients || ae.getSource() == this.lrvitalstatus || ae.getSource() == this.lrdaysfollowup) {
            col1 = this.columnIndices.get(this.lrpatients.getSelectedItem());
            col2 = this.columnIndices.get(this.lrvitalstatus.getSelectedItem());
            col3 = this.columnIndices.get(this.lrdaysfollowup.getSelectedItem());
            this.setlrtable(col1, col2, col3);
        }
        if (ae.getSource() == this.fpatients || ae.getSource() == this.fvariable) {
            col1 = this.columnIndices.get(this.fpatients.getSelectedItem());
            col2 = this.columnIndices.get(this.fvariable.getSelectedItem());
            this.setfishertable(col1, col2);
        }
        if (ae.getSource() == this.logRank) {
            if (this.allClinicalData != null && this.allClinicalData.get(0).length >= 3) {
                this.setClinicalPanelLogRank(this.clinicalheaders.isSelected(), 1);
            } else if (this.allClinicalData != null && this.allClinicalData.get(0).length < 3) {
                ErrorDialog ed = new ErrorDialog(this.utils, "There are not enough columns in the CSV for log rank test.");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                System.out.println("Not enough columns for log rank!");
                this.fisher.setSelected(true);
            } else {
                this.setClinicalPanelLogRank(this.clinicalheaders.isSelected(), 0);
            }
        }
        if (ae.getSource() == this.fisher) {
            if (this.allClinicalData != null) {
                this.setClinicalPanelFisher(this.clinicalheaders.isSelected(), 1);
            } else {
                this.setClinicalPanelFisher(this.clinicalheaders.isSelected(), 0);
            }
        }
        if (ae.getSource() == this.headers) {
            if (this.headers.isSelected()) {
                if (this.genes2samplesvalues != null) {
                    if (this.header == null && this.genes2samplesvalues != null) {
                        this.header = this.genes2samplesvalues.get(0);
                        this.genes2samplesvalues.remove(0);
                    }
                    MyModel NewModel = new MyModel(this.header);
                    NewModel.AddCSVData(this.genes2samplesvalues);
                    this.allGeneSamples = new JTable();
                    this.allGeneSamples.setModel(NewModel);
                    this.resetSamplePanel(this.allGeneSamples);
                }
            } else if (this.genes2samplesvalues != null && this.header != null) {
                this.genes2samplesvalues.add(0, this.header);
                this.header = null;
                String[] c = new String[]{"genes", "samples"};
                MyModel NewModel = new MyModel(c);
                NewModel.AddCSVData(this.genes2samplesvalues);
                this.allGeneSamples = new JTable();
                this.allGeneSamples.setModel(NewModel);
                this.resetSamplePanel(this.allGeneSamples);
            }
        }
        if (ae.getSource() == this.clinicalheaders) {
            if (this.clinicalheaders.isSelected()) {
                if (this.allClinicalData != null) {
                    if (this.clinicalheader == null) {
                        this.clinicalheader = this.allClinicalData.get(0);
                        this.allClinicalData.remove(0);
                    }
                    if (this.logRank.isSelected()) {
                        this.lrpatients.removeActionListener(this);
                        this.lrvitalstatus.removeActionListener(this);
                        this.lrdaysfollowup.removeActionListener(this);
                        this.lrpatients.removeAllItems();
                        this.lrvitalstatus.removeAllItems();
                        this.lrdaysfollowup.removeAllItems();
                        this.columnIndices = new HashMap();
                        for (int u = 0; u < this.clinicalheader.length; ++u) {
                            this.columnIndices.put(this.clinicalheader[u], u);
                        }
                        for (String s : this.columnIndices.keySet()) {
                            this.lrpatients.addItem(s);
                            this.lrvitalstatus.addItem(s);
                            this.lrdaysfollowup.addItem(s);
                        }
                        for (String h : this.columnIndices.keySet()) {
                            if (this.columnIndices.get(h) == 0) {
                                this.lrpatients.setSelectedItem(h);
                            }
                            if (this.columnIndices.get(h) == 1) {
                                this.lrvitalstatus.setSelectedItem(h);
                            }
                            if (this.columnIndices.get(h) != 2) continue;
                            this.lrdaysfollowup.setSelectedItem(h);
                        }
                        int col12 = this.columnIndices.get(this.lrpatients.getSelectedItem());
                        int col22 = this.columnIndices.get(this.lrvitalstatus.getSelectedItem());
                        col3 = this.columnIndices.get(this.lrdaysfollowup.getSelectedItem());
                        this.setlrtable(col12, col22, col3);
                        this.lrpatients.addActionListener(this);
                        this.lrvitalstatus.addActionListener(this);
                        this.lrdaysfollowup.addActionListener(this);
                    } else if (this.fisher.isSelected()) {
                        this.fpatients.removeActionListener(this);
                        this.fvariable.removeActionListener(this);
                        this.fpatients.removeAllItems();
                        this.fvariable.removeAllItems();
                        this.columnIndices = new HashMap();
                        for (int u = 0; u < this.clinicalheader.length; ++u) {
                            this.columnIndices.put(this.clinicalheader[u], u);
                        }
                        for (String s : this.columnIndices.keySet()) {
                            this.fpatients.addItem(s);
                            this.fvariable.addItem(s);
                        }
                        for (String h : this.columnIndices.keySet()) {
                            if (this.columnIndices.get(h) == 0) {
                                this.fpatients.setSelectedItem(h);
                            }
                            if (this.columnIndices.get(h) != 1) continue;
                            this.fvariable.setSelectedItem(h);
                        }
                        int col13 = this.columnIndices.get(this.fpatients.getSelectedItem());
                        int col23 = this.columnIndices.get(this.fvariable.getSelectedItem());
                        this.setfishertable(col13, col23);
                        this.fpatients.addActionListener(this);
                        this.fvariable.addActionListener(this);
                    }
                }
            } else if (this.allClinicalData != null && this.clinicalheader != null) {
                this.allClinicalData.add(0, this.clinicalheader);
                this.clinicalheader = null;
                if (this.logRank.isSelected()) {
                    this.lrpatients.removeActionListener(this);
                    this.lrvitalstatus.removeActionListener(this);
                    this.lrdaysfollowup.removeActionListener(this);
                    this.lrpatients.removeAllItems();
                    this.lrvitalstatus.removeAllItems();
                    this.lrdaysfollowup.removeAllItems();
                    this.columnIndices = new HashMap();
                    for (int u = 0; u < this.allClinicalData.get(0).length; ++u) {
                        this.columnIndices.put("Column " + (u + 1), u);
                    }
                    for (String s : this.columnIndices.keySet()) {
                        this.lrpatients.addItem(s);
                        this.lrvitalstatus.addItem(s);
                        this.lrdaysfollowup.addItem(s);
                    }
                    for (String h : this.columnIndices.keySet()) {
                        if (this.columnIndices.get(h) == 0) {
                            this.lrpatients.setSelectedItem(h);
                        }
                        if (this.columnIndices.get(h) == 1) {
                            this.lrvitalstatus.setSelectedItem(h);
                        }
                        if (this.columnIndices.get(h) != 2) continue;
                        this.lrdaysfollowup.setSelectedItem(h);
                    }
                    int col14 = this.columnIndices.get(this.lrpatients.getSelectedItem());
                    int col24 = this.columnIndices.get(this.lrvitalstatus.getSelectedItem());
                    col3 = this.columnIndices.get(this.lrdaysfollowup.getSelectedItem());
                    this.setlrtable(col14, col24, col3);
                    this.lrpatients.addActionListener(this);
                    this.lrvitalstatus.addActionListener(this);
                    this.lrdaysfollowup.addActionListener(this);
                } else if (this.fisher.isSelected()) {
                    this.fpatients.removeActionListener(this);
                    this.fvariable.removeActionListener(this);
                    this.fpatients.removeAllItems();
                    this.fvariable.removeAllItems();
                    this.columnIndices = new HashMap();
                    for (int u = 0; u < this.allClinicalData.get(0).length; ++u) {
                        this.columnIndices.put("Column " + (u + 1), u);
                    }
                    for (String s : this.columnIndices.keySet()) {
                        this.fpatients.addItem(s);
                        this.fvariable.addItem(s);
                    }
                    for (String h : this.columnIndices.keySet()) {
                        if (this.columnIndices.get(h) == 0) {
                            this.fpatients.setSelectedItem(h);
                        }
                        if (this.columnIndices.get(h) != 1) continue;
                        this.fvariable.setSelectedItem(h);
                    }
                    int col15 = this.columnIndices.get(this.fpatients.getSelectedItem());
                    int col25 = this.columnIndices.get(this.fvariable.getSelectedItem());
                    this.setfishertable(col15, col25);
                    this.fpatients.addActionListener(this);
                    this.fvariable.addActionListener(this);
                }
            }
        }
        if (ae.getSource() == this.loadClinicalData && (DataFile2 = this.utils.fileUtil.getFile((Component)this.utils.swingApp.getJFrame(), "Load Clinical Data", 0, this.getFilters())) != null) {
            int y;
            CSVFile Rd = new CSVFile();
            this.allClinicalData = Rd.ReadCSVfile(DataFile2);
            this.columnIndices = new HashMap();
            if (this.allClinicalData.get(0).length < 3 && this.logRank.isSelected()) {
                ErrorDialog ed = new ErrorDialog(this.utils, "There are not enough columns in the CSV for log rank test.");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                System.out.println("Not enough columns!");
                return;
            }
            if (this.clinicalheaders.isSelected()) {
                this.clinicalheader = this.allClinicalData.get(0);
                this.allClinicalData.remove(0);
                for (y = 0; y < this.clinicalheader.length; ++y) {
                    this.columnIndices.put(this.clinicalheader[y], y);
                }
            } else {
                for (y = 0; y < this.allClinicalData.get(0).length; ++y) {
                    this.columnIndices.put("Column " + (y + 1), y);
                }
            }
            if (this.logRank.isSelected()) {
                this.setClinicalPanelLogRank(this.clinicalheaders.isSelected(), 1);
            } else if (this.fisher.isSelected()) {
                this.setClinicalPanelFisher(this.clinicalheaders.isSelected(), 1);
            }
            this.loadClinicalPanel.setCollapsed(false);
        }
        if (ae.getSource() == this.loadSamples && (DataFile = this.utils.fileUtil.getFile((Component)this.utils.swingApp.getJFrame(), "Load Samples", 0, this.getFilters())) != null) {
            CSVFile Rd = new CSVFile();
            this.genes2samplesvalues = Rd.ReadCSVfile(DataFile);
            MyModel NewModel = null;
            if (this.headers.isSelected()) {
                this.header = this.genes2samplesvalues.get(0);
                NewModel = new MyModel(this.header);
                this.genes2samplesvalues.remove(0);
            } else {
                String[] c = new String[]{"genes", "samples"};
                NewModel = new MyModel(c);
            }
            if (this.genes2samplesvalues.get(0)[0].equals("Hugo_Symbol")) {
                this.extractDataFromMaf();
            }
            NewModel.AddCSVData(this.genes2samplesvalues);
            this.allGeneSamples = new JTable();
            this.allGeneSamples.setModel(NewModel);
            this.resetSamplePanel(this.allGeneSamples);
            this.loadSamplePanel.setCollapsed(false);
        }
        if (ae.getSource() == this.run) {
            String shuffleNumber = this.nShuffled.getText();
            int number = 0;
            try {
                number = Integer.parseInt(shuffleNumber);
            }
            catch (Exception e) {
                System.out.println("Please Enter a Number!");
                return;
            }
            String expandOption = "default";
            expandOption = this.expandComboBox.getSelectedItem().equals("Expand From Selected Seeds") ? "expand" : "findMost";
            String stat = "default";
            if (this.logRank.isSelected()) {
                stat = "logRank";
            } else if (this.fisher.isSelected()) {
                stat = "fisher";
            }
            CyNetwork currNet = this.netSelect.getSelectedNetwork();
            String foregroundVariable = "default";
            if (this.fisher.isSelected() && (foregroundVariable = (String)this.fforeground.getSelectedItem()).equals("--")) {
                ErrorDialog ed = new ErrorDialog(this.utils, "Please select a value to test.");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                return;
            }
            System.out.println(foregroundVariable);
            if (this.genes2samplesvalues != null) {
                this.genes2samplesvaluescopy = new ArrayList();
                for (int i = 0; i < this.genes2samplesvalues.size(); ++i) {
                    this.genes2samplesvaluescopy.add(this.genes2samplesvalues.get(i));
                }
                this.handleSampleValues(this.genes2samplesvaluescopy);
            }
            if (stat.equals("logRank") && this.genes2samplesvaluescopy != null && this.clinicalValues != null) {
                if (this.handleSurvivalExceptions()) {
                    this.utils.taskMgr.execute(new TaskIterator(new Task[]{new AlgorithmTask(currNet, number, expandOption, stat, foregroundVariable, this.genes2samplesvaluescopy, this.clinicalValues, this.otherValues, this.utils)}));
                }
            } else if (stat.equals("fisher") && this.genes2samplesvaluescopy != null && this.otherValues != null) {
                if (this.handleClinicalVariableExceptions()) {
                    this.utils.taskMgr.execute(new TaskIterator(new Task[]{new AlgorithmTask(currNet, number, expandOption, stat, foregroundVariable, this.genes2samplesvaluescopy, this.clinicalValues, this.otherValues, this.utils)}));
                }
            } else {
                ErrorDialog ed = new ErrorDialog(this.utils, "Load mutation table AND clinical table before running the algorithm.");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                System.out.println("Load Table!");
            }
        }
    }

    public void handleSampleValues(ArrayList<String[]> samples) {
        for (int i = 0; i < samples.size(); ++i) {
            if (samples.get(i)[1] == null || !samples.get(i)[1].equals(" ")) continue;
            samples.get((int)i)[1] = "no_sample";
        }
    }

    public boolean handleSurvivalExceptions() {
        boolean valid = true;
        HashSet<String> vitals = new HashSet<String>();
        for (int i = 0; i < this.clinicalValues.size(); ++i) {
            if (this.clinicalValues.get(i)[1] != null && !this.clinicalValues.get(i)[1].isEmpty()) {
                vitals.add(this.clinicalValues.get(i)[1]);
            }
            if (vitals.size() > 2) {
                ErrorDialog ed = new ErrorDialog(this.utils, "INPUT ERROR: Vital Status must be either DECEASED or ALIVE");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                System.out.println("INPUT ERROR: Vital Status must be either DECEASED or ALIVE");
                return false;
            }
            if (this.clinicalValues.get(i)[2] == null || this.clinicalValues.get(i)[2].equals("NA")) continue;
            try {
                Double.valueOf(this.clinicalValues.get(i)[2]);
                continue;
            }
            catch (Exception e) {
                valid = false;
            }
        }
        if (!valid) {
            ErrorDialog ed = new ErrorDialog(this.utils, "INPUT ERROR: All followup times entries must be a number");
            ed.setLocationRelativeTo(null);
            ed.setVisible(true);
            System.out.println("INPUT ERROR: All followup times entries must be a number");
        }
        return valid;
    }

    public boolean handleClinicalVariableExceptions() {
        boolean valid = true;
        HashSet<String> variables = new HashSet<String>();
        for (int i = 0; i < this.otherValues.size(); ++i) {
            if (this.otherValues.get(i)[1] != null) {
                if (this.otherValues.isEmpty()) {
                    this.otherValues.remove(i);
                } else {
                    variables.add(this.otherValues.get(i)[1]);
                }
            }
            if (variables.size() <= 20) continue;
            ErrorDialog ed = new ErrorDialog(this.utils, "INPUT ERROR: Please pick a clinical variable with fewer categories");
            ed.setLocationRelativeTo(null);
            ed.setVisible(true);
            System.out.println("INPUT ERROR: Please pick a clinical variable with fewer categories");
            return false;
        }
        System.out.println("Number of fisher categories: " + variables.size());
        return valid;
    }

    public void sortClinicalTable(int col) {
        ArrayList<String[]> newTable = new ArrayList<String[]>();
        if (this.logRank.isSelected()) {
            String[] h = new String[]{"Patient ID", "Vital", "Followup Times"};
            MyModel nm = new MyModel(h);
            if (col == 2) {
                ArrayListMultimap mds = ArrayListMultimap.create();
                ArrayList<Double> ad = new ArrayList<Double>();
                HashSet<Double> gg = new HashSet<Double>();
                for (int i = 0; i < this.clinicalValues.size(); ++i) {
                    gg.add(Double.valueOf(this.clinicalValues.get(i)[2]));
                    String[] entry = new String[]{this.clinicalValues.get(i)[0], this.clinicalValues.get(i)[1]};
                    mds.put((Object)Double.valueOf(this.clinicalValues.get(i)[2]), (Object)entry);
                }
                for (Double d : gg) {
                    ad.add(d);
                }
                Collections.sort(ad);
                for (int i = 0; i < ad.size(); ++i) {
                    for (String[] sd : mds.get(ad.get(i))) {
                        String[] newEntry = new String[]{sd[0], sd[1], String.valueOf(ad.get(i))};
                        newTable.add(newEntry);
                    }
                }
            } else {
                ArrayListMultimap mds = ArrayListMultimap.create();
                ArrayList<String> ad = new ArrayList<String>();
                HashSet<String> gg = new HashSet<String>();
                for (int i = 0; i < this.clinicalValues.size(); ++i) {
                    String[] entry;
                    if (col == 0) {
                        gg.add(this.clinicalValues.get(i)[0]);
                        entry = new String[]{this.clinicalValues.get(i)[1], this.clinicalValues.get(i)[2]};
                        mds.put((Object)this.clinicalValues.get(i)[0], (Object)entry);
                        continue;
                    }
                    if (col != 1) continue;
                    gg.add(this.clinicalValues.get(i)[1]);
                    entry = new String[]{this.clinicalValues.get(i)[0], this.clinicalValues.get(i)[2]};
                    mds.put((Object)this.clinicalValues.get(i)[1], (Object)entry);
                }
                for (String s : gg) {
                    ad.add(s);
                }
                Collections.sort(ad);
                for (int i = 0; i < ad.size(); ++i) {
                    for (String[] sd : mds.get(ad.get(i))) {
                        String[] newEntry = new String[3];
                        if (col == 0) {
                            newEntry[0] = (String)ad.get(i);
                            newEntry[1] = sd[0];
                            newEntry[2] = sd[1];
                        } else if (col == 1) {
                            newEntry[0] = sd[0];
                            newEntry[1] = (String)ad.get(i);
                            newEntry[2] = sd[1];
                        }
                        newTable.add(newEntry);
                    }
                }
            }
            this.clinicalValues = newTable;
            nm.AddCSVData(this.clinicalValues);
            this.clinicalTable = new JTable();
            this.clinicalTable.setModel(nm);
            this.variableHeader = this.clinicalTable.getTableHeader();
            this.variableHeader.addMouseListener(this);
            this.clinicalScrollPane.setViewportView(this.clinicalTable);
        } else {
            String[] h = new String[]{"Patient ID", "Clinical Variable"};
            MyModel nm = new MyModel(h);
            ArrayListMultimap mss = ArrayListMultimap.create();
            ArrayList<String> ad = new ArrayList<String>();
            HashSet<String> gg = new HashSet<String>();
            for (int i = 0; i < this.otherValues.size(); ++i) {
                if (col == 0) {
                    gg.add(this.otherValues.get(i)[0]);
                    mss.put((Object)this.otherValues.get(i)[0], (Object)this.otherValues.get(i)[1]);
                    continue;
                }
                if (col != 1) continue;
                gg.add(this.otherValues.get(i)[1]);
                mss.put((Object)this.otherValues.get(i)[1], (Object)this.otherValues.get(i)[0]);
            }
            for (String s : gg) {
                ad.add(s);
            }
            Collections.sort(ad);
            for (int i = 0; i < ad.size(); ++i) {
                for (String sd : mss.get(ad.get(i))) {
                    String[] newEntry = new String[2];
                    if (col == 0) {
                        newEntry[0] = (String)ad.get(i);
                        newEntry[1] = sd;
                    }
                    if (col == 1) {
                        newEntry[0] = sd;
                        newEntry[1] = (String)ad.get(i);
                    }
                    newTable.add(newEntry);
                }
            }
            this.otherValues = newTable;
            nm.AddCSVData(this.otherValues);
            this.clinicalTable = new JTable();
            this.clinicalTable.setModel(nm);
            this.variableHeader = this.clinicalTable.getTableHeader();
            this.variableHeader.addMouseListener(this);
            this.clinicalScrollPane.setViewportView(this.clinicalTable);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        int col;
        if (arg0.getSource() == this.variableHeader && this.allClinicalData != null) {
            col = this.clinicalTable.columnAtPoint(arg0.getPoint());
            this.sortClinicalTable(col);
        }
        if (arg0.getSource() == this.mutationHeader) {
            ArrayListMultimap reference;
            col = this.allGeneSamples.columnAtPoint(arg0.getPoint());
            if (this.genes2samplesvalues != null && col == 1) {
                reference = ArrayListMultimap.create();
                for (int i = 0; i < this.genes2samplesvalues.size(); ++i) {
                    reference.put((Object)this.genes2samplesvalues.get(i)[1], (Object)this.genes2samplesvalues.get(i)[0]);
                }
                ArrayList<String> keys = new ArrayList<String>();
                HashSet<String> gg = new HashSet<String>();
                for (int i = 0; i < this.genes2samplesvalues.size(); ++i) {
                    gg.add(this.genes2samplesvalues.get(i)[1]);
                }
                for (String s : gg) {
                    keys.add(s);
                }
                Collections.sort(keys);
                this.newGeneTable = new ArrayList();
                for (int i = 0; i < keys.size(); ++i) {
                    for (String value : reference.get(keys.get(i))) {
                        String[] entry = new String[2];
                        entry[1] = (String)keys.get(i);
                        entry[0] = value;
                        this.newGeneTable.add(entry);
                    }
                }
                MyModel NewModel = null;
                if (this.headers.isSelected()) {
                    NewModel = new MyModel(this.header);
                } else {
                    String[] c = new String[]{"genes", "samples"};
                    NewModel = new MyModel(c);
                }
                NewModel.AddCSVData(this.newGeneTable);
                this.allGeneSamples = new JTable();
                this.allGeneSamples.setModel(NewModel);
                this.resetSamplePanel(this.allGeneSamples);
                this.state = 0;
            }
            if (this.genes2samplesvalues != null && col == 0 && this.state == 2) {
                MyModel NewModel = null;
                if (this.headers.isSelected()) {
                    NewModel = new MyModel(this.header);
                } else {
                    String[] c = new String[]{"genes", "samples"};
                    NewModel = new MyModel(c);
                }
                NewModel.AddCSVData(this.genes2samplesvalues);
                this.allGeneSamples = new JTable();
                this.allGeneSamples.setModel(NewModel);
                this.resetSamplePanel(this.allGeneSamples);
                this.state = 0;
            }
            if (this.genes2samplesvalues != null && col == 0 && this.state == 1) {
                ArrayList<String[]> newGeneTableReversed = new ArrayList<String[]>();
                for (int i = this.newGeneTable.size() - 1; i >= 0; --i) {
                    newGeneTableReversed.add(this.newGeneTable.get(i));
                }
                MyModel NewModel = null;
                if (this.headers.isSelected()) {
                    NewModel = new MyModel(this.header);
                } else {
                    String[] c = new String[]{"genes", "samples"};
                    NewModel = new MyModel(c);
                }
                NewModel.AddCSVData(newGeneTableReversed);
                this.allGeneSamples = new JTable();
                this.allGeneSamples.setModel(NewModel);
                this.resetSamplePanel(this.allGeneSamples);
                this.state = 2;
            }
            if (this.genes2samplesvalues != null && col == 0 && this.state == 0) {
                int i;
                reference = ArrayListMultimap.create();
                for (int i2 = 0; i2 < this.genes2samplesvalues.size(); ++i2) {
                    reference.put((Object)this.genes2samplesvalues.get(i2)[0], (Object)this.genes2samplesvalues.get(i2)[1]);
                }
                ArrayList<String> keys = new ArrayList<String>();
                for (i = 0; i < this.genes2samplesvalues.size(); ++i) {
                    keys.add(this.genes2samplesvalues.get(i)[0]);
                }
                Collections.sort(keys);
                this.newGeneTable = new ArrayList();
                for (i = 0; i < keys.size(); ++i) {
                    for (String value : reference.get(keys.get(i))) {
                        String[] entry = new String[]{(String)keys.get(i), value};
                        this.newGeneTable.add(entry);
                    }
                }
                MyModel NewModel = null;
                if (this.headers.isSelected()) {
                    NewModel = new MyModel(this.header);
                } else {
                    String[] c = new String[]{"genes", "samples"};
                    NewModel = new MyModel(c);
                }
                NewModel.AddCSVData(this.newGeneTable);
                this.allGeneSamples = new JTable();
                this.allGeneSamples.setModel(NewModel);
                this.resetSamplePanel(this.allGeneSamples);
                this.state = 1;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private class MyModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames;
        private ArrayList<String[]> data = new ArrayList();

        public MyModel(String[] columns) {
            this.columnNames = columns;
        }

        public void AddCSVData(ArrayList<String[]> DataIn) {
            this.data = DataIn;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data.get(row)[col];
        }
    }

    public class CSVFile {
        private ArrayList<String[]> Rs = new ArrayList();
        private String[] OneRow;

        public ArrayList<String[]> ReadCSVfile(File DataFile2) {
            try {
                BufferedReader brd = new BufferedReader(new FileReader(DataFile2));
                String st = brd.readLine();
                while (st != null) {
                    this.OneRow = st.split(",|;|\t");
                    if (this.OneRow.length < 2) {
                        int y;
                        String[] newRow = new String[2];
                        for (y = 0; y < this.OneRow.length; ++y) {
                            newRow[y] = this.OneRow[y];
                        }
                        for (y = 0; y < newRow.length; ++y) {
                            if (newRow[y] != null) continue;
                            newRow[y] = " ";
                        }
                        this.OneRow = newRow;
                    }
                    this.Rs.add(this.OneRow);
                    st = brd.readLine();
                }
            }
            catch (Exception e) {
                String errmsg = e.getMessage();
                System.out.println("File not found:" + errmsg);
            }
            return this.Rs;
        }
    }
}

