/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.events.NetworkDestroyedListener;

public class NetworkSelectionPanel
extends JPanel
implements NetworkAddedListener,
NetworkDestroyedListener {
    private static final long serialVersionUID = 1L;
    private JComboBox comboBox;
    private CytoscapeUtils utils;

    public NetworkSelectionPanel(CytoscapeUtils utils) {
        this.utils = utils;
        this.comboBox = new JComboBox();
        this.add((Component)this.comboBox, "Center");
        this.comboBox.setPreferredSize(new Dimension(200, 23));
        this.comboBox.setMaximumSize(new Dimension(200, 23));
        this.updateNetworkList();
    }

    private void updateNetworkList() {
        Set networks = this.utils.netMgr.getNetworkSet();
        TreeSet<Object> networkNames = new TreeSet<Object>();
        for (CyNetwork cyNetwork : networks) {
            networkNames.add(cyNetwork.getRow((CyIdentifiable)cyNetwork).get("name", String.class));
        }
        this.comboBox.setModel(new DefaultComboBoxModel());
        for (String string : networkNames) {
            this.comboBox.addItem(string);
        }
        CyNetwork currNetwork = this.utils.appMgr.getCurrentNetwork();
        if (currNetwork != null) {
            String string = (String)currNetwork.getRow((CyIdentifiable)currNetwork).get("name", String.class);
            this.comboBox.setSelectedItem(string);
        }
    }

    public CyNetwork getSelectedNetwork() {
        for (CyNetwork net : this.utils.netMgr.getNetworkSet()) {
            String networkTitle = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
            if (!networkTitle.equals(this.comboBox.getSelectedItem())) continue;
            return net;
        }
        return null;
    }

    public JComboBox getJCombobox() {
        return this.comboBox;
    }

    public void handleEvent(NetworkDestroyedEvent nde) {
        System.out.println("network destroyed!");
        this.updateNetworkList();
    }

    public void handleEvent(NetworkAddedEvent nae) {
        System.out.println("network added!");
        this.updateNetworkList();
    }
}

