/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.statistics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class ConnectR {
    private double[] followupDays;
    private double[] censor;
    private double[] group;
    private double[] age;
    private HashMap<String, Double> this_true;
    private Multimap<String, Double> this_rand;
    private int[][] contingencyTable;

    public ConnectR(HashMap<String, Double> this_true, Multimap<String, Double> this_rand) {
        this.this_true = this_true;
        this.this_rand = this_rand;
    }

    public ConnectR(double[] followupDays, double[] censor, double[] group, double[] age) {
        this.followupDays = followupDays;
        this.censor = censor;
        this.group = group;
        this.age = age;
    }

    public ConnectR(int[][] contingencyTable) {
    }

    public double fisher() throws REngineException {
        double p = 0.0;
        return p;
    }

    public double coxph() throws REngineException {
        double p = 0.0;
        try {
            RConnection c = new RConnection();
            c.assign("time", this.followupDays);
            c.assign("censor", this.censor);
            c.assign("covariate1", this.group);
            c.assign("covariate2", this.age);
            c.eval("library(survival)");
            c.eval("dfr = data.frame(time, censor, covariate1, covariate2)");
            c.eval("surv = Surv(dfr$time, dfr$censor)");
            c.eval("cox1 = coxph(surv ~ covariate1 + covariate2, data = dfr)$loglik[2]");
            c.eval("cox2 = coxph(surv ~ covariate2, data = dfr)$loglik[2]");
            c.eval("p = pchisq(2*(cox1-cox2), 1, lower.tail=F)");
            p = c.eval("p").asDouble();
            return p;
        }
        catch (RserveException e) {
            e.printStackTrace();
        }
        catch (REXPMismatchException e) {
            e.printStackTrace();
        }
        return p;
    }

    public HashMap<String, Double> fdrAdjust() throws REngineException, REXPMismatchException {
        HashMap<String, Double> adjustedResults = new HashMap<String, Double>();
        try {
            RConnection c = new RConnection();
            REXP x = c.eval("R.version.string");
            System.out.println(x.asString());
            HashMap<Double, String> reversedResults = new HashMap<Double, String>();
            ArrayListMultimap reversedRandomResults = ArrayListMultimap.create();
            for (String reverse : this.this_true.keySet()) {
                reversedResults.put(this.this_true.get(reverse), reverse);
            }
            for (String reverse : this.this_rand.keySet()) {
                for (Double doubleAdd : this.this_rand.get((Object)reverse)) {
                    reversedRandomResults.put((Object)doubleAdd, (Object)reverse);
                }
            }
            double[] resultDoubles = new double[this.this_true.size()];
            ArrayList<Double> randomResultDoubles = new ArrayList<Double>();
            int k = 0;
            for (String result : this.this_true.keySet()) {
                resultDoubles[k] = this.this_true.get(result);
                ++k;
            }
            for (String result : this.this_rand.keySet()) {
                for (Double d : this.this_rand.get((Object)result)) {
                    randomResultDoubles.add(d);
                }
            }
            double[] randomz = new double[randomResultDoubles.size()];
            for (int i = 0; i < randomResultDoubles.size(); ++i) {
                randomz[i] = (Double)randomResultDoubles.get(i);
            }
            c.assign("this_true", resultDoubles);
            c.assign("this_rand", randomz);
            c.eval("this_true_est = p.adjust(sapply(this_true, function(x) length(which(x>=this_rand))/length(this_rand)), method=\"fdr\")");
            double[] adjustedDoubles = c.eval("this_true_est").asDoubles();
            for (int i = 0; i < adjustedDoubles.length; ++i) {
                adjustedResults.put((String)reversedResults.get(resultDoubles[i]), adjustedDoubles[i]);
            }
        }
        catch (RserveException e) {
            e.printStackTrace();
        }
        return adjustedResults;
    }
}

