/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.task;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class VisualizeNetworkTask
extends AbstractTask
implements Task {
    private CytoscapeUtils utils;
    private String input;
    private CyNetwork runNetwork;

    public VisualizeNetworkTask(CytoscapeUtils utils, String s) {
        this.utils = utils;
        this.input = s;
    }

    public void cancel() {
    }

    public void run(TaskMonitor tm) throws Exception {
        System.out.println("visualizing network...");
        this.runNetwork = this.utils.appMgr.getCurrentNetwork();
        String[] inputStrings = this.input.split(",");
        HashMap inputNodes = new HashMap();
        List cc = this.runNetwork.getNodeList();
        CyNode seed = null;
        for (int k = 0; k < cc.size(); ++k) {
            if (!inputStrings[0].equals(this.runNetwork.getRow((CyIdentifiable)cc.get(k)).get("name", String.class))) continue;
            seed = (CyNode)cc.get(k);
        }
        long seedID = seed.getSUID();
        String seedString = (String)this.runNetwork.getRow(seed).get("name", String.class);
        if (seed == null) {
            return;
        }
        HashSet<String> inputHash = new HashSet<String>();
        for (int i = 0; i < inputStrings.length; ++i) {
            inputHash.add(inputStrings[i]);
        }
        for (String s : inputHash) {
            System.out.println(s);
        }
        System.out.println("|");
        CyNetwork generated = this.utils.networkFactory.createNetwork();
        HashSet<String> myNetNames = new HashSet<String>();
        seed = generated.addNode();
        generated.getRow((CyIdentifiable)seed).set("name", (Object)seedString);
        long mySeedID = seed.getSUID();
        myNetNames.add(seedString);
        seed = this.runNetwork.getNode(seedID);
        for (CyEdge edge : this.runNetwork.getAdjacentEdgeList(seed, CyEdge.Type.ANY)) {
            seed = generated.getNode(mySeedID);
            CyNode target = edge.getTarget();
            long targetID = target.getSUID();
            String targetString = (String)this.runNetwork.getRow((CyIdentifiable)target).get("name", String.class);
            if (inputHash.contains(targetString)) {
                String innerTargetName;
                CyNode innerTarget;
                long myTargetID;
                if (!myNetNames.contains(targetString)) {
                    target = generated.addNode();
                    generated.getRow((CyIdentifiable)target).set("name", (Object)targetString);
                    myNetNames.add(targetString);
                    generated.addEdge(seed, target, true);
                    myTargetID = target.getSUID();
                    target = this.runNetwork.getNode(targetID);
                    for (CyEdge innerEdge : this.runNetwork.getAdjacentEdgeList(target, CyEdge.Type.ANY)) {
                        innerTarget = innerEdge.getTarget();
                        innerTargetName = (String)this.runNetwork.getRow((CyIdentifiable)innerTarget).get("name", String.class);
                        if (!inputHash.contains(innerTargetName)) continue;
                        target = generated.getNode(myTargetID);
                        if (!myNetNames.contains(innerTargetName)) {
                            innerTarget = generated.addNode();
                            generated.addEdge(target, innerTarget, true);
                            generated.getRow((CyIdentifiable)innerTarget).set("name", (Object)innerTargetName);
                            myNetNames.add(innerTargetName);
                        } else {
                            for (CyNode e : generated.getNodeList()) {
                                if (!innerTargetName.equals(generated.getRow((CyIdentifiable)e).get("name", String.class))) continue;
                                innerTarget = e;
                            }
                            if (!generated.containsEdge(target, innerTarget)) {
                                generated.addEdge(target, innerTarget, true);
                            }
                        }
                        target = this.runNetwork.getNode(targetID);
                    }
                } else {
                    for (CyNode c : generated.getNodeList()) {
                        if (!targetString.equals(generated.getRow((CyIdentifiable)c).get("name", String.class))) continue;
                        target = c;
                    }
                    myTargetID = target.getSUID();
                    if (!generated.containsEdge(seed, target)) {
                        generated.addEdge(seed, target, true);
                    }
                    target = this.runNetwork.getNode(targetID);
                    for (CyEdge innerEdge : this.runNetwork.getAdjacentEdgeList(target, CyEdge.Type.ANY)) {
                        innerTarget = innerEdge.getTarget();
                        innerTargetName = (String)this.runNetwork.getRow((CyIdentifiable)innerTarget).get("name", String.class);
                        if (!inputHash.contains(innerTargetName)) continue;
                        target = generated.getNode(myTargetID);
                        if (!myNetNames.contains(innerTargetName)) {
                            innerTarget = generated.addNode();
                            generated.addEdge(target, innerTarget, true);
                            generated.getRow((CyIdentifiable)innerTarget).set("name", (Object)innerTargetName);
                            myNetNames.add(innerTargetName);
                        } else {
                            for (CyNode d : generated.getNodeList()) {
                                if (!innerTargetName.equals(generated.getRow((CyIdentifiable)d).get("name", String.class))) continue;
                                innerTarget = d;
                            }
                            if (!generated.containsEdge(target, innerTarget)) {
                                generated.addEdge(target, innerTarget, true);
                            }
                        }
                        target = this.runNetwork.getNode(targetID);
                    }
                }
            }
            seed = this.runNetwork.getNode(seedID);
        }
        generated.getDefaultNetworkTable().getRow((Object)generated.getSUID()).set("name", (Object)this.utils.networkNaming.getSuggestedNetworkTitle("Visualization"));
        this.utils.netMgr.addNetwork(generated);
        CyNetworkView myView = this.utils.netViewFactory.createNetworkView(generated);
        this.utils.netViewMgr.addNetworkView(myView);
        VisualStyle vs = this.utils.visualStyleFactoryServiceRef.createVisualStyle("My Visual Style");
        String ctrAttrName1 = "name";
        PassthroughMapping pMapping = (PassthroughMapping)this.utils.vmfFactoryP.createVisualMappingFunction(ctrAttrName1, String.class, BasicVisualLexicon.NODE_LABEL);
        vs.addVisualMappingFunction((VisualMappingFunction)pMapping);
        vs.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)Color.orange);
        this.utils.vmmServiceRef.addVisualStyle(vs);
        vs.apply(myView);
        myView.updateView();
        CyLayoutAlgorithm layout = this.utils.cyLayoutManager.getLayout("attribute-circle");
        String layoutAttribute = null;
        this.insertTasksAfterCurrentTask(layout.createTaskIterator(myView, layout.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, layoutAttribute));
    }
}

