/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import jsc.curvefitting.LineFit;
import jsc.datastructures.PairedData;
import jsc.numerical.Function;
import jsc.numerical.NumericalException;
import jsc.numerical.Roots;

public class ExponentialFit {
    private final int MAX_STEPS = 1000;
    private final int N_INTERVALS = 20;
    private final double INTERVAL = 0.05;
    private final int n;
    private final double[] x;
    private final double[] y;
    private final double[] p;
    private double a;
    private double b;
    private double ab;
    private double eb;
    private int k;
    private double h1;
    private double h2;
    private double h3;
    private double h4;
    private double h5;
    private double h6;
    private double h7;
    private double h8;
    private double b1;
    private double b2;
    private double F1;
    private double F2;
    private double F3;
    private double F4;
    private double h;

    public ExponentialFit(PairedData pairedData, double[] dArray, double d) {
        this.n = pairedData.getN();
        this.x = pairedData.getX();
        this.y = pairedData.getY();
        if (dArray == null) {
            this.p = new double[this.n];
            int n = 0;
            while (n < this.n) {
                this.p[n] = 1.0;
                ++n;
            }
        } else {
            if (this.n != dArray.length) {
                throw new IllegalArgumentException("Weights array is wrong length.");
            }
            this.p = dArray;
        }
        if (!this.abfit(d, this.ab, this.eb, false) && !this.abfit(d, this.ab, this.eb, true)) {
            LineFit lineFit = new LineFit(pairedData, this.p);
            this.a = lineFit.getA();
            if (this.a == 0.0) {
                throw new IllegalArgumentException("Unable to fit an exponential curve to these data.");
            }
            double d2 = lineFit.getB();
            this.b = -Math.log((this.a + d2) / this.a);
        }
    }

    public ExponentialFit(PairedData pairedData, double d) {
        this(pairedData, null, d);
    }

    private boolean abfit(double d, double d2, double d3, boolean bl) {
        FbFunction fbFunction = new FbFunction();
        if (bl) {
            try {
                this.b = Roots.secant(fbFunction, d2, d3, d, 1000);
            }
            catch (NumericalException numericalException) {
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return true;
        }
        this.h1 = 0.0;
        this.h2 = 0.0;
        this.h3 = 0.0;
        this.h4 = 0.0;
        this.h5 = 0.0;
        int n = 0;
        while (n < this.n) {
            if (this.y[n] <= 0.0) {
                throw new IllegalArgumentException("Y data not all positive.");
            }
            this.h8 = Math.log(this.y[n]);
            this.h6 = this.p[n] * this.y[n] * this.y[n];
            this.h7 = this.h6 * this.x[n];
            this.h1 += this.h6;
            this.h2 += this.h7 * this.x[n];
            this.h3 += this.h7;
            this.h4 += this.h7 * this.h8;
            this.h5 += this.h6 * this.h8;
            ++n;
        }
        this.h8 = 1.0 / (this.h1 * this.h2 - this.h3 * this.h3);
        this.b1 = this.b = -this.h8 * (this.h1 * this.h4 - this.h3 * this.h5);
        this.b2 = this.b;
        this.h = 0.0;
        this.F1 = this.Fb(this.b);
        if (this.F1 == 0.0) {
            return true;
        }
        this.F2 = this.F1;
        n = 1;
        while (n <= 20) {
            this.h += 0.05;
            d2 = this.b1 * (1.0 - this.h);
            this.F3 = this.Fb(d2);
            if (this.F1 * this.F3 < 0.0) {
                d3 = this.b1;
                try {
                    this.b = Roots.secant(fbFunction, d2, d3, d, 1000);
                }
                catch (NumericalException numericalException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                return true;
            }
            d3 = this.b2 * (1.0 + this.h);
            this.F4 = this.Fb(d3);
            if (this.F2 * this.F4 < 0.0) {
                d2 = this.b2;
                try {
                    this.b = Roots.secant(fbFunction, d2, d3, d, 1000);
                }
                catch (NumericalException numericalException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                return true;
            }
            this.b1 = d2;
            this.b2 = d3;
            this.F1 = this.F3;
            this.F2 = this.F4;
            ++n;
        }
        return false;
    }

    private double Fb(double d) {
        this.h1 = 0.0;
        this.h2 = 0.0;
        this.h3 = 0.0;
        this.h4 = 0.0;
        int n = 0;
        while (n < this.n) {
            this.h5 = Math.exp(-d * this.x[n]);
            this.h6 = this.p[n] * this.y[n];
            this.h8 = this.h5 * this.h6;
            this.h7 = this.p[n] * this.h5 * this.h5;
            this.h1 += this.h8;
            this.h2 += this.h7;
            this.h3 += this.x[n] * this.h8;
            this.h4 += this.x[n] * this.h7;
            ++n;
        }
        this.a = this.h1 / this.h2;
        return this.h3 * this.h2 - this.h1 * this.h4;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public int getN() {
        return this.n;
    }

    class FbFunction
    implements Function {
        FbFunction() {
        }

        public double function(double d) {
            return ExponentialFit.this.Fb(d);
        }
    }
}

