/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import jsc.curvefitting.StraightLineFit;
import jsc.datastructures.PairedData;
import jsc.numerical.NumericalException;

public class LpNormFit
implements StraightLineFit {
    private final int n;
    private double a;
    private double b;
    private double p;
    private double sd;
    private double[] r;

    public LpNormFit(double d, PairedData pairedData, double d2, int n) throws NumericalException {
        double d3 = 0.0;
        double d4 = 0.0;
        this.n = pairedData.getN();
        double[] dArray = pairedData.getX();
        double[] dArray2 = pairedData.getY();
        if (this.n < 2) {
            throw new IllegalArgumentException("Less than 2 observations.");
        }
        double d5 = d - 2.0;
        double d6 = 2.0 * d2;
        this.sd = 0.0;
        this.r = new double[this.n];
        int n2 = 0;
        while (n2 < this.n) {
            this.r[n2] = 1.0;
            ++n2;
        }
        int n3 = 1;
        while (n3 <= n) {
            double d7;
            int n4 = 0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            n2 = 0;
            while (n2 < this.n) {
                d7 = Math.abs(this.r[n2]);
                if (d7 <= d2) {
                    ++n4;
                } else {
                    double d13 = Math.pow(d7, d5);
                    double d14 = d13 / (d8 += d13);
                    double d15 = dArray[n2] - d9;
                    double d16 = dArray2[n2] - d10;
                    double d17 = d15 * d13;
                    double d18 = d15 * d17;
                    double d19 = d16 * d17;
                    d11 += d18 - d18 * d14;
                    d12 += d19 - d19 * d14;
                    d9 += d15 * d14;
                    d10 += d16 * d14;
                }
                ++n2;
            }
            if (d11 < d2) {
                throw new NumericalException("Weighted sample variance of x is zero.");
            }
            this.b = d12 / d11;
            this.a = d10 - this.b * d9;
            double d20 = 0.0;
            boolean bl = false;
            n2 = 0;
            while (n2 < this.n) {
                double d21 = dArray2[n2] - (this.a + this.b * dArray[n2]);
                d7 = Math.abs(d21);
                if (Math.abs(d7 - Math.abs(this.r[n2])) > d6) {
                    bl = true;
                }
                d20 += Math.pow(d7, d);
                this.r[n2] = d21;
                ++n2;
            }
            double d22 = Math.abs(d20 - this.sd) / d20;
            if (!bl) {
                return;
            }
            if (n3 != 1 && d20 > this.sd) {
                this.a = d3;
                this.b = d4;
                n2 = 0;
                while (n2 < this.n) {
                    this.r[n2] = dArray2[n2] - (this.a + this.b * dArray[n2]);
                    ++n2;
                }
                return;
            }
            this.sd = d20;
            d3 = this.a;
            d4 = this.b;
            ++n3;
        }
        throw new NumericalException("Maximum number of iterations exceeded.");
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public int getN() {
        return this.n;
    }

    public double getNorm() {
        return this.sd;
    }

    public double getP() {
        return this.b;
    }

    public double[] getResiduals() {
        return this.r;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) throws NumericalException {
            double[] dArray = new double[]{0.2, 0.5, 0.9, 1.4, 2.1, 2.7, 3.0, 3.6, 4.1, 4.4, 5.0, 5.6, 6.2, 6.6, 7.1};
            double[] dArray2 = new double[]{50.0, 48.0, 42.0, 36.0, 34.0, 32.0, 29.0, 31.0, 28.0, 24.0, 19.0, 17.0, 10.0, 12.0, 9.5};
            LpNormFit lpNormFit = new LpNormFit(1.0, new PairedData(dArray, dArray2), 1.0E-16, 50);
            int n = lpNormFit.getN();
            double d = lpNormFit.getA();
            double d2 = lpNormFit.getB();
            System.out.println("n = " + n);
            System.out.println("a = " + d);
            System.out.println("b = " + d2);
            System.out.println("Norm = " + lpNormFit.getNorm());
            double[] dArray3 = lpNormFit.getResiduals();
            int n2 = 0;
            while (n2 < n) {
                System.out.println(dArray3[n2] + " " + (dArray2[n2] - (d + d2 * dArray[n2])));
                ++n2;
            }
        }
    }
}

