/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

import jsc.descriptive.AbstractFrequencyTable;
import jsc.descriptive.DoubleFrequencyTable;

public class IrregularFrequencyTable
extends AbstractFrequencyTable
implements DoubleFrequencyTable,
Cloneable {
    double[] boundaries;

    public IrregularFrequencyTable(String string, double[] dArray, double[] dArray2) {
        this(string, dArray);
        int n = 0;
        while (n < dArray2.length) {
            this.addValue(dArray2[n]);
            ++n;
        }
        if (this.n < 1) {
            throw new IllegalArgumentException("No data values.");
        }
    }

    public IrregularFrequencyTable(String string, double[] dArray) {
        super(string);
        this.numberOfBins = dArray.length - 1;
        this.boundaries = dArray;
        this.n = 0;
        this.freq = new int[this.numberOfBins];
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = 0;
            ++n;
        }
    }

    public IrregularFrequencyTable(String string, double[] dArray, int[] nArray) {
        this(string, dArray);
        if (nArray.length != this.numberOfBins) {
            throw new IllegalArgumentException("Number of frequencies should be one less than number of boundaries.");
        }
        int n = 0;
        while (n < this.numberOfBins) {
            this.freq[n] = nArray[n];
            this.n += nArray[n];
            ++n;
        }
        if (this.n < 1) {
            throw new IllegalArgumentException("No data values.");
        }
    }

    public int addValue(double d) {
        int n = 0;
        while (n < this.numberOfBins) {
            if (this.boundaries[n] <= d && d < this.boundaries[n + 1]) {
                ++this.n;
                int n2 = n;
                this.freq[n2] = this.freq[n2] + 1;
                return n;
            }
            ++n;
        }
        if (d == this.boundaries[this.numberOfBins]) {
            n = this.numberOfBins - 1;
            ++this.n;
            int n3 = n;
            this.freq[n3] = this.freq[n3] + 1;
            return n;
        }
        return -1;
    }

    public int addValues(double[] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (this.addValue(dArray[n2]) >= 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public double getBoundary(int n) {
        return this.boundaries[n];
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("IrregularFrequencyTable can't clone");
        }
        return object;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{72.2, 64.0, 53.4, 76.8, 86.3, 58.1, 63.2, 73.1, 78.0, 44.3, 85.1, 66.6, 80.4, 76.0, 68.8, 76.8, 58.9, 58.1, 74.9, 72.2, 73.1, 39.3, 52.8, 54.2, 65.3, 74.0, 63.2, 64.7, 68.8, 85.1, 62.2, 76.0, 70.5, 48.9, 78.0, 66.6, 58.1, 32.5, 63.2, 64.0, 68.8, 65.3, 71.9, 72.2, 63.2, 72.2, 70.5, 80.4, 45.4, 59.6};
            double[] dArray2 = new double[]{0.0, 40.0, 50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 100.0};
            IrregularFrequencyTable irregularFrequencyTable = new IrregularFrequencyTable("Table", dArray2, dArray);
            int[] nArray = new int[]{2, 3, 3, 5, 8, 7, 11, 11};
            System.out.println("Frequency table " + irregularFrequencyTable.getN() + " values");
            int n = 0;
            while (n < irregularFrequencyTable.getNumberOfBins()) {
                System.out.println(irregularFrequencyTable.getBoundary(n) + " to " + irregularFrequencyTable.getBoundary(n + 1) + ", Freq = " + irregularFrequencyTable.getFrequency(n) + ", % = " + irregularFrequencyTable.getPercentage(n));
                ++n;
            }
        }
    }
}

