/*
 * Decompiled with CFR 0.152.
 */
package jsc.descriptive;

public class MeanVar
implements Cloneable {
    private int n;
    private double mean;
    private double variance;

    public MeanVar(double[] dArray) {
        double d = 0.0;
        this.n = dArray.length;
        if (this.n < 2) {
            throw new IllegalArgumentException("Less than two data values.");
        }
        int n = 0;
        while (n < this.n) {
            d += dArray[n];
            ++n;
        }
        this.mean = d / (double)this.n;
        d = 0.0;
        n = 0;
        while (n < this.n) {
            d += (dArray[n] - this.mean) * (dArray[n] - this.mean);
            ++n;
        }
        this.variance = d / (double)(this.n - 1);
    }

    public MeanVar(double d) {
        this.n = 1;
        this.mean = d;
        this.variance = 0.0;
    }

    public void addValue(double d) {
        double d2 = this.mean;
        this.mean = d2 + (d - d2) / ((double)this.n + 1.0);
        this.variance = (1.0 - 1.0 / (double)this.n) * this.variance + (this.mean - d2) * (this.mean - d2) * ((double)this.n + 1.0);
        ++this.n;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("MeanVar can't clone");
        }
        return object;
    }

    public double getMean() {
        return this.mean;
    }

    public int getN() {
        return this.n;
    }

    public double getSd() {
        return Math.sqrt(this.variance);
    }

    public double getVariance() {
        return this.variance;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{73.0, 62.7, 59.3, 68.2};
            MeanVar meanVar = new MeanVar(dArray);
            System.out.println("n = " + meanVar.getN());
            System.out.println("Mean = " + meanVar.getMean());
            System.out.println("Variance = " + meanVar.getVariance());
            System.out.println("s.d. = " + meanVar.getSd());
            MeanVar meanVar2 = new MeanVar(73.0);
            meanVar2.addValue(62.7);
            meanVar2.addValue(59.3);
            meanVar2.addValue(68.2);
            System.out.println("n = " + meanVar2.getN());
            System.out.println("Mean = " + meanVar2.getMean());
            System.out.println("Variance = " + meanVar2.getVariance());
            System.out.println("s.d. = " + meanVar2.getSd());
            double[] dArray2 = new double[]{7.000001, 7.000002, 7.000003, 7.000004, 7.000005};
            MeanVar meanVar3 = new MeanVar(dArray2);
            System.out.println("n = " + meanVar3.getN());
            System.out.println("Mean = " + meanVar3.getMean());
            System.out.println("Variance = " + meanVar3.getVariance());
            System.out.println("s.d. = " + meanVar3.getSd());
            MeanVar meanVar4 = new MeanVar(7.000001);
            meanVar4.addValue(7.000002);
            meanVar4.addValue(7.000003);
            meanVar4.addValue(7.000004);
            meanVar4.addValue(7.000005);
            System.out.println("n = " + meanVar4.getN());
            System.out.println("Mean = " + meanVar4.getMean());
            System.out.println("Variance = " + meanVar4.getVariance());
            System.out.println("s.d. = " + meanVar4.getSd());
        }
    }
}

