/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;

public class Bernoulli
extends AbstractDiscreteDistribution {
    private double p;

    public Bernoulli(double d) {
        super(0L, 1L);
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.p = d;
    }

    public double cdf(double d) {
        if (d == 0.0) {
            return 1.0 - this.p;
        }
        if (d == 1.0) {
            return 1.0;
        }
        throw new IllegalArgumentException("Invalid variate-value.");
    }

    public double getP() {
        return this.p;
    }

    public double mean() {
        return this.p;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        return !(d <= 1.0 - this.p) ? 1 : 0;
    }

    public double pdf(double d) {
        if (d == 0.0) {
            return 1.0 - this.p;
        }
        if (d == 1.0) {
            return this.p;
        }
        throw new IllegalArgumentException("Invalid variate-value.");
    }

    public double random() {
        return this.rand.nextDouble() < this.p ? 1 : 0;
    }

    public String toString() {
        return new String("Bernoulli distribution: p = " + this.p + ".");
    }

    public double variance() {
        return this.p * (1.0 - this.p);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 0.5;
            double d2 = 0.7;
            int n = 0;
            Bernoulli bernoulli = new Bernoulli(d2);
            System.out.println("Bernoulli distribution: p = " + d2);
            System.out.println("p.m.f. at X = " + n + ") = " + bernoulli.pdf(n));
            System.out.println("Probability(X <= " + n + ") = " + bernoulli.cdf(n));
            System.out.println("x such that Probability(X <= x) = " + d + ") = " + bernoulli.inverseCdf(d));
            int n2 = 100000;
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = (int)bernoulli.random();
                ++n3;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)bernoulli, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("n = " + n2 + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

