/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class Exponential
extends AbstractDistribution {
    private double mean;

    public Exponential(double d) {
        this.setMean(d);
    }

    public Exponential() {
        this(1.0);
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 - Math.exp(-d / this.mean);
    }

    public double getMaximumPdf() {
        return 1.0 / this.mean;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return -this.mean * Math.log(1.0 - d);
    }

    public double mean() {
        return this.mean;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return Math.exp(-d / this.mean) / this.mean;
    }

    public double random() {
        return -this.mean * Math.log(1.0 - this.rand.nextDouble());
    }

    public double sd() {
        return this.mean;
    }

    public void setMean(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.mean = d;
    }

    public String toString() {
        return new String("Exponential distribution: mean = " + this.mean + ".");
    }

    public double variance() {
        return this.mean * this.mean;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 2.0;
            Exponential exponential = new Exponential(d);
            int n = 100000;
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = exponential.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, exponential, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

