/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class FishersF
extends AbstractDistribution {
    private ChiSquared chiSquared1;
    private ChiSquared chiSquared2;
    private double df1;
    private double df2;
    private double lnB;

    public FishersF(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.df1 = d;
        this.df2 = d2;
        this.lnB = Maths.lnB(0.5 * d2, 0.5 * d);
        this.chiSquared1 = new ChiSquared(d);
        this.chiSquared2 = new ChiSquared(d2);
        this.chiSquared2.setSeed(this.rand.nextLong());
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        return 1.0 - Beta.incompleteBeta(this.df2 / (this.df2 + this.df1 * d), 0.5 * this.df2, 0.5 * this.df1, this.lnB);
    }

    public double getDf1() {
        return this.df1;
    }

    public double getDf2() {
        return this.df2;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = Beta.inverseIncompleteBeta(0.5 * this.df2, 0.5 * this.df1, this.lnB, 1.0 - d);
        if (d2 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.df2 * (1.0 - d2) / (d2 * this.df1);
    }

    public double mean() {
        return this.df2 > 2.0 ? this.df2 / (this.df2 - 2.0) : Double.NaN;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        return Math.exp(0.5 * (this.df1 * (Math.log(this.df1) - Math.log(this.df2)) + (this.df1 - 2.0) * Math.log(d) - (this.df1 + this.df2) * Math.log(1.0 + this.df1 / this.df2 * d)) - this.lnB);
    }

    public double random() {
        return this.df2 * this.chiSquared1.random() / (this.df1 * this.chiSquared2.random());
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
        this.chiSquared1.setSeed(this.rand.nextLong());
        this.chiSquared2.setSeed(this.rand.nextLong());
    }

    public String toString() {
        return new String("Fisher's F distribution: df1 = " + this.df1 + ", df2 = " + this.df2 + ".");
    }

    public static double upperTailProb(double d, double d2, double d3) {
        return Beta.incompleteBeta(d3 / (d3 + d2 * d), 0.5 * d3, 0.5 * d2, Maths.lnB(0.5 * d3, 0.5 * d2));
    }

    public double variance() {
        return this.df2 > 4.0 ? 2.0 * this.df2 * this.df2 * (this.df1 + this.df2 - 2.0) / (this.df1 * (this.df2 - 2.0) * (this.df2 - 2.0) * (this.df2 - 4.0)) : Double.NaN;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double d = 2.0;
            double d2 = 4.0;
            FishersF fishersF = new FishersF(d, d2);
            int n = 10000;
            fishersF = new FishersF(100.0, 1000.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = fishersF.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, fishersF, H1.NOT_EQUAL, false);
            System.out.println("n = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

