/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;
import jsc.util.Maths;

public class Hypergeometric
extends AbstractDiscreteDistribution {
    static final int MBIG = 3000;
    static final double ELIMIT = Math.log(Double.MIN_VALUE);
    static final double SCALE = 1.0E300;
    private int sampleSize;
    private int populationSize;
    private int markedItemsCount;
    private double P;

    public Hypergeometric(int n, int n2, int n3) {
        super(Math.max(0, n - n2 + n3), Math.min(n, n3));
        if (n3 < 0 || n2 < n3 || n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.sampleSize = n;
        this.populationSize = n2;
        this.markedItemsCount = n3;
        this.P = (double)n3 / (double)n2;
    }

    public double cdf(double d) {
        return this.chyper(false, this.sampleSize, this.populationSize, this.markedItemsCount, (int)d);
    }

    private double chyper(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl2 = true;
        double d = 0.0;
        int n7 = n + 1;
        int n8 = n4 + 1;
        int n9 = n2 + 1;
        int n10 = n3 + 1;
        if (n8 < 1 || n7 - n8 > n9 - n10) {
            throw new IllegalArgumentException("Invalid variate-value " + n8);
        }
        if (!bl) {
            d = 1.0;
        }
        if (n8 > n10 || n8 > n7) {
            throw new IllegalArgumentException("Invalid variate-value " + n8);
        }
        d = 1.0;
        if (n7 == 1 || n7 == n9 || n10 == 1 || n10 == n9) {
            return d;
        }
        double d2 = (double)n3 / (double)(n2 - n3);
        if (Math.min(n7 - 1, n9 - n7) > Math.min(n10 - 1, n9 - n10)) {
            n6 = n7;
            n7 = n10;
            n10 = n6;
        }
        if (n9 - n7 < n7 - 1) {
            bl2 = !bl2;
            n8 = n10 - n8 + 1;
            n7 = n9 - n7 + 1;
        }
        if (n2 > 3000) {
            d2 = Maths.logFactorial(n3) - Maths.logFactorial(n2) + Maths.logFactorial(n2 - n) + Maths.logFactorial(n) + Maths.logFactorial(n2 - n3) - Maths.logFactorial(n4) - Maths.logFactorial(n3 - n4) - Maths.logFactorial(n - n4) - Maths.logFactorial(n2 - n3 - n + n4);
            d = 0.0;
            if (d2 >= ELIMIT) {
                d = Math.exp(d2);
            }
        } else {
            n6 = 1;
            while (n6 <= n8 - 1) {
                d *= (double)(n7 - n6) * (double)(n10 - n6) / ((double)(n8 - n6) * (double)(n9 - n6));
                ++n6;
            }
            if (n8 != n7) {
                n5 = n9 - n10 + n8;
                n6 = n8;
                while (n6 <= n7 - 1) {
                    d *= (double)(n5 - n6) / (double)(n9 - n6);
                    ++n6;
                }
            }
        }
        if (bl) {
            return d;
        }
        if (d == 0.0) {
            if (n2 <= 3000) {
                d2 = Maths.logFactorial(n3) - Maths.logFactorial(n2) + Maths.logFactorial(n) + Maths.logFactorial(n2 - n3) - Maths.logFactorial(n4) - Maths.logFactorial(n3 - n4) - Maths.logFactorial(n - n4) - Maths.logFactorial(n2 - n3 - n + n4) + Maths.logFactorial(n2 - n);
            }
            d2 += Math.log(1.0E300);
            d2 = Math.exp(d2);
        } else {
            d2 = d * 1.0E300;
        }
        double d3 = 0.0;
        int n11 = n10 - n8;
        int n12 = n7 - n8;
        int n13 = n9 - n10 - n12 + 1;
        if (n8 <= n12) {
            n6 = 1;
            while (n6 <= n8 - 1) {
                d3 += (d2 *= (double)(n8 - n6) * (double)(n13 - n6) / ((double)(n11 + n6) * (double)(n12 + n6)));
                ++n6;
            }
        } else {
            bl2 = !bl2;
            n5 = 0;
            while (n5 <= n12 - 1) {
                d3 += (d2 *= (double)(n11 - n5) * (double)(n12 - n5) / ((double)(n8 + n5) * (double)(n13 + n5)));
                ++n5;
            }
        }
        double d4 = d = bl2 ? d + d3 / 1.0E300 : 1.0 - d3 / 1.0E300;
        if (d > 1.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    public int getMarkedItemsCount() {
        return this.markedItemsCount;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public double mean() {
        return (double)this.sampleSize * this.P;
    }

    public double pdf(double d) {
        return this.chyper(true, this.sampleSize, this.populationSize, this.markedItemsCount, (int)d);
    }

    public double random() {
        double d;
        int n;
        double d2 = 0.0;
        double d3 = this.populationSize;
        if (this.sampleSize < this.markedItemsCount) {
            n = this.sampleSize;
            d = this.markedItemsCount;
        } else {
            n = this.markedItemsCount;
            d = this.sampleSize;
        }
        int n2 = 1;
        while (n2 <= n) {
            double d4 = d / d3;
            boolean bl = this.rand.nextDouble() < d4;
            d3 -= 1.0;
            if (bl) {
                d2 += 1.0;
                d -= 1.0;
            }
            if (d == 0.0) break;
            ++n2;
        }
        return d2;
    }

    public String toString() {
        return new String("Hypergeometric distribution: sample size = " + this.sampleSize + ", population size = " + this.populationSize + ", marked items count = " + this.markedItemsCount + ".");
    }

    public double upperTailProb(double d) {
        return 1.0 - this.cdf((int)d - 1);
    }

    public double variance() {
        return (double)this.sampleSize * this.P * (1.0 - this.P) * (double)(this.populationSize - this.sampleSize) / ((double)this.populationSize - 1.0);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 2000;
            int n2 = 1000;
            int n3 = 1000;
            int n4 = 1000000;
            Hypergeometric hypergeometric = new Hypergeometric(16, 32, 11);
            System.out.println(hypergeometric.toString());
            int[] nArray = new int[n4];
            long l = System.currentTimeMillis();
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = (int)hypergeometric.random();
                ++n5;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)hypergeometric, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("s = " + n4 + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

