/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.combinatorics.MultiSetPermutation;
import jsc.combinatorics.MultiSetPermutations;
import jsc.descriptive.DoubleTally;
import jsc.distributions.Discrete;
import jsc.util.Arrays;

public class KruskalWallisH
extends Discrete {
    private double tolerance = 1.0E-14;
    private final int[] ns;
    private final double Rbar;
    private final double c;
    private int[] ranks;
    private int[] count;
    private double[] R;
    private DoubleTally H;

    public KruskalWallisH(int[] nArray) {
        this.ns = nArray;
        MultiSetPermutations multiSetPermutations = new MultiSetPermutations(nArray);
        this.H = new DoubleTally(1500, 100, this.tolerance);
        int n = nArray.length;
        this.R = new double[n];
        int n2 = (int)Arrays.sum(nArray);
        this.ranks = new int[n2];
        this.count = new int[n];
        this.c = 12.0 / ((double)n2 * ((double)n2 + 1.0));
        this.Rbar = 0.5 * ((double)n2 + 1.0);
        while (multiSetPermutations.hasNext()) {
            double d = 0.0;
            MultiSetPermutation multiSetPermutation = multiSetPermutations.nextPermutation();
            int[] nArray2 = multiSetPermutation.toIntArray();
            this.count[0] = 0;
            int n3 = 1;
            while (n3 < n) {
                this.count[n3] = this.count[n3 - 1] + this.ns[n3 - 1];
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3] - 1;
                this.ranks[this.count[n4]] = n3 + 1;
                int n5 = n4;
                this.count[n5] = this.count[n5] + 1;
                ++n3;
            }
            int n6 = 0;
            n3 = 0;
            while (n3 < n) {
                this.R[n3] = 0.0;
                int n7 = 0;
                while (n7 < this.ns[n3]) {
                    int n8 = n3;
                    this.R[n8] = this.R[n8] + (double)this.ranks[n6++];
                    ++n7;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                int n9 = n3;
                this.R[n9] = this.R[n9] / (double)this.ns[n3];
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                double d2 = this.R[n3] - this.Rbar;
                d += (double)this.ns[n3] * d2 * d2;
                ++n3;
            }
            this.H.addValue(this.c * d);
        }
        this.setDistribution(this.H);
        this.H = null;
        this.R = null;
        this.ranks = null;
        this.count = null;
    }

    public double criticalValue(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d2 = 0.0;
        int n = this.valueCount - 1;
        while (n >= 0) {
            if (Math.abs((d2 += this.probs[n]) - d) < 1.0E-16) {
                return this.values[n];
            }
            if (d2 > d) {
                return n < this.valueCount - 1 ? this.values[n + 1] : -1.0;
            }
            --n;
        }
        return this.minValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Kruskal-Wallis H distribution; sample sizes");
        int n = 0;
        while (n < this.valueCount) {
            stringBuffer.append(" " + this.ns[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int[] nArray = new int[]{4, 3, 2};
            long l = System.currentTimeMillis();
            KruskalWallisH kruskalWallisH = new KruskalWallisH(nArray);
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("Kruskal-Wallis H distribution");
            double d = 0.0;
            int n = kruskalWallisH.getValueCount();
            int n2 = 0;
            while (n2 < n) {
                System.out.println("P(X = " + kruskalWallisH.getValue(n2) + ") = " + kruskalWallisH.getProb(n2));
                d += kruskalWallisH.getProb(n2);
                ++n2;
            }
            System.out.println("N = " + n + " sum = " + d + " Crit.value = " + kruskalWallisH.criticalValue(0.01));
        }
    }
}

