/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractContinuousDistribution;
import jsc.distributions.ChiSquared;
import jsc.distributions.FishersF;
import jsc.distributions.NoncentralBeta;
import jsc.distributions.NoncentralChiSquared;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class NoncentralFishersF
extends AbstractContinuousDistribution {
    static final int ITRMAX = 200;
    private double df1;
    private double df2;
    private double lambda;
    private double logHalfLambda;
    private double ratio;
    private double logRatio;
    private double logGammaHalfV;
    private FishersF centralF;
    private NoncentralBeta B;
    private NoncentralChiSquared chiSquaredU;
    private ChiSquared chiSquaredV;

    public NoncentralFishersF(double d, double d2, double d3) {
        super(0.0, Double.POSITIVE_INFINITY, false);
        this.setParameters(d, d2, d3);
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (this.lambda == 0.0) {
            return this.centralF.cdf(d);
        }
        return this.B.cdf(this.df1 * d / (this.df1 * d + this.df2));
    }

    public double getDf1() {
        return this.df1;
    }

    public double getDf2() {
        return this.df2;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double inverseCdf(double d) {
        if (this.lambda == 0.0) {
            return this.centralF.inverseCdf(d);
        }
        return super.inverseCdf(d);
    }

    public double mean() {
        return this.df2 > 2.0 ? this.df2 * (this.df1 + this.lambda) / (this.df1 * (this.df2 - 2.0)) : Double.NaN;
    }

    public double pdf(double d) {
        if (this.lambda == 0.0) {
            return this.centralF.pdf(d);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = Math.log(d);
        double d4 = 0.5 * this.lambda;
        double d5 = 0.5 * this.df1;
        double d6 = 0.5 * (this.df1 + this.df2);
        double d7 = Math.log(1.0 + this.ratio * d);
        int n = 0;
        while (n < 1000) {
            double d8 = Math.exp((double)n * this.logHalfLambda - d4 + (d5 + (double)n) * this.logRatio + Maths.logGamma(d6 + (double)n) + (d5 + (double)n - 1.0) * d3 - Maths.logGamma(n + 1) - Maths.logGamma(d5 + (double)n) - this.logGammaHalfV - ((double)n + d6) * d7);
            d2 += d8;
            if (Math.abs(d8) < this.tolerance * d2) {
                return d2;
            }
            ++n;
        }
        throw new RuntimeException("Cannot calculate pdf to required accuracy.");
    }

    public double random() {
        if (this.lambda == 0.0) {
            return this.centralF.random();
        }
        return this.df2 * this.chiSquaredU.random() / (this.df1 * this.chiSquaredV.random());
    }

    public void setParameters(double d, double d2, double d3) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid \"degrees of freedom\" parameter.");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Invalid noncentrality parameter.");
        }
        this.df1 = d;
        this.df2 = d2;
        this.lambda = d3;
        this.ratio = d / d2;
        this.logRatio = Math.log(this.ratio);
        this.logGammaHalfV = Maths.logGamma(0.5 * d2);
        if (d3 == 0.0) {
            this.centralF = new FishersF(d, d2);
            this.chiSquaredU = null;
            this.chiSquaredV = null;
            this.B = null;
        } else {
            this.centralF = null;
            this.chiSquaredU = new NoncentralChiSquared(d, d3);
            this.chiSquaredV = new ChiSquared(d2);
            this.chiSquaredV.setSeed(this.rand.nextLong());
            this.logHalfLambda = Math.log(0.5 * d3);
            this.B = new NoncentralBeta(0.5 * d, 0.5 * d2, d3);
        }
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
        if (this.lambda == 0.0) {
            this.centralF.setSeed(this.rand.nextLong());
        } else {
            this.chiSquaredU.setSeed(this.rand.nextLong());
            this.chiSquaredV.setSeed(this.rand.nextLong() + 1L);
        }
    }

    public String toString() {
        return new String("Noncentral Fisher's F distribution: df1 = " + this.df1 + ", df2 = " + this.df2 + ", lambda = " + this.lambda + ".");
    }

    public double variance() {
        return this.df2 > 4.0 ? 2.0 / (this.ratio * this.ratio) * ((this.df1 + this.lambda) * (this.df1 + this.lambda) + (this.df1 + this.lambda + this.lambda) * (this.df2 - 2.0) / ((this.df2 - 2.0) * (this.df2 - 2.0) * (this.df2 - 4.0))) : Double.NaN;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            NoncentralFishersF noncentralFishersF = new NoncentralFishersF(8.0, 30.0, 36.0);
            noncentralFishersF.setTolerance(1.0E-11);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = noncentralFishersF.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, noncentralFishersF, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

