/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;

public class PowerFunction
extends AbstractDistribution {
    private double scale;
    private double shape;
    private double BC;
    private double RECIPC;

    public PowerFunction(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.scale = d;
        this.shape = d2;
        this.RECIPC = 1.0 / d2;
        this.BC = Math.pow(d, d2);
    }

    public double cdf(double d) {
        if (d < 0.0 || d > this.scale) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return Math.pow(d / this.scale, this.shape);
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return this.scale;
        }
        return this.scale * Math.pow(d, this.RECIPC);
    }

    public double mean() {
        return this.scale * this.shape / (this.shape + 1.0);
    }

    public double pdf(double d) {
        if (d < 0.0 || d > this.scale) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return this.shape * Math.pow(d, this.shape - 1.0) / this.BC;
    }

    public double random() {
        return this.scale * Math.pow(this.rand.nextDouble(), this.RECIPC);
    }

    public String toString() {
        return new String("Power function distribution: scale = " + this.scale + ", shape = " + this.shape + ".");
    }

    public double variance() {
        return this.scale * this.scale * this.shape / ((this.shape + 2.0) * (this.shape + 1.0) * (this.shape + 1.0));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            PowerFunction powerFunction = new PowerFunction(2.0, 0.5);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = powerFunction.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, powerFunction, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

