/*
 * Decompiled with CFR 0.152.
 */
package jsc.mathfunction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jsc.mathfunction.MathFunctionException;
import jsc.mathfunction.MathFunctionVariables;
import jsc.mathfunction.StandardMathFunction;
import jsc.util.Maths;

public class StandardMathFunctionDerivatives
extends StandardMathFunction {
    static final String BAD_ORDER = "Order of Taylor coefficients must be > 0.";
    static final String NO_DERIV = "Derivative does not exist.";
    static final String NO_STORE = "Implementation error: insufficient storage";
    public static final double BIG_VAL = 1.7E100;
    private int MAX_WORK;
    private double[][] T;
    private int wsub;

    public StandardMathFunctionDerivatives(MathFunctionVariables mathFunctionVariables) {
        super(mathFunctionVariables);
    }

    public double evalDerivative(int n) throws MathFunctionException {
        double[] dArray = this.evalTaylorCoeffs(n, 1);
        return dArray[1];
    }

    public double[] evalDerivatives(int n, int n2) throws MathFunctionException {
        double[] dArray = this.evalTaylorCoeffs(n, n2);
        double[] dArray2 = new double[1 + n2];
        int n3 = 0;
        while (n3 <= n2) {
            dArray2[n3] = StandardMathFunctionDerivatives.toDerivative(n3, dArray[n3]);
            ++n3;
        }
        return dArray2;
    }

    public double[] evalTaylorCoeffs(int n, int n2) throws MathFunctionException {
        int n3;
        if (this.codeList.size() == 0) {
            throw new MathFunctionException("Invalid function");
        }
        if (n2 < 1) {
            throw new MathFunctionException(BAD_ORDER);
        }
        double[] dArray = new double[1 + n2];
        this.MAX_WORK = this.codeList.size() + 10;
        this.T = new double[this.MAX_WORK][1 + n2];
        dArray[0] = this.eval();
        this.wsub = n3 = this.codeList.size();
        int n4 = 1;
        while (n4 <= n3) {
            this.T[n4][0] = this.codeList.getValue(n4);
            this.recur_init(n4, n);
            ++n4;
        }
        int n5 = 1;
        while (n5 <= n2) {
            this.wsub = n3;
            n4 = 1;
            while (n4 <= n3) {
                int n6 = this.codeList.getCode(n4);
                int n7 = this.codeList.getType(n4);
                switch (n7) {
                    case 0: {
                        int n8 = this.Vartest(n6, n);
                        if (n8 == 0 && n5 == 1) {
                            this.T[n4][n5] = 1.0;
                            break;
                        }
                    }
                    case 3: {
                        this.T[n4][n5] = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.recur(n4, n5, n);
                        break;
                    }
                    default: {
                        throw new MathFunctionException("Implementation error: unrecognized code type");
                    }
                }
                if (Math.abs(this.T[n4][n5]) > 1.7E100) {
                    throw new MathFunctionException("Evaluation of Taylor coefficient of order " + n5 + " approaching overflow.");
                }
                ++n4;
            }
            dArray[n5] = this.T[n3][n5];
            ++n5;
        }
        return dArray;
    }

    private void recur(int n, int n2, int n3) throws MathFunctionException {
        int n4 = this.codeList.getLabelLine(this.codeList.getLeft(n));
        int n5 = this.codeList.getLabelLine(this.codeList.getRight(n));
        int n6 = this.codeList.getCode(n4);
        int n7 = this.codeList.getType(n4);
        if (n7 == 0 && this.Vartest(n6, n3) < 0) {
            n7 = 3;
        }
        n6 = this.codeList.getCode(n5);
        int n8 = this.codeList.getType(n5);
        if (n8 == 0 && this.Vartest(n6, n3) < 0) {
            n8 = 3;
        }
        double d = this.T[n4][0];
        double d2 = this.T[n5][0];
        switch (this.codeList.getCode(n)) {
            case 290: {
                this.T[n][n2] = this.T[n4][n2] + this.T[n5][n2];
                break;
            }
            case 291: {
                this.T[n][n2] = this.T[n4][n2] - this.T[n5][n2];
                break;
            }
            case 202: {
                this.recur_multiply(n, n2, n4, n5, n7, n8, d, d2);
                break;
            }
            case 203: {
                this.recur_divide(n, n2, n4, n5, n7, n8, d2);
                break;
            }
            case 204: {
                this.recur_power(n, n2, n4, n5, n7, n8, d, d2);
                break;
            }
            case 205: {
                throw new MathFunctionException("Cannot differentiate modulus % operator.");
            }
            case 108: {
                this.recur_power(n, n2, n5, n5, n7, 3, d, 0.5);
                break;
            }
            case 191: {
                this.T[n][n2] = -this.T[n5][n2];
                break;
            }
            case 103: {
                this.RECUR_EXP(n, n2, n5);
                break;
            }
            case 106: {
                this.recur_ln(n, n2, n5);
                break;
            }
            case 110: {
                this.recur_sin_cos(++this.wsub, n, n2, n5);
                break;
            }
            case 109: {
                this.recur_sin_cos(n, ++this.wsub, n2, n5);
                break;
            }
            case 111: {
                ++this.wsub;
                int n9 = this.wsub++;
                int n10 = this.wsub;
                this.recur_sin_cos(n9, n10, n2, n5);
                this.recur_divide(n, n2, n9, n10, n7, n8, d2);
                break;
            }
            case 116: {
                this.recur_sinh_cosh(++this.wsub, n, n2, n5);
                break;
            }
            case 115: {
                this.recur_sinh_cosh(n, ++this.wsub, n2, n5);
                break;
            }
            case 117: {
                ++this.wsub;
                int n11 = this.wsub++;
                int n12 = this.wsub;
                this.recur_sinh_cosh(n11, n12, n2, n5);
                this.recur_divide(n, n2, n11, n12, n7, n8, d2);
                break;
            }
            case 112: {
                ++this.wsub;
                int n13 = this.wsub++;
                int n14 = this.wsub;
                this.RECUR_SQUARE(n13, n2, n5, n8, d2);
                this.recur_divide(n14, n2, 0, n13, 3, n8, d2);
                this.recur_unary(n, n2, n14, n5);
                break;
            }
            case 113: 
            case 114: {
                ++this.wsub;
                int n15 = this.wsub++;
                int n16 = this.wsub++;
                int n17 = this.wsub;
                this.RECUR_SQUARE(n15, n2, n5, n8, d2);
                this.T[n15][n2] = -this.T[n15][n2];
                this.recur_power(n16, n2, n15, 0, n7, 3, d, 0.5);
                this.recur_divide(n17, n2, 0, n16, 3, n8, d2);
                this.recur_unary(n, n2, n17, n5);
                break;
            }
            case 102: {
                if (n8 == 3) {
                    this.T[n][n2] = Math.abs(this.T[n5][n2]);
                    break;
                }
                if (this.T[n5][n2] == 0.0) {
                    throw new MathFunctionException(NO_DERIV);
                }
                this.T[n][n2] = this.T[n5][n2] < 0.0 ? -this.T[n5][n2] : this.T[n5][n2];
                break;
            }
            case 190: {
                this.T[n][n2] = this.T[n5][n2];
                break;
            }
            case 104: {
                if (n8 == 3) {
                    this.T[n][n2] = Maths.truncate(this.T[n5][n2]);
                    break;
                }
                throw new MathFunctionException("Cannot differentiate INT function.");
            }
            case 118: {
                if (n8 == 3) {
                    this.T[n][n2] = Maths.sign(this.T[n5][n2]);
                    break;
                }
                throw new MathFunctionException("Cannot differentiate SIGN function.");
            }
            case 105: {
                if (n8 == 3) {
                    this.T[n][n2] = Math.rint(this.T[n5][n2]);
                    break;
                }
                throw new MathFunctionException("Cannot differentiate NINT function.");
            }
            case 119: {
                this.T[n][n2] = Math.toDegrees(this.T[n5][n2]);
                break;
            }
            case 120: {
                this.T[n][n2] = Math.toRadians(this.T[n5][n2]);
                break;
            }
            default: {
                throw new MathFunctionException("Implementation error: unrecognized code");
            }
        }
    }

    private void recur_divide(int n, int n2, int n3, int n4, int n5, int n6, double d) throws MathFunctionException {
        double d2 = 0.0;
        if (n6 == 3 && d != 0.0) {
            this.T[n][n2] = this.T[n3][n2] / d;
        } else {
            if (this.TRIM(this.T[n4][0]) == 0.0) {
                throw new MathFunctionException(NO_DERIV);
            }
            int n7 = 1;
            while (n7 <= n2) {
                d2 += this.T[n][n2 - n7] * this.T[n4][n7];
                ++n7;
            }
            this.T[n][n2] = n5 == 3 ? -d2 / this.T[n4][0] : (this.T[n3][n2] - d2) / this.T[n4][0];
        }
    }

    private void RECUR_EXP(int n, int n2, int n3) {
        this.recur_unary(n, n2, n, n3);
    }

    private void recur_init(int n, int n2) throws MathFunctionException {
        int n3 = 1;
        int n4 = this.codeList.getLabelLine(this.codeList.getLeft(n));
        int n5 = this.codeList.getLabelLine(this.codeList.getRight(n));
        double d = this.T[n4][0];
        double d2 = this.T[n5][0];
        switch (this.codeList.getCode(n)) {
            case 204: {
                int n6 = this.codeList.getRightCode(n);
                int n7 = this.codeList.getRightType(n);
                if (n7 == 3 || n7 == 0 && this.Vartest(n6, n2) < 0) {
                    if (d2 <= 2.0 || d != 0.0) {
                        return;
                    }
                    int n8 = (int)d2;
                    if (d2 == (double)n8) {
                        while (n3 <= n8) {
                            n3 <<= 1;
                        }
                        n3 >>= 1;
                        while ((n3 >>= 1) != 0) {
                            this.T[this.winc()][0] = 0.0;
                            if ((n8 & n3) == 0) continue;
                            this.T[this.winc()][0] = 0.0;
                        }
                    } else {
                        throw new MathFunctionException("Attempted division by zero");
                    }
                    return;
                }
                int n9 = this.winc();
                int n10 = this.winc();
                this.T[n9][0] = this.unaryOperation(106, d);
                this.T[n10][0] = d2 * this.T[n9][0];
                break;
            }
            case 110: {
                this.T[this.winc()][0] = this.unaryOperation(109, d2);
                break;
            }
            case 109: {
                this.T[this.winc()][0] = this.unaryOperation(110, d2);
                break;
            }
            case 111: {
                this.T[this.winc()][0] = this.unaryOperation(109, d2);
                this.T[this.winc()][0] = this.unaryOperation(110, d2);
                break;
            }
            case 116: {
                this.T[this.winc()][0] = this.unaryOperation(115, d2);
                break;
            }
            case 115: {
                this.T[this.winc()][0] = this.unaryOperation(116, d2);
                break;
            }
            case 117: {
                this.T[this.winc()][0] = this.unaryOperation(115, d2);
                this.T[this.winc()][0] = this.unaryOperation(116, d2);
                break;
            }
            case 112: {
                int n11 = this.winc();
                int n12 = this.winc();
                this.T[n11][0] = 1.0 + d2 * d2;
                this.T[n12][0] = 1.0 / this.T[n11][0];
                break;
            }
            case 113: 
            case 114: {
                int n13 = this.winc();
                int n14 = this.winc();
                int n15 = this.winc();
                this.T[n13][0] = 1.0 - d2 * d2;
                this.T[n14][0] = this.unaryOperation(108, this.T[n13][0]);
                if (this.T[n14][0] == 0.0) {
                    throw new MathFunctionException("Attempted division by zero");
                }
                this.T[n15][0] = 1.0 / this.T[n14][0];
                if (this.codeList.getCode(n) != 114) break;
                this.T[n15][0] = -this.T[n15][0];
                break;
            }
            default: {
                return;
            }
        }
    }

    private void recur_int_power5(int n, int n2, int n3, int n4, double d, int n5) {
        int n6 = 1;
        int n7 = n3;
        while (n6 <= n5) {
            n6 <<= 1;
        }
        n6 >>= 1;
        while ((n6 >>= 1) != 0) {
            this.RECUR_SQUARE(++this.wsub, n2, n7, n4, d);
            if ((n5 & n6) != 0) {
                int n8 = this.wsub++;
                this.recur_multiply(this.wsub, n2, n3, n8, n4, n4, d, 0.0);
            }
            n7 = this.wsub;
        }
        this.T[n][n2] = this.T[this.wsub][n2];
    }

    private void recur_ln(int n, int n2, int n3) throws MathFunctionException {
        double d = 0.0;
        double d2 = n2;
        if (this.TRIM(this.T[n3][0]) == 0.0) {
            throw new MathFunctionException(NO_DERIV);
        }
        if (n2 > 1) {
            int n4 = 1;
            while (n4 <= n2 - 1) {
                d += (d2 - (double)n4) / d2 * this.T[n][n2 - n4] * this.T[n3][n4];
                ++n4;
            }
            this.T[n][n2] = (this.T[n3][n2] - d) / this.T[n3][0];
        } else {
            this.T[n][1] = this.T[n3][1] / this.T[n3][0];
        }
    }

    private void recur_multiply(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2) {
        double d3 = 0.0;
        if (n5 == 3) {
            this.T[n][n2] = d * this.T[n4][n2];
        } else if (n6 == 3) {
            this.T[n][n2] = this.T[n3][n2] * d2;
        } else {
            int n7 = 0;
            while (n7 <= n2) {
                d3 += this.T[n3][n7] * this.T[n4][n2 - n7];
                ++n7;
            }
            this.T[n][n2] = d3;
        }
    }

    private void recur_power(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2) throws MathFunctionException {
        double d3 = 0.0;
        if (n6 == 3) {
            if (d2 == 0.0) {
                this.T[n][n2] = 0.0;
            } else if (d2 == 1.0) {
                this.T[n][n2] = this.T[n3][n2];
            } else if (d2 == 2.0) {
                this.RECUR_SQUARE(n, n2, n3, n5, d);
            } else if (this.TRIM(this.T[n3][0]) != 0.0) {
                double d4 = n2;
                int n7 = 0;
                while (n7 <= n2 - 1) {
                    d3 += (d2 - (double)n7 * (d2 + 1.0) / d4) * this.T[n3][n2 - n7] * this.T[n][n7];
                    ++n7;
                }
                this.T[n][n2] = d3 / this.T[n3][0];
            } else {
                int n8 = (int)d2;
                if (d2 == (double)n8) {
                    this.recur_int_power5(n, n2, n3, n5, d, n8);
                } else {
                    throw new MathFunctionException("Attempted division by zero");
                }
            }
            return;
        }
        ++this.wsub;
        int n9 = this.wsub++;
        int n10 = this.wsub;
        if (n5 == 3) {
            this.recur_multiply(n10, n2, n9, n4, 3, n6, this.T[n9][0], d2);
            this.RECUR_EXP(n, n2, n10);
            return;
        }
        this.recur_ln(n9, n2, n3);
        this.recur_multiply(n10, n2, n9, n4, n5, n6, d, d2);
        this.RECUR_EXP(n, n2, n10);
    }

    private void recur_sin_cos(int n, int n2, int n3, int n4) {
        this.recur_unary(n, n3, n2, n4);
        this.recur_unary(n2, n3, n, n4);
        this.T[n2][n3] = -this.T[n2][n3];
    }

    private void recur_sinh_cosh(int n, int n2, int n3, int n4) {
        this.recur_unary(n, n3, n2, n4);
        this.recur_unary(n2, n3, n, n4);
    }

    private void RECUR_SQUARE(int n, int n2, int n3, int n4, double d) {
        this.recur_multiply(n, n2, n3, n3, n4, n4, d, d);
    }

    private void recur_unary(int n, int n2, int n3, int n4) {
        double d = 0.0;
        double d2 = n2;
        int n5 = 0;
        while (n5 <= n2 - 1) {
            d += (d2 - (double)n5) / d2 * this.T[n3][n5] * this.T[n4][n2 - n5];
            ++n5;
        }
        this.T[n][n2] = d;
    }

    public static double toDerivative(int n, double d) {
        return Maths.factorial(n) * d;
    }

    private double TRIM(double d) {
        return Math.abs(d) < 5.0E-12 ? 0.0 : d;
    }

    private int Vartest(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        return -1;
    }

    private int winc() throws MathFunctionException {
        if (++this.wsub >= this.MAX_WORK) {
            throw new MathFunctionException(NO_STORE);
        }
        return this.wsub;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String string = "";
            XY xY = new XY();
            StandardMathFunctionDerivatives standardMathFunctionDerivatives = new StandardMathFunctionDerivatives(xY);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(standardMathFunctionDerivatives.getSummary());
            while (true) {
                double[] dArray;
                double d;
                int n;
                double d2;
                String string2;
                System.out.println("Enter expression f(x,y), ? for help, Q to quit or Return to re-evaluate");
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    continue;
                }
                if (string2.length() > 0) {
                    if (Character.toUpperCase(string2.charAt(0)) == 'Q') {
                        System.exit(0);
                    }
                    if (string2.charAt(0) == '?') {
                        System.out.println(standardMathFunctionDerivatives.getSummary());
                        continue;
                    }
                    string = string2;
                    try {
                        d2 = standardMathFunctionDerivatives.parse(string);
                    }
                    catch (MathFunctionException mathFunctionException) {
                        System.out.println(mathFunctionException.getMessage());
                        continue;
                    }
                    if (!standardMathFunctionDerivatives.variableUsed("X")) {
                        System.out.println("Expression must be a function of X to evaluate Taylor coeffs.");
                        continue;
                    }
                    if (standardMathFunctionDerivatives.variableUsed("Y")) {
                        xY.y = Test.getConstant("Enter value of Y", bufferedReader);
                    }
                }
                while (true) {
                    System.out.println("Enter order of Taylor series");
                    try {
                        string2 = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.getMessage());
                        continue;
                    }
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid input: " + numberFormatException.getMessage());
                        continue;
                    }
                    break;
                }
                xY.x = d = Test.getConstant("Taylor series about what value? (enter 0 for Maclaurin series)", bufferedReader);
                try {
                    dArray = standardMathFunctionDerivatives.evalTaylorCoeffs(0, n);
                }
                catch (MathFunctionException mathFunctionException) {
                    System.out.println(mathFunctionException.getMessage());
                    continue;
                }
                System.out.println(n + "th Taylor polynomial about " + d + " approximating " + string + " is -");
                System.out.println("P(x) = " + dArray[0]);
                int n2 = 1;
                while (n2 <= n) {
                    System.out.println(" + " + dArray[n2] + " * (x - " + d + ")^" + n2);
                    ++n2;
                }
                xY.x = Test.getConstant("Enter value of X", bufferedReader);
                double d3 = xY.x - d;
                double d4 = dArray[0];
                n2 = 1;
                while (n2 <= n) {
                    d4 += dArray[n2] * Math.pow(d3, n2);
                    ++n2;
                }
                System.out.println("P(x) approximation to f(x) = " + d4);
                try {
                    d2 = standardMathFunctionDerivatives.eval();
                }
                catch (MathFunctionException mathFunctionException) {
                    System.out.println(mathFunctionException.getMessage());
                    continue;
                }
                System.out.println("    Exact value of f(x) is = " + d2);
            }
        }

        static double getConstant(String string, BufferedReader bufferedReader) {
            double d;
            StandardMathFunction standardMathFunction = new StandardMathFunction();
            while (true) {
                String string2;
                System.out.println(string);
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    continue;
                }
                try {
                    d = standardMathFunction.parse(string2);
                }
                catch (MathFunctionException mathFunctionException) {
                    System.out.println(mathFunctionException.getMessage());
                    continue;
                }
                break;
            }
            return d;
        }

        static class XY
        implements MathFunctionVariables {
            public double x;
            public double y;

            XY() {
            }

            public int getNumberOfVariables() {
                return 2;
            }

            public String getVariableName(int n) {
                return n == 0 ? "X" : "Y";
            }

            public double getVariableValue(int n) {
                return n == 0 ? this.x : this.y;
            }
        }
    }
}

