/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.combinatorics.Enumerator;
import jsc.combinatorics.GrayCode;
import jsc.combinatorics.Selection;
import jsc.datastructures.PairedData;
import jsc.descriptive.MeanVar;
import jsc.onesample.Ttest;
import jsc.statistics.PermutableStatistic;
import jsc.tests.H1;

public class PairedTtest
extends Ttest
implements PermutableStatistic {
    double rootN;
    double[] diffs;
    double[] permutedDiffs;

    public PairedTtest(PairedData pairedData, H1 h1) {
        super(pairedData.differences(), 0.0, h1);
        this.rootN = Math.sqrt(this.n);
        this.diffs = pairedData.differences();
        this.permutedDiffs = new double[this.n];
    }

    public PairedTtest(PairedData pairedData) {
        this(pairedData, H1.NOT_EQUAL);
    }

    public Enumerator getEnumerator() {
        return new GrayCode(this.n);
    }

    public double permuteStatistic(Selection selection) {
        int[] nArray = selection.toIntArray();
        int n = 0;
        while (n < this.n) {
            this.permutedDiffs[n] = nArray[n] == 0 ? this.diffs[n] : -this.diffs[n];
            ++n;
        }
        MeanVar meanVar = new MeanVar(this.permutedDiffs);
        double d = meanVar.getMean() / (meanVar.getSd() / this.rootN);
        return d;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{70.0, 80.0, 62.0, 50.0, 70.0, 30.0, 49.0, 60.0};
            double[] dArray2 = new double[]{75.0, 82.0, 65.0, 58.0, 68.0, 41.0, 55.0, 67.0};
            PairedData pairedData = new PairedData(dArray, dArray2);
            PairedTtest pairedTtest = new PairedTtest(pairedData);
            System.out.println("H1: means not equal: t = " + pairedTtest.getTestStatistic() + " SP = " + pairedTtest.getSP());
            PairedTtest pairedTtest2 = new PairedTtest(pairedData, H1.LESS_THAN);
            System.out.println("H1: mean A < mean B: t = " + pairedTtest2.getTestStatistic() + " SP = " + pairedTtest2.getSP());
            PairedTtest pairedTtest3 = new PairedTtest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: mean A > mean B: t = " + pairedTtest3.getTestStatistic() + " SP = " + pairedTtest3.getSP());
        }
    }
}

