/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jsc.swt.control.RealField;
import jsc.swt.dialogue.FieldDialogue;
import jsc.swt.plot2d.DashStroke;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.plot2d.PlotText;
import jsc.swt.plot2d.StandardMarker;
import jsc.swt.virtualgraphics.Polyline;
import jsc.swt.virtualgraphics.VDimension;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VRectangle;
import jsc.swt.virtualgraphics.VirtualTransform;

public class PlotPanel
extends JPanel
implements Cloneable {
    public static final Composite SEE_THRU = AlphaComposite.getInstance(3, 0.5f);
    private static final String VT_ERROR_MESSAGE = "PlotPanel component must be displayed at this stage.";
    protected VRectangle virtualSpace;
    protected VirtualTransform vt = null;
    private Composite objectComposite = AlphaComposite.SrcOver;
    protected RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    protected Vector componentBounds;
    protected Vector objects;
    private Component parent;
    private Color focusColour = Color.red;
    private VRectangle zoomBox;
    private Stack zoomBoxes;
    private Color zoomBoxColour = Color.black;
    private PlotShape zoomBoxObject;
    private VPoint zoomBoxStart;
    private Stroke zoomBoxStroke = new DashStroke(1.0f);
    private KeyListener zoomKeyListener;
    private MouseMotionListener zoomMotionListener;
    private MouseListener zoomMouseListener;

    public PlotPanel() {
        this(new Dimension(300, 300), new VRectangle(0.0, 0.0, 1.0, 1.0));
    }

    public PlotPanel(Dimension dimension) {
        this(dimension, new VRectangle(0.0, 0.0, 1.0, 1.0));
    }

    public PlotPanel(Dimension dimension, VRectangle vRectangle) {
        super(null, true);
        this.parent = this;
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.setPreferredSize(dimension);
        this.virtualSpace = vRectangle;
        this.componentBounds = new Vector();
        this.objects = new Vector();
        this.addFocusListener(new KeyboardFocusListener());
    }

    public void ensureComponentCapacity(int n) {
        this.componentBounds.ensureCapacity(n);
    }

    public void addComponent(Component component, VRectangle vRectangle) {
        this.add(component);
        this.componentBounds.add(vRectangle);
    }

    public void addComponent(Component component, VPoint vPoint, VDimension vDimension) {
        this.addComponent(component, new VRectangle(vPoint, vDimension));
    }

    public void removeComponent(int n) {
        super.remove(n);
        this.componentBounds.remove(n);
        this.repaint();
    }

    public void removeLastComponent() {
        int n = this.getComponentCount() - 1;
        if (n >= 0) {
            this.removeComponent(n);
        }
    }

    public void removeAllComponents() {
        super.removeAll();
        this.componentBounds.removeAllElements();
        this.repaint();
    }

    public Vector getComponentBounds() {
        return this.componentBounds;
    }

    public VRectangle getComponentBounds(int n) {
        return (VRectangle)this.componentBounds.elementAt(n);
    }

    public void setComponentBounds(int n, VRectangle vRectangle) {
        this.componentBounds.setElementAt(vRectangle, n);
    }

    public void setComponentBounds(int n, VPoint vPoint, VDimension vDimension) {
        this.setComponentBounds(n, new VRectangle(vPoint, vDimension));
    }

    public void ensureObjectCapacity(int n) {
        this.objects.ensureCapacity(n);
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public void addObject(PlotObject plotObject) {
        this.objects.add(plotObject);
    }

    public void addObjects(PlotObject[] plotObjectArray) {
        int n = plotObjectArray.length;
        this.objects.ensureCapacity(this.objects.capacity() + n);
        int n2 = 0;
        while (n2 < n) {
            this.objects.add(plotObjectArray[n2]);
            ++n2;
        }
        this.repaint();
    }

    public PlotObject getObject(int n) {
        return (PlotObject)this.objects.get(n);
    }

    public PlotObject getObject(Point2D point2D) {
        if (this.objects.isEmpty()) {
            return null;
        }
        int n = 0;
        while (n < this.objects.size()) {
            PlotObject plotObject = (PlotObject)this.objects.elementAt(n);
            if (plotObject.contains(point2D, this.vt)) {
                return plotObject;
            }
            ++n;
        }
        return null;
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public int getObjectIndex(Point2D point2D) {
        if (this.objects.isEmpty()) {
            return -1;
        }
        int n = 0;
        while (n < this.objects.size()) {
            PlotObject plotObject = (PlotObject)this.objects.elementAt(n);
            if (plotObject.contains(point2D, this.vt)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Vector getObjects() {
        return this.objects;
    }

    public boolean removeObject(PlotObject plotObject) {
        return this.objects.remove(plotObject);
    }

    public void removeObject(int n) {
        this.objects.remove(n);
    }

    public void removeLastObject() {
        int n = this.objects.size() - 1;
        if (n >= 0) {
            this.objects.remove(n);
        }
    }

    public void removeAllObjects() {
        this.objects.removeAllElements();
        this.repaint();
    }

    public void setObjectComposite(Composite composite) {
        this.objectComposite = composite;
    }

    public void addRenderingHint(RenderingHints.Key key, Object object) {
        this.hints.add(new RenderingHints(key, object));
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public Object removeRenderingHint(Object object) {
        return this.hints.remove(object);
    }

    public Object clone() {
        return this.copyPlot();
    }

    protected void copyContents(PlotPanel plotPanel) {
        plotPanel.objects = (Vector)this.objects.clone();
        plotPanel.componentBounds = (Vector)this.componentBounds.clone();
        int n = 0;
        while (n < this.getComponentCount()) {
            plotPanel.add(this.getComponent(n));
            ++n;
        }
    }

    public PlotPanel copyPlot() {
        PlotPanel plotPanel = new PlotPanel(this.getSize(), this.virtualSpace);
        plotPanel.setDoubleBuffered(this.isDoubleBuffered());
        plotPanel.setOpaque(this.isOpaque());
        plotPanel.setBackground(this.getBackground());
        plotPanel.setBorder(this.getBorder());
        this.copyContents(plotPanel);
        plotPanel.hints = (RenderingHints)this.hints.clone();
        plotPanel.objectComposite = this.objectComposite;
        plotPanel.focusColour = this.focusColour;
        plotPanel.zoomBoxColour = this.zoomBoxColour;
        plotPanel.zoomBoxStroke = this.zoomBoxStroke;
        return plotPanel;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        if (bufferedImage == null) {
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintComponent(graphics2D);
        return bufferedImage;
    }

    public double getParHeight(double d) {
        int n = this.virtualToPixelWidth(d);
        VDimension vDimension = this.pixelToVirtual(new Dimension(0, n));
        return vDimension.height;
    }

    public double getParWidth(double d) {
        int n = this.virtualToPixelHeight(d);
        VDimension vDimension = this.pixelToVirtual(new Dimension(n, 0));
        return vDimension.width;
    }

    public VRectangle getVirtualSpace() {
        return this.virtualSpace;
    }

    public void setVirtualSpace(VRectangle vRectangle) {
        this.virtualSpace = vRectangle;
    }

    public VirtualTransform getVirtualTransform() {
        return this.vt;
    }

    public void merge(PlotPanel plotPanel) {
        int n = 0;
        while (n < plotPanel.objects.size()) {
            this.objects.add(plotPanel.objects.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < plotPanel.componentBounds.size()) {
            this.componentBounds.add(plotPanel.componentBounds.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < plotPanel.getComponentCount()) {
            this.add(plotPanel.getComponent(n));
            ++n;
        }
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.virtualSpace.createUnion(plotPanel.virtualSpace);
        this.virtualSpace = new VRectangle(double_);
        this.repaint();
    }

    protected void paintBackground(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        graphics2D.setRenderingHints(this.hints);
        Color color = graphics.getColor();
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        Font font = graphics2D.getFont();
        Composite composite = graphics2D.getComposite();
        if (!this.objects.isEmpty()) {
            graphics2D.setComposite(this.objectComposite);
            n = 0;
            while (n < this.objects.size()) {
                PlotObject plotObject = (PlotObject)this.objects.elementAt(n);
                plotObject.draw(graphics2D, this.vt);
                ++n;
            }
        }
        graphics.setColor(color);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.setFont(font);
        graphics2D.setComposite(composite);
        if (!this.componentBounds.isEmpty()) {
            int n2 = this.getComponentCount();
            if (n2 != this.componentBounds.size()) {
                throw new NoSuchElementException("Mismatch between numbers of components and virtual bounds. Do not use Container methods to add/remove components. Do not add the same component to the plot and to another container.");
            }
            n = 0;
            while (n < n2) {
                VRectangle vRectangle = (VRectangle)this.componentBounds.elementAt(n);
                Component component = this.getComponent(n);
                Shape shape = this.vt.createTransformedShape(vRectangle);
                component.setBounds(shape.getBounds());
                ++n;
            }
        }
    }

    public VDimension pixelToVirtual(Dimension dimension) {
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        return this.vt.pixelToVirtual(dimension);
    }

    public VPoint pixelToVirtual(Point point) {
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        return this.vt.pixelToVirtual(point);
    }

    public void removeAll() {
        this.objects.removeAllElements();
        super.removeAll();
        this.componentBounds.removeAllElements();
        this.repaint();
    }

    public boolean isAntialiased() {
        return this.hints.get(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public void setAntialiasing(boolean bl) {
        this.hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF));
    }

    public boolean isTextAntialiased() {
        return this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    }

    public void setTextAntialiasing(boolean bl) {
        this.hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
    }

    public void setFocusColour(Color color) {
        this.focusColour = color;
    }

    public void setZoomable(boolean bl) {
        if (bl) {
            this.zoomBoxes = new Stack();
            this.zoomMotionListener = new ZoomMotionListener();
            this.zoomMouseListener = new ZoomMouseListener();
            this.zoomKeyListener = new ZoomKeyListener();
            this.addMouseMotionListener(this.zoomMotionListener);
            this.addMouseListener(this.zoomMouseListener);
            this.addKeyListener(this.zoomKeyListener);
        } else {
            this.removeMouseMotionListener(this.zoomMotionListener);
            this.removeMouseListener(this.zoomMouseListener);
            this.removeKeyListener(this.zoomKeyListener);
        }
    }

    public void setZoomBoxColour(Color color) {
        this.zoomBoxColour = color;
    }

    public void setZoomBoxStroke(Stroke stroke) {
        this.zoomBoxStroke = stroke;
    }

    public Dimension virtualToPixel(VDimension vDimension) {
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        int n = (int)(vDimension.width * this.vt.getScaleX());
        int n2 = (int)(-vDimension.height * this.vt.getScaleY());
        return new Dimension(n, n2);
    }

    public Point virtualToPixel(VPoint vPoint) {
        Point point = new Point();
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        return (Point)this.vt.transform(vPoint, point);
    }

    public int virtualToPixelHeight(double d) {
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        return (int)(-d * this.vt.getScaleY());
    }

    public int virtualToPixelWidth(double d) {
        this.vt = new VirtualTransform(this.virtualSpace, this.getSize());
        return (int)(d * this.vt.getScaleX());
    }

    public boolean write(File file) throws IOException {
        String string = file.getName();
        String[] stringArray = ImageIO.getWriterFormatNames();
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith("." + stringArray[n])) {
                return this.write(file, stringArray[n]);
            }
            ++n;
        }
        return false;
    }

    public boolean write(File file, String string) throws IOException {
        return ImageIO.write((RenderedImage)this.getBufferedImage(), string, file);
    }

    private void zoomIn() {
        if (this.zoomBox.isEmpty()) {
            return;
        }
        this.zoomBoxes.push(this.virtualSpace);
        this.setVirtualSpace(this.zoomBox);
        this.repaint();
    }

    private void zoomOut() {
        if (this.zoomBoxes.empty()) {
            return;
        }
        this.setVirtualSpace((VRectangle)this.zoomBoxes.pop());
        this.repaint();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            JFrame jFrame = new JFrame("PlotPanel Test");
            PlotPanel plotPanel = new PlotPanel(new Dimension(500, 400), new VRectangle(-50.0, -50.0, 100.0, 100.0));
            plotPanel.setZoomable(true);
            plotPanel.setFocusable(true);
            int n = 1000;
            double d = -50.0;
            VPoint[] vPointArray = new VPoint[n];
            int n2 = 0;
            while (n2 < n) {
                vPointArray[n2] = new VPoint(d, 40.0 * Math.sin(d));
                d += 100.0 / (double)n;
                ++n2;
            }
            Polyline polyline = new Polyline(vPointArray);
            plotPanel.addObject(new PlotShape(polyline, Color.black, new BasicStroke(1.0f)));
            plotPanel.addObject(new StandardMarker(new VPoint(0.0, 0.0), 4, 40, Color.blue));
            int n3 = 5;
            VPoint vPoint = new VPoint(-20.0, 0.0);
            Font font = new Font("SansSerif", 0, 12);
            plotPanel.addObject(new StandardMarker(vPoint, 0, 10, Color.red, new BasicStroke(1.0f)));
            plotPanel.addObject(new PlotText("North horizontal text", vPoint, 1, n3, Color.black, font));
            plotPanel.addObject(new PlotText("South horizontal text", vPoint, 2, n3, Color.black, font));
            plotPanel.addObject(new PlotText("East horizontal text", vPoint, 4, n3, Color.black, font));
            plotPanel.addObject(new PlotText("West horizontal text", vPoint, 3, n3, Color.black, font));
            vPoint = new VPoint(20.0, 0.0);
            plotPanel.addObject(new StandardMarker(vPoint, 6, 10, Color.red, new BasicStroke(1.0f)));
            plotPanel.addObject(new PlotText("North vertical text", vPoint, 1, n3, Color.black, font, 90.0));
            plotPanel.addObject(new PlotText("South vertical text", vPoint, 2, n3, Color.black, font, 90.0));
            plotPanel.addObject(new PlotText("East vertical text", vPoint, 4, n3, Color.black, font, 90.0));
            plotPanel.addObject(new PlotText("West vertical text", vPoint, 3, n3, Color.black, font, 90.0));
            plotPanel.addComponent(new JButton("Button"), new VPoint(-40.0, -40.0), new VDimension(30.0, 10.0));
            vPoint = new VPoint(-25.0, 25.0);
            plotPanel.addObject(new StandardMarker(vPoint, 4, 6, Color.red));
            int n4 = 0;
            while (n4 < 360) {
                PlotText plotText = new PlotText("Rotated text " + n4, vPoint, 4, 7, n4);
                plotPanel.addObject(plotText);
                n4 += 30;
            }
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)plotPanel, "Center");
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.pack();
        }
    }

    class ZoomMotionListener
    extends MouseMotionAdapter {
        ZoomMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown()) {
                return;
            }
            VPoint vPoint = PlotPanel.this.pixelToVirtual(mouseEvent.getPoint());
            PlotPanel.this.removeObject(PlotPanel.this.zoomBoxObject);
            PlotPanel.this.zoomBox = new VRectangle(PlotPanel.this.zoomBoxStart, vPoint);
            PlotPanel.this.zoomBoxObject = new PlotShape(PlotPanel.this.zoomBox, PlotPanel.this.zoomBoxColour, PlotPanel.this.zoomBoxStroke);
            PlotPanel.this.addObject(PlotPanel.this.zoomBoxObject);
            PlotPanel.this.repaint();
        }
    }

    class ZoomMouseListener
    extends MouseAdapter {
        ZoomMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown()) {
                PlotPanel.this.zoomOut();
                return;
            }
            PlotPanel.this.zoomBoxStart = PlotPanel.this.pixelToVirtual(mouseEvent.getPoint());
            PlotPanel.this.removeObject(PlotPanel.this.zoomBoxObject);
            PlotPanel.this.zoomBox = new VRectangle(PlotPanel.this.zoomBoxStart, PlotPanel.this.zoomBoxStart);
            PlotPanel.this.zoomBoxObject = new PlotShape(PlotPanel.this.zoomBox, PlotPanel.this.zoomBoxColour, PlotPanel.this.zoomBoxStroke);
            PlotPanel.this.addObject(PlotPanel.this.zoomBoxObject);
            PlotPanel.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown()) {
                return;
            }
            PlotPanel.this.removeObject(PlotPanel.this.zoomBoxObject);
            PlotPanel.this.zoomIn();
        }
    }

    class ZoomKeyListener
    extends KeyAdapter {
        ZoomKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == 'z' || c == 'Z') {
                FieldDialogue fieldDialogue = new FieldDialogue(PlotPanel.this.parent, "Zooming rectangle", "Enter origin & dimensions of zooming box.");
                RealField realField = new RealField(PlotPanel.this.virtualSpace.x, 10);
                RealField realField2 = new RealField(PlotPanel.this.virtualSpace.y, 10);
                RealField realField3 = new RealField(PlotPanel.this.virtualSpace.width, 10);
                RealField realField4 = new RealField(PlotPanel.this.virtualSpace.height, 10);
                fieldDialogue.addField("Lower-left corner x", realField, 0);
                fieldDialogue.addField("Lower-left corner y", realField2, 1);
                fieldDialogue.addField("Width", realField3, 2);
                fieldDialogue.addField("Height", realField4, 3);
                fieldDialogue.setLocationRelativeTo(null);
                if (fieldDialogue.show() == null) {
                    return;
                }
                double d = realField.getValue();
                double d2 = realField2.getValue();
                double d3 = realField3.getValue();
                double d4 = realField4.getValue();
                PlotPanel.this.zoomBox = new VRectangle(d, d2, d3, d4);
                PlotPanel.this.zoomIn();
                keyEvent.consume();
            } else if (c == 'o' || c == 'O') {
                PlotPanel.this.zoomOut();
                keyEvent.consume();
            } else {
                return;
            }
        }
    }

    class KeyboardFocusListener
    extends FocusAdapter {
        KeyboardFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            PlotPanel.this.setBorder(BorderFactory.createLineBorder(PlotPanel.this.focusColour, 1));
        }

        public void focusLost(FocusEvent focusEvent) {
            PlotPanel.this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
    }
}

