/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsc.swt.plot2d.Marker;
import jsc.swt.virtualgraphics.VPoint;

public final class StandardMarker
extends Marker {
    public static final int ASTERISK = 0;
    public static final int CIRCLE = 1;
    public static final int CROSS = 2;
    public static final int DIAMOND = 3;
    public static final int FILLED_CIRCLE = 4;
    public static final int FILLED_DIAMOND = 5;
    public static final int FILLED_SQUARE = 6;
    public static final int PIXEL = 7;
    public static final int PLUS = 8;
    public static final int SQUARE = 9;
    static final int TYPE_COUNT = 10;
    static final String[] names = new String[]{"Asterisk", "Circle", "Cross", "Diamond", "Filled circle", "Filled diamond", "Filled square", "Pixel", "Plus", "Square"};
    int type;

    public StandardMarker(VPoint vPoint, int n) {
        this(vPoint, n, Marker.defaultSize, Marker.defaultColour, Marker.defaultStroke);
    }

    public StandardMarker(VPoint vPoint, int n, int n2) {
        this(vPoint, n, n2, Marker.defaultColour, Marker.defaultStroke);
    }

    public StandardMarker(VPoint vPoint, int n, int n2, Color color) {
        this(vPoint, n, n2, color, Marker.defaultStroke);
    }

    public StandardMarker(VPoint vPoint, int n, int n2, Color color, Stroke stroke) {
        super(vPoint, n2, color, stroke);
        this.setType(n);
    }

    public Shape getShape(Point2D.Float float_) {
        switch (this.type) {
            case 1: 
            case 4: {
                return new Ellipse2D.Float(float_.x - this.halfSize, float_.y - this.halfSize, this.size, this.size);
            }
            case 8: {
                GeneralPath generalPath = new GeneralPath(1, 2);
                generalPath.moveTo(float_.x, float_.y - this.halfSize);
                generalPath.lineTo(float_.x, float_.y + this.halfSize);
                generalPath.moveTo(float_.x - this.halfSize, float_.y);
                generalPath.lineTo(float_.x + this.halfSize, float_.y);
                return generalPath;
            }
            case 0: {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo(float_.x, float_.y - this.halfSize);
                generalPath.lineTo(float_.x, float_.y + this.halfSize);
                generalPath.moveTo(float_.x - this.halfSize, float_.y);
                generalPath.lineTo(float_.x + this.halfSize, float_.y);
                generalPath.moveTo(float_.x - this.halfSize, float_.y - this.halfSize);
                generalPath.lineTo(float_.x + this.halfSize, float_.y + this.halfSize);
                generalPath.moveTo(float_.x - this.halfSize, float_.y + this.halfSize);
                generalPath.lineTo(float_.x + this.halfSize, float_.y - this.halfSize);
                return generalPath;
            }
            case 2: {
                GeneralPath generalPath = new GeneralPath(1, 2);
                generalPath.moveTo(float_.x - this.halfSize, float_.y - this.halfSize);
                generalPath.lineTo(float_.x + this.halfSize, float_.y + this.halfSize);
                generalPath.moveTo(float_.x - this.halfSize, float_.y + this.halfSize);
                generalPath.lineTo(float_.x + this.halfSize, float_.y - this.halfSize);
                return generalPath;
            }
            case 3: 
            case 5: {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo(float_.x - this.halfSize, float_.y);
                generalPath.lineTo(float_.x, float_.y - this.halfSize);
                generalPath.lineTo(float_.x + this.halfSize, float_.y);
                generalPath.lineTo(float_.x, float_.y + this.halfSize);
                generalPath.closePath();
                return generalPath;
            }
            case 6: 
            case 9: {
                return new Rectangle2D.Float(float_.x - this.halfSize, float_.y - this.halfSize, this.size, this.size);
            }
            case 7: {
                return new Rectangle2D.Float(float_.x - 0.5f, float_.y - 0.5f, 1.0f, 1.0f);
            }
        }
        throw new IllegalArgumentException("Invalid marker type.");
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n < 0 || n >= 10) {
            throw new IllegalArgumentException("Invalid marker type.");
        }
        this.type = n;
        this.filled = n == 4 || n == 6 || n == 5;
    }

    public static int getType(String string) {
        int n = 0;
        while (n < 10) {
            if (string.equals(names[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getTypeCount() {
        return 10;
    }

    public static String getTypeName(int n) {
        if (n < 0 || n >= names.length) {
            return null;
        }
        return names[n];
    }
}

