/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.hypermodules.internal.statistics.CoxPh;
import org.cytoscape.hypermodules.internal.statistics.FishersExact;
import org.cytoscape.hypermodules.internal.statistics.LogRankTest;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class HypermodulesAlgorithm {
    private String statTest;
    private ArrayList<String[]> sampleValues;
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> otherValues;
    private HashMap<String, String> allGeneSamplesMap;
    private CyNetwork network;
    private String[] allPatients;
    private boolean[] status;
    private double[] followupDays;
    private double[] daysFromBirth;
    private double[] age;
    private double[] censor;
    private String[] otherPatients;
    private String[] clinicalVariable;
    private HashSet<String> clinicalVariableHash;
    private HashMap<String, String> clinicalVariableMap;
    private ArrayList<String> hashArray;
    private LogRankTest logRankObject;
    private CoxPh coxModel;
    private ArrayList<String> allGenes;
    private ArrayList<String> allSamples;

    public HypermodulesAlgorithm(String statTest, ArrayList<String[]> sampleValues, ArrayList<String[]> clinicalValues, ArrayList<String[]> otherValues, CyNetwork network) {
        this.statTest = statTest;
        this.sampleValues = sampleValues;
        this.otherValues = otherValues;
        this.clinicalValues = clinicalValues;
        this.network = network;
    }

    public void initialize() {
        if (!this.otherValues.isEmpty()) {
            this.initOther();
        }
        this.initClinicals();
        this.logRankObject = new LogRankTest(this.followupDays);
        this.coxModel = new CoxPh(this.followupDays.length, this.followupDays, this.censor, this.age);
        this.coxModel.coxInit();
        this.allGeneSamplesMap = new HashMap();
        for (int i = 0; i < this.sampleValues.size(); ++i) {
            this.allGeneSamplesMap.put(this.sampleValues.get(i)[0], this.sampleValues.get(i)[1]);
        }
        for (CyNode cynode : this.network.getNodeList()) {
            if (this.allGeneSamplesMap.get(this.network.getRow((CyIdentifiable)cynode).get("name", String.class)) != null) continue;
            String[] inconsistency = new String[]{(String)this.network.getRow((CyIdentifiable)cynode).get("name", String.class), "no_sample"};
            this.sampleValues.add(inconsistency);
            this.allGeneSamplesMap.put(this.sampleValues.get(this.sampleValues.size() - 1)[0], this.sampleValues.get(this.sampleValues.size() - 1)[1]);
        }
        ArrayListMultimap memoryone = ArrayListMultimap.create();
        HashSet<String> g2sSamples = new HashSet<String>();
        for (String[] s : this.sampleValues) {
            String[] stringArray;
            for (String t : stringArray = s[1].split(":")) {
                if (t.equals("no_sample")) continue;
                g2sSamples.add(t);
                memoryone.put((Object)t, (Object)s[0]);
            }
        }
        HashSet<String> clinicalSamples = new HashSet<String>();
        for (String[] stringArray : this.clinicalValues) {
            clinicalSamples.add(stringArray[0]);
        }
        for (String string : g2sSamples) {
            if (clinicalSamples.contains(string)) continue;
            for (String z : memoryone.get((Object)string)) {
                this.allGeneSamplesMap.put(z, "no_sample");
                System.out.println("The sample " + string + " was not found in your clinical table. All genes corresponding to " + string + " are now assumed to have no sample.");
            }
        }
        this.allGenes = new ArrayList();
        this.allSamples = new ArrayList();
        for (String string : this.allGeneSamplesMap.keySet()) {
            this.allGenes.add(string);
            this.allSamples.add(this.allGeneSamplesMap.get(string));
        }
    }

    public HashMap<String, Double> mineHublets(ArrayList<String> compressedList) {
        HashMap<String, Double> hubletsTested = new HashMap<String, Double>();
        HashMap<String, Double> repository = new HashMap<String, Double>();
        for (int i = 0; i < compressedList.size(); ++i) {
            String key5 = compressedList.get(i);
            Double value5 = this.testModuleClinical(compressedList.get(i), 1, false);
            if (value5 == null) continue;
            hubletsTested.put(key5, value5);
        }
        if (hubletsTested.isEmpty()) {
            return hubletsTested;
        }
        do {
            HashMap<String[], Double[]> pairwise = new HashMap<String[], Double[]>();
            String[] pairwiseKey = new String[2];
            Double[] pairwiseValue = new Double[2];
            ArrayList<String> list = new ArrayList<String>();
            for (String cy1 : hubletsTested.keySet()) {
                list.add(cy1);
            }
            for (int k = 0; k < list.size(); ++k) {
                for (int j = k + 1; j < list.size(); ++j) {
                    pairwiseKey = new String[]{(String)list.get(k), (String)list.get(j)};
                    pairwiseValue = new Double[]{hubletsTested.get(list.get(k)), hubletsTested.get(list.get(j))};
                    pairwise.put(pairwiseKey, pairwiseValue);
                }
            }
            HashMap<String, Double> pairwiseConcat = new HashMap<String, Double>();
            HashMap<String, String[]> pairwiseConcatMemory = new HashMap<String, String[]>();
            String minKey = null;
            Double minVal = 2.0;
            for (String[] key6 : pairwise.keySet()) {
                Double value7;
                String key7 = key6[0] + ":" + key6[1];
                if (repository.get(key7) != null) {
                    value7 = (Double)repository.get(key7);
                } else {
                    value7 = this.testModuleClinical(key7, 1, false);
                    repository.put(key7, value7);
                }
                if (!(value7 < ((Double[])pairwise.get(key6))[0]) || !(value7 < ((Double[])pairwise.get(key6))[1])) continue;
                pairwiseConcat.put(key7, value7);
                pairwiseConcatMemory.put(key7, key6);
                if (!(value7 < minVal)) continue;
                minVal = value7;
                minKey = key7;
            }
            if (pairwiseConcat.isEmpty()) break;
            hubletsTested.remove(((String[])pairwiseConcatMemory.get(minKey))[0]);
            hubletsTested.remove(((String[])pairwiseConcatMemory.get(minKey))[1]);
            hubletsTested.put(minKey, (Double)pairwiseConcat.get(minKey));
        } while (hubletsTested.size() >= 2);
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String finalTest : hubletsTested.keySet()) {
            Double finalTestValue = this.testModuleClinical(finalTest, 2, true);
            if (finalTestValue != null) continue;
            toBeRemoved.add(finalTest);
        }
        for (String remove : toBeRemoved) {
            hubletsTested.remove(remove);
        }
        if (hubletsTested.isEmpty()) {
            String emptySet = new String();
            emptySet = "none";
            hubletsTested.put(emptySet, 1.0);
            return hubletsTested;
        }
        HashMap<String, String> hubletPatientSamples = new HashMap<String, String>();
        for (String finalFinalTest : hubletsTested.keySet()) {
            String[] nodes = finalFinalTest.split(":");
            String allSampleString = "";
            for (int j = 0; j < nodes.length; ++j) {
                String thesePatientSamples = this.allGeneSamplesMap.get(nodes[j]);
                if (thesePatientSamples.equals("no_sample")) continue;
                allSampleString = allSampleString + thesePatientSamples + ":";
            }
            if (allSampleString.length() >= 2) {
                allSampleString = allSampleString.substring(0, allSampleString.length() - 1);
            }
            hubletPatientSamples.put(finalFinalTest, allSampleString);
        }
        HashMap<String, Boolean> shouldKeep = new HashMap<String, Boolean>();
        for (String hubs : hubletPatientSamples.keySet()) {
            shouldKeep.put(hubs, true);
        }
        for (String firstSet : hubletPatientSamples.keySet()) {
            for (String secondSet : hubletPatientSamples.keySet()) {
                if (firstSet.equals(secondSet)) continue;
                HashSet<String> compareSet = new HashSet<String>();
                String[] firstCompare = ((String)hubletPatientSamples.get(firstSet)).split(":");
                for (int i = 0; i < firstCompare.length; ++i) {
                    compareSet.add(firstCompare[i]);
                }
                int beforeSize = compareSet.size();
                String[] secondCompare = ((String)hubletPatientSamples.get(secondSet)).split(":");
                for (int i = 0; i < secondCompare.length; ++i) {
                    compareSet.add(secondCompare[i]);
                }
                int afterSize = compareSet.size();
                if (beforeSize != afterSize || !(hubletsTested.get(secondSet) > hubletsTested.get(firstSet))) continue;
                shouldKeep.put(secondSet, false);
            }
        }
        ArrayList<String> toBeRemoved2 = new ArrayList<String>();
        for (String ahh : hubletPatientSamples.keySet()) {
            if (((Boolean)shouldKeep.get(ahh)).booleanValue()) continue;
            toBeRemoved2.add(ahh);
        }
        for (String omg : toBeRemoved2) {
            hubletsTested.remove(omg);
        }
        return hubletsTested;
    }

    public String concatenateNetwork(String one, String two) {
        int i;
        String newNetwork = new String();
        newNetwork = "";
        HashSet<String> newHash = new HashSet<String>();
        String[] oneSplit = one.split(":");
        String[] twoSplit = two.split(":");
        for (i = 0; i < oneSplit.length; ++i) {
            newHash.add(oneSplit[i]);
        }
        for (i = 0; i < twoSplit.length; ++i) {
            newHash.add(twoSplit[i]);
        }
        int k = 0;
        for (String addHash : newHash) {
            newNetwork = k == newHash.size() - 1 ? newNetwork + addHash : newNetwork + addHash + ":";
            ++k;
        }
        return newNetwork;
    }

    public Double testModuleFisher(String thisNetwork, int limit) {
        String[] genes = thisNetwork.split(":");
        ArrayList<String> patients = new ArrayList<String>();
        for (int i = 0; i < genes.length; ++i) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                patients.add(thesePatients[t]);
            }
        }
        boolean[] var2patients = new boolean[this.otherValues.size()];
        for (int k = 0; k < this.otherValues.size(); ++k) {
            var2patients[k] = false;
            for (int l = 0; l < patients.size(); ++l) {
                if (!((String)patients.get(l)).equals(this.otherValues.get(k)[0])) continue;
                var2patients[k] = true;
            }
        }
        int alpha = 0;
        for (int k = 0; k < var2patients.length; ++k) {
            if (!var2patients[k]) continue;
            ++alpha;
        }
        if (alpha < limit) {
            return null;
        }
        int[][] matrix = new int[this.clinicalVariableHash.size()][2];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = 0;
            }
        }
        for (int k = 0; k < this.otherValues.size(); ++k) {
            int i;
            if (var2patients[k]) {
                for (i = 0; i < this.hashArray.size(); ++i) {
                    if (!this.clinicalVariableMap.get(this.otherPatients[k]).equals(this.hashArray.get(i))) continue;
                    int[] nArray = matrix[i];
                    nArray[0] = nArray[0] + 1;
                }
                continue;
            }
            for (i = 0; i < this.hashArray.size(); ++i) {
                if (!this.clinicalVariableMap.get(this.otherPatients[k]).equals(this.hashArray.get(i))) continue;
                int[] nArray = matrix[i];
                nArray[1] = nArray[1] + 1;
            }
        }
        FishersExact fe = new FishersExact(matrix);
        return fe.fisher2c();
    }

    public Double testModuleClinical(String thisNetwork, int limit, boolean flag) {
        if (this.statTest.equals("fisher")) {
            return this.testModuleFisher(thisNetwork, limit);
        }
        String[] genes = thisNetwork.split(":");
        HashSet<String> truePatients = new HashSet<String>();
        for (int i = 0; i < genes.length; ++i) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                if (thesePatients[t].equals("no_sample")) continue;
                truePatients.add(thesePatients[t]);
            }
        }
        int alpha = truePatients.size();
        if (alpha < limit) {
            return null;
        }
        if (flag) {
            return 1.0;
        }
        double[] time1 = new double[alpha];
        double[] time2 = new double[this.allPatients.length - alpha];
        double[] censor1 = new double[alpha];
        double[] censor2 = new double[this.allPatients.length - alpha];
        int beta = 0;
        int gamma = 0;
        for (int i = 0; i < this.allPatients.length; ++i) {
            if (truePatients.contains(this.allPatients[i])) {
                time1[beta] = this.followupDays[i];
                censor1[beta] = this.censor[i];
                ++beta;
                continue;
            }
            time2[gamma] = this.followupDays[i];
            censor2[gamma] = this.censor[i];
            ++gamma;
        }
        Double pValue = 0.0;
        if (!this.statTest.equals("logRank") && this.statTest.equals("CoxPh")) {
            double[] group = new double[this.allPatients.length];
            for (int k = 0; k < this.allPatients.length; ++k) {
                group[k] = truePatients.contains(this.allPatients[k]) ? 1.0 : 2.0;
            }
            pValue = this.coxModel.cox(group);
        }
        return pValue;
    }

    public void initOther() {
        int k;
        this.otherPatients = new String[this.otherValues.size()];
        for (k = 0; k < this.otherValues.size(); ++k) {
            this.otherPatients[k] = this.otherValues.get(k)[0];
        }
        this.clinicalVariableMap = new HashMap();
        this.clinicalVariableHash = new HashSet();
        for (k = 0; k < this.otherValues.size(); ++k) {
            this.clinicalVariableMap.put(this.otherValues.get(k)[0], this.otherValues.get(k)[1]);
            this.clinicalVariableHash.add(this.otherValues.get(k)[1]);
        }
        this.hashArray = new ArrayList();
        for (String hashElement : this.clinicalVariableHash) {
            this.hashArray.add(hashElement);
        }
        this.clinicalVariable = new String[this.otherValues.size()];
        for (int k2 = 0; k2 < this.otherValues.size(); ++k2) {
            this.clinicalVariable[k2] = this.otherValues.get(k2)[1];
        }
    }

    public void initClinicals() {
        int k;
        this.allPatients = new String[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.allPatients[k] = this.clinicalValues.get(k)[0];
        }
        this.status = new boolean[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.status[k] = this.clinicalValues.get(k)[1].equals("DECEASED");
        }
        this.followupDays = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.followupDays[k] = Double.valueOf(this.clinicalValues.get(k)[2]);
        }
        this.daysFromBirth = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.daysFromBirth[k] = Double.valueOf(this.clinicalValues.get(k)[3]);
        }
        this.age = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.age[k] = -1.0 * this.daysFromBirth[k] + this.followupDays[k];
        }
        this.censor = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.censor[k] = this.status[k] ? 1.0 : 0.0;
        }
    }

    public ArrayList<String> compressTokens(HashSet<String> allPaths, String seedName) {
        ArrayList<String> compress = new ArrayList<String>();
        HashMap<String, String> allPatients = new HashMap<String, String>();
        for (String network : allPaths) {
            String patients = this.allGeneSamplesMap.get(seedName);
            String[] genes = network.split(":");
            for (int i = 0; i < genes.length; ++i) {
                if (genes[i].equals(seedName) || this.allGeneSamplesMap.get(genes[i]).equals("no_sample")) continue;
                patients = patients + ":" + this.allGeneSamplesMap.get(genes[i]);
            }
            if (allPatients.get(patients) == null) {
                allPatients.put(patients, network);
                continue;
            }
            String[] genes2 = ((String)allPatients.get(patients)).split(":");
            if (genes.length >= genes2.length) continue;
            allPatients.put(patients, network);
        }
        for (String list : allPatients.keySet()) {
            compress.add((String)allPatients.get(list));
        }
        return compress;
    }

    public HashMap<HashSet<String>, Double> expandToHashSet(HashMap<String, Double> original) {
        HashMap<HashSet<String>, Double> returnValue = new HashMap<HashSet<String>, Double>();
        for (String genez : original.keySet()) {
            String[] expanded = genez.split(":");
            HashSet<String> newHashSet = new HashSet<String>();
            for (int i = 0; i < expanded.length; ++i) {
                newHashSet.add(expanded[i]);
            }
            returnValue.put(newHashSet, original.get(genez));
        }
        return returnValue;
    }

    public void shuffleLabels() {
        Collections.shuffle(this.allSamples);
        for (int i = 0; i < this.allGenes.size(); ++i) {
            this.allGeneSamplesMap.put(this.allGenes.get(i), this.allSamples.get(i));
        }
    }
}

