/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.cytoscape.hypermodules.internal.FindPaths;
import org.cytoscape.hypermodules.internal.HypermodulesHeuristicAlgorithm;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.TaskMonitor;

public class ShuffleTestTMCall
implements Callable<HashMap<String, Multimap<String, Double>>> {
    private String expandOption;
    private String statTest;
    private ArrayList<String[]> sampleValues;
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> otherValues;
    private CyNetwork network;
    private TaskMonitor tm;
    private int nShuffled;
    private int nCores;
    private String foregroundvariable;

    public ShuffleTestTMCall(int nCores, int nShuffled, String expandOption, String statTest, String foregroundvariable, ArrayList<String[]> sampleValues, ArrayList<String[]> clinicalValues, ArrayList<String[]> otherValues, TaskMonitor tm, CyNetwork network) {
        this.expandOption = expandOption;
        this.statTest = statTest;
        this.foregroundvariable = foregroundvariable;
        this.sampleValues = sampleValues;
        this.otherValues = otherValues;
        this.clinicalValues = clinicalValues;
        this.tm = tm;
        this.nShuffled = nShuffled;
        this.network = network;
        this.nCores = nCores;
    }

    @Override
    public HashMap<String, Multimap<String, Double>> call() throws Exception {
        HashMap<String, Multimap<String, Double>> rt;
        block6: {
            HypermodulesHeuristicAlgorithm ha;
            block5: {
                rt = new HashMap<String, Multimap<String, Double>>();
                ha = new HypermodulesHeuristicAlgorithm(this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, this.network);
                ha.initialize();
                if (!this.expandOption.equals("expand")) break block5;
                ArrayList<String> seedNames = new ArrayList<String>();
                ArrayList<CyNode> expands = new ArrayList<CyNode>();
                String seedName = "Default";
                CyNode seedExpand = null;
                for (CyNode node : CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true)) {
                    seedName = (String)this.network.getRow((CyIdentifiable)node).get("name", String.class);
                    seedExpand = node;
                    seedNames.add(seedName);
                    expands.add(seedExpand);
                }
                this.tm.setTitle("Testing on Random Permutations");
                int l = 1;
                for (int k = 0; k < seedNames.size(); ++k) {
                    this.tm.setStatusMessage("Running Algorithm on Seed: " + (String)seedNames.get(k));
                    Multimap<String, Double> oneResult = this.testSeed(ha, (String)seedNames.get(k), (CyNode)expands.get(k));
                    rt.put(seedName, oneResult);
                    this.tm.setProgress((double)l / (double)seedNames.size());
                    ++l;
                }
                break block6;
            }
            if (!this.expandOption.equals("findMost")) break block6;
            HashSet<String> allSeeds = new HashSet<String>();
            for (int i = 0; i < this.sampleValues.size(); ++i) {
                if (this.sampleValues.get(i)[1].equals("no_sample") || this.sampleValues.get(i)[1] == null) continue;
                allSeeds.add(this.sampleValues.get(i)[0]);
            }
            HashMap<Object, CyNode> nameAndNode = new HashMap<Object, CyNode>();
            for (CyNode nameNode : this.network.getNodeList()) {
                if (!allSeeds.contains(this.network.getRow((CyIdentifiable)nameNode).get("name", String.class))) continue;
                nameAndNode.put(this.network.getRow((CyIdentifiable)nameNode).get("name", String.class), nameNode);
            }
            this.tm.setTitle("Testing on Random Permutations");
            int k = 1;
            for (String runSeed : nameAndNode.keySet()) {
                this.tm.setStatusMessage("Running Algorithm on Seed: " + runSeed + " ( " + k + " of " + nameAndNode.size() + " )");
                Multimap<String, Double> oneResult = this.testSeed(ha, runSeed, (CyNode)nameAndNode.get(runSeed));
                rt.put(runSeed, oneResult);
                this.tm.setProgress((double)k / (double)nameAndNode.size());
                ++k;
            }
        }
        return rt;
    }

    public Multimap<String, Double> testSeed(HypermodulesHeuristicAlgorithm ha, String seedName, CyNode seedExpand) {
        FindPaths pathfinder = new FindPaths(this.network, 2);
        HashSet<String> allPaths = new HashSet();
        allPaths = pathfinder.getAllPaths2(seedExpand);
        ArrayListMultimap returnMap = ArrayListMultimap.create();
        for (int x = 0; x < this.nShuffled; ++x) {
            ha.shuffleLabels();
            ArrayList<String> compress = ha.compressTokens(allPaths, seedName);
            HashMap<String, Double> shuffledAnswer = ha.mineHublets(compress);
            for (String s : shuffledAnswer.keySet()) {
                returnMap.put((Object)s, (Object)shuffledAnswer.get(s));
            }
        }
        return returnMap;
    }
}

