/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.gui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.util.swing.OpenBrowser;

public class AboutDialog
extends JDialog {
    private CytoscapeUtils utils;
    private String version;
    private OpenBrowser openBrowser;
    private JEditorPane editorPane;
    private JPanel buttonPanel;
    private static final long serialVersionUID = 1L;

    public AboutDialog(CytoscapeUtils utils) {
        super(utils.swingApp.getJFrame(), "About HyperModules", false);
        this.utils = utils;
        this.version = "1.0";
        this.openBrowser = utils.openBrowser;
        this.setResizable(false);
        this.getContentPane().add((Component)this.getMainContainer(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JEditorPane getMainContainer() {
        this.editorPane = new JEditorPane();
        this.editorPane.setMargin(new Insets(10, 10, 10, 10));
        this.editorPane.setEditable(false);
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.editorPane.addHyperlinkListener(new HyperlinkAction());
        String text = "<html><body><P align=center><b>HyperModules v" + this.version + "</b><BR>" + "A Cytoscape App<BR><BR>" + "Version " + this.version + " by <a href='http://www.baderlab.org/'>Bader Lab</a>, University of Toronto<BR>" + "Version 1.0 by Alvin Leung, McGill University<BR>" + "If you use this app in your research, please cite:<BR>" + "Reimand J, Bader GD" + "<a href='http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3564258/'>Systematic analysis of somatic mutations in phosphorylation signaling<BR>" + "predicts novel cancer drivers<BR>" + "</P></body></html>";
        this.editorPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 27: {
                        AboutDialog.this.dispose();
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.editorPane.setText(text);
        return this.editorPane;
    }

    private JPanel getButtonPanel() {
        this.buttonPanel = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        this.buttonPanel.add(close);
        close.setAlignmentX(0.5f);
        return this.buttonPanel;
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        private HyperlinkAction() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AboutDialog.this.openBrowser.openURL(event.getURL().toString());
            }
        }
    }
}

