/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.hypermodules.internal.ChartDisplay;
import org.cytoscape.hypermodules.internal.ChartDisplayFisher;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.hypermodules.internal.gui.ErrorDialog;
import org.cytoscape.hypermodules.internal.task.GenerateNetworkTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class ResultsPanel
extends JPanel
implements CytoPanelComponent,
ActionListener,
MouseListener {
    private HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> allResults;
    private JButton exportMostCorrelated;
    private JButton generate;
    private JButton discard;
    private CytoscapeUtils utils;
    private JScrollPane viewer;
    private JTable resultsTable;
    private JPanel buttonPanel;
    private JButton setCutoff;
    private JTextField cutoff;
    private JPanel panel3;
    private CyNetwork network;
    private HashMap<String, String> parameters;
    private ArrayList<String[]> sampleValues;
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> otherValues;
    private ArrayList<String[]> addToTable;
    private Multimap<String, String> sampleValueHash;
    private HashMap<String, String> patientListHash;
    private double pValueCutoff;
    private String[] sas;
    private JButton chart;
    private double selectedP;
    private JTableHeader tableHeader;
    private static final long serialVersionUID = 1L;

    public ResultsPanel(HashMap<String, String> parameters, CytoscapeUtils utils, HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> allResults, CyNetwork network, ArrayList<String[]> sampleValues, ArrayList<String[]> clinicalValues, ArrayList<String[]> otherValues) {
        this.utils = utils;
        this.allResults = allResults;
        this.network = network;
        this.parameters = parameters;
        this.sampleValues = sampleValues;
        this.clinicalValues = clinicalValues;
        this.otherValues = otherValues;
        this.sampleValueHash = ArrayListMultimap.create();
        for (int i = 0; i < sampleValues.size(); ++i) {
            this.sampleValueHash.put((Object)sampleValues.get(i)[0], (Object)sampleValues.get(i)[1]);
        }
        this.patientListHash = new HashMap();
        for (String s : allResults.keySet()) {
            for (ArrayList<HashMap<String, Double>> ahsd : allResults.get(s).keySet()) {
                HashMap<String, Double> one = ahsd.get(0);
                for (String t : one.keySet()) {
                    this.patientListHash.put(t, this.getPatientList(t));
                }
            }
        }
        this.makeComponents();
        this.makeLayout();
    }

    public String getPatientList(String genes) {
        String ret = "";
        String[] t = genes.split(":");
        HashSet<String> pats = new HashSet<String>();
        for (int i = 0; i < t.length; ++i) {
            for (String s : this.sampleValueHash.get((Object)t[i])) {
                if (s.equals("no_sample")) continue;
                pats.add(s);
            }
        }
        ArrayList<String> as = new ArrayList<String>();
        for (String s : pats) {
            as.add(s);
        }
        Collections.sort(as);
        for (int i = 0; i < as.size(); ++i) {
            ret = ret + (String)as.get(i) + ",";
        }
        if (ret.length() > 0 && ret.charAt(ret.length() - 1) == ',') {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public void makeComponents() {
        this.exportMostCorrelated = new JButton("export results");
        this.exportMostCorrelated.addActionListener(this);
        this.generate = new JButton("visualize");
        this.generate.addActionListener(this);
        this.discard = new JButton("discard results");
        this.discard.addActionListener(this);
        this.chart = new JButton("display chart");
        this.chart.addActionListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add(this.exportMostCorrelated);
        this.buttonPanel.add(this.chart);
        this.buttonPanel.add(this.generate);
        this.buttonPanel.add(this.discard);
        this.setCutoff = new JButton("Set P-Value Cutoff");
        this.setCutoff.addActionListener(this);
        this.cutoff = new JTextField("0.05");
        this.panel3 = new JPanel();
        this.panel3.setLayout(new GridBagLayout());
        this.panel3.add(this.setCutoff);
        this.panel3.add(this.cutoff);
        this.pValueCutoff = 0.05;
        this.setUpTable(true);
    }

    public void sortTable(int colNumber) {
        String[] c;
        System.out.println("col: " + colNumber);
        ArrayList<String[]> newTable = new ArrayList<String[]>();
        Model tab = null;
        if (this.parameters.get("stat").equals("logRank")) {
            c = new String[]{"Seed", "Genes", "Log-Rank P-Value", "Empirical P-value", "# of Patients", "Followup Time Ratio, Log", "List of Patients"};
            tab = new Model(c);
        } else {
            c = new String[]{"Seed", "Genes", "Fisher P-Value", "Empirical P-value", "# of Patients", "Odds Ratio, Log", "List of Patients"};
            tab = new Model(c);
        }
        if (colNumber == 2 || colNumber == 3 || colNumber == 4 || colNumber == 5) {
            ArrayListMultimap mds = ArrayListMultimap.create();
            ArrayList<Double> toSort = new ArrayList<Double>();
            HashSet<Double> gg = new HashSet<Double>();
            for (int i = 0; i < this.addToTable.size(); ++i) {
                gg.add(Double.valueOf(this.addToTable.get(i)[colNumber]));
                String[] mdsentry = new String[6];
                mdsentry[0] = this.addToTable.get(i)[0];
                mdsentry[1] = this.addToTable.get(i)[1];
                mdsentry[5] = this.addToTable.get(i)[6];
                if (colNumber == 2) {
                    mdsentry[2] = this.addToTable.get(i)[3];
                    mdsentry[3] = this.addToTable.get(i)[4];
                    mdsentry[4] = this.addToTable.get(i)[5];
                } else if (colNumber == 3) {
                    mdsentry[2] = this.addToTable.get(i)[2];
                    mdsentry[3] = this.addToTable.get(i)[4];
                    mdsentry[4] = this.addToTable.get(i)[5];
                } else if (colNumber == 4) {
                    mdsentry[2] = this.addToTable.get(i)[2];
                    mdsentry[3] = this.addToTable.get(i)[3];
                    mdsentry[4] = this.addToTable.get(i)[5];
                } else {
                    mdsentry[2] = this.addToTable.get(i)[2];
                    mdsentry[3] = this.addToTable.get(i)[3];
                    mdsentry[4] = this.addToTable.get(i)[4];
                }
                mds.put((Object)Double.valueOf(this.addToTable.get(i)[colNumber]), (Object)mdsentry);
            }
            for (Double t : gg) {
                toSort.add(t);
            }
            Collections.sort(toSort);
            for (int i = 0; i < toSort.size(); ++i) {
                for (String[] d : mds.get(toSort.get(i))) {
                    String[] newentry = new String[7];
                    newentry[0] = d[0];
                    newentry[1] = d[1];
                    newentry[6] = d[5];
                    if (colNumber == 2) {
                        newentry[2] = String.valueOf(toSort.get(i));
                        newentry[3] = d[2];
                        newentry[4] = d[3];
                        newentry[5] = d[4];
                    } else if (colNumber == 3) {
                        newentry[2] = d[2];
                        newentry[3] = String.valueOf(toSort.get(i));
                        newentry[4] = d[3];
                        newentry[5] = d[4];
                    } else if (colNumber == 4) {
                        newentry[2] = d[2];
                        newentry[3] = d[3];
                        newentry[4] = String.valueOf(toSort.get(i));
                        newentry[5] = d[4];
                    } else {
                        newentry[2] = d[2];
                        newentry[3] = d[3];
                        newentry[4] = d[4];
                        newentry[5] = String.valueOf(toSort.get(i));
                    }
                    newTable.add(newentry);
                }
            }
        } else {
            ArrayList<String> toSort = new ArrayList<String>();
            ArrayListMultimap mds = ArrayListMultimap.create();
            HashSet<String> gg = new HashSet<String>();
            for (int i = 0; i < this.addToTable.size(); ++i) {
                gg.add(this.addToTable.get(i)[colNumber]);
                String[] mdsentry = new String[6];
                if (colNumber == 0) {
                    mdsentry[0] = this.addToTable.get(i)[1];
                    mdsentry[1] = this.addToTable.get(i)[2];
                    mdsentry[2] = this.addToTable.get(i)[3];
                    mdsentry[3] = this.addToTable.get(i)[4];
                    mdsentry[4] = this.addToTable.get(i)[5];
                    mdsentry[5] = this.addToTable.get(i)[6];
                } else if (colNumber == 1) {
                    mdsentry[0] = this.addToTable.get(i)[0];
                    mdsentry[1] = this.addToTable.get(i)[2];
                    mdsentry[2] = this.addToTable.get(i)[3];
                    mdsentry[3] = this.addToTable.get(i)[4];
                    mdsentry[4] = this.addToTable.get(i)[5];
                    mdsentry[5] = this.addToTable.get(i)[6];
                } else if (colNumber == 6) {
                    mdsentry[0] = this.addToTable.get(i)[0];
                    mdsentry[1] = this.addToTable.get(i)[1];
                    mdsentry[2] = this.addToTable.get(i)[2];
                    mdsentry[3] = this.addToTable.get(i)[3];
                    mdsentry[4] = this.addToTable.get(i)[4];
                    mdsentry[5] = this.addToTable.get(i)[5];
                }
                mds.put((Object)this.addToTable.get(i)[colNumber], (Object)mdsentry);
            }
            for (String s : gg) {
                toSort.add(s);
            }
            Collections.sort(toSort);
            for (int i = 0; i < toSort.size(); ++i) {
                for (String[] d : mds.get(toSort.get(i))) {
                    String[] newentry = new String[7];
                    if (colNumber == 0) {
                        newentry[0] = (String)toSort.get(i);
                        newentry[1] = d[0];
                        newentry[2] = d[1];
                        newentry[3] = d[2];
                        newentry[4] = d[3];
                        newentry[5] = d[4];
                        newentry[6] = d[5];
                    } else if (colNumber == 1) {
                        newentry[0] = d[0];
                        newentry[1] = (String)toSort.get(i);
                        newentry[2] = d[1];
                        newentry[3] = d[2];
                        newentry[4] = d[3];
                        newentry[5] = d[4];
                        newentry[6] = d[5];
                    } else if (colNumber == 6) {
                        newentry[0] = d[0];
                        newentry[1] = d[1];
                        newentry[2] = d[2];
                        newentry[3] = d[3];
                        newentry[4] = d[4];
                        newentry[5] = d[5];
                        newentry[6] = (String)toSort.get(i);
                    }
                    newTable.add(newentry);
                }
            }
        }
        this.addToTable = new ArrayList();
        this.addToTable = newTable;
        tab.AddCSVData(this.addToTable);
        this.resultsTable = new JTable();
        this.resultsTable.setModel(tab);
        this.tableHeader = this.resultsTable.getTableHeader();
        this.tableHeader.addMouseListener(this);
        this.viewer.setViewportView(this.resultsTable);
    }

    public void setUpTable(boolean first) {
        String[] c = null;
        c = this.parameters.get("stat").equals("logRank") ? new String[]{"Seed", "Genes", "Log-Rank P-Value", "Empirical P-value", "# of Patients", "Followup Time Ratio, Log", "List of Patients"} : new String[]{"Seed", "Genes", "Fisher P-Value", "Empirical P-value", "# of Patients", "Odds Ratio, log", "List of Patients"};
        Model tab = new Model(c);
        this.sas = new String[2];
        this.sas[0] = "none";
        this.addToTable = new ArrayList();
        for (String key : this.allResults.keySet()) {
            for (ArrayList<HashMap<String, Double>> set : this.allResults.get(key).keySet()) {
                for (String genes : set.get(0).keySet()) {
                    String[] newEntry = new String[7];
                    newEntry[0] = key;
                    newEntry[1] = genes;
                    newEntry[2] = String.valueOf(set.get(0).get(genes));
                    Double b = set.get(1).get(genes);
                    newEntry[3] = String.valueOf(b);
                    newEntry[4] = String.valueOf((int)set.get(2).get(genes).doubleValue());
                    newEntry[5] = String.valueOf(set.get(3).get(genes));
                    newEntry[6] = this.patientListHash.get(genes);
                    if (newEntry[1].equals("none")) continue;
                    if (b != null) {
                        if (!(Double.valueOf(newEntry[2]) <= this.pValueCutoff) || !(Double.valueOf(newEntry[3]) <= this.pValueCutoff)) continue;
                        this.addToTable.add(newEntry);
                        continue;
                    }
                    if (!(Double.valueOf(newEntry[2]) <= this.pValueCutoff)) continue;
                    this.addToTable.add(newEntry);
                }
            }
        }
        tab.AddCSVData(this.addToTable);
        this.resultsTable = new JTable();
        this.resultsTable.setModel(tab);
        this.tableHeader = this.resultsTable.getTableHeader();
        this.tableHeader.addMouseListener(this);
        if (first) {
            this.viewer = new JScrollPane(this.resultsTable);
        } else {
            this.viewer.setViewportView(this.resultsTable);
        }
    }

    public void makeLayout() {
        this.setPreferredSize(new Dimension(500, 450));
        this.add(this.viewer);
        this.viewer.setPreferredSize(new Dimension(400, 225));
        this.add(this.buttonPanel);
        this.add(this.panel3);
    }

    public ArrayList<HashMap<String, Double>> extractMostCorrelated() {
        ArrayList<HashMap<String, Double>> rt = new ArrayList<HashMap<String, Double>>();
        HashMap<String, Double> mostCorrelated = new HashMap<String, Double>();
        HashMap<String, Double> mostCorrelatedFDR = new HashMap<String, Double>();
        HashMap<String, Double> mostCorrelatedPatn = new HashMap<String, Double>();
        HashMap<String, Double> mostCorrelatedOddsRatio = new HashMap<String, Double>();
        for (String s : this.allResults.keySet()) {
            for (ArrayList<HashMap<String, Double>> ahhs : this.allResults.get(s).keySet()) {
                HashMap<String, Double> original = ahhs.get(0);
                HashMap<String, Double> adjusted = ahhs.get(1);
                HashMap<String, Double> patn = null;
                HashMap<String, Double> oddsratio = null;
                patn = ahhs.get(2);
                oddsratio = ahhs.get(3);
                for (String set : original.keySet()) {
                    if (!adjusted.containsKey(set) || !(original.get(set) < this.pValueCutoff) || !(adjusted.get(set) < this.pValueCutoff)) continue;
                    mostCorrelated.put(set, original.get(set));
                    mostCorrelatedFDR.put(set, adjusted.get(set));
                    mostCorrelatedPatn.put(set, patn.get(set));
                    mostCorrelatedOddsRatio.put(set, oddsratio.get(set));
                }
            }
        }
        rt.add(mostCorrelated);
        rt.add(mostCorrelatedFDR);
        rt.add(mostCorrelatedPatn);
        rt.add(mostCorrelatedOddsRatio);
        return rt;
    }

    public HashMap<String, String> seedAndString() {
        HashMap<String, String> hss = new HashMap<String, String>();
        for (String s : this.allResults.keySet()) {
            for (ArrayList<HashMap<String, Double>> ahhs : this.allResults.get(s).keySet()) {
                HashMap<String, Double> original = ahhs.get(0);
                HashMap<String, Double> adjusted = ahhs.get(1);
                for (String set : original.keySet()) {
                    if (!adjusted.containsKey(set) || !(original.get(set) < this.pValueCutoff) || !(adjusted.get(set) < this.pValueCutoff)) continue;
                    hss.put(s, set);
                }
            }
        }
        return hss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMostCorrelated() {
        ArrayList<HashMap<String, Double>> a = this.extractMostCorrelated();
        HashMap<String, Double> mostCorrelated = a.get(0);
        HashMap<String, Double> mostCorrelatedFDR = a.get(1);
        HashMap<String, Double> mostCorrelatedPatn = a.get(2);
        HashMap<String, Double> mostCorrelatedOddsRatio = a.get(3);
        String lineSep = System.getProperty("line.separator");
        String fileName = null;
        OutputStreamWriter fout = null;
        try {
            File file = this.utils.fileUtil.getFile((Component)this.utils.swingApp.getJFrame(), "Export Most Correlated Results in CSV File", 1, this.getFilters());
            if (file != null) {
                fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - 4, fileName.length()).equals(".tsv")) {
                    fileName = fileName + ".tsv";
                }
                fout = new FileWriter(fileName);
                fout.write("# HyperModules Results" + lineSep);
                fout.write("# Date: \t" + DateFormat.getDateTimeInstance().format(new Date()) + lineSep + lineSep);
                fout.write("# Length Option: \t" + this.parameters.get("length") + lineSep);
                fout.write("# Expand Option: \t" + this.parameters.get("expand") + lineSep);
                fout.write("# Shuffle Number: \t" + this.parameters.get("nShuffled") + lineSep);
                fout.write("# Statistical Test: \t" + this.parameters.get("stat") + lineSep);
                if (this.parameters.get("stat").equals("fisher")) {
                    fout.write("# Fisher Value Tested: \t" + this.parameters.get("foregroundvariable") + lineSep + lineSep);
                }
                fout.write(lineSep);
                fout.write("Seed\tModule\tPvalue_test\tPvalue_background\tNumber_patients\tLog_odds_ratio\tPatient_list" + lineSep);
                for (String s : mostCorrelated.keySet()) {
                    String[] t = s.split(":");
                    String seed = t[0];
                    ArrayList<String> toSort = new ArrayList<String>();
                    for (int i = 0; i < t.length; ++i) {
                        toSort.add(t[i]);
                    }
                    Collections.sort(toSort);
                    String k = (String)toSort.get(0);
                    for (int i = 1; i < toSort.size(); ++i) {
                        k = k + ";" + (String)toSort.get(i);
                    }
                    String c = "";
                    c = mostCorrelatedOddsRatio.get(s).equals(Double.NEGATIVE_INFINITY) ? "-Infinity" : (mostCorrelatedOddsRatio.get(s).equals(Double.POSITIVE_INFINITY) ? "Infinity" : (Double.isNaN(mostCorrelatedOddsRatio.get(s)) ? "NaN" : String.valueOf(mostCorrelatedOddsRatio.get(s))));
                    fout.write(seed + '\t' + k + '\t' + mostCorrelated.get(s) + '\t' + mostCorrelatedFDR.get(s) + '\t' + (int)mostCorrelatedPatn.get(s).doubleValue() + '\t' + c + '\t' + this.patientListHash.get(s) + lineSep);
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + fileName + "\"", 0);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCorrelatedNetworks() {
        ArrayListMultimap newMultimap = ArrayListMultimap.create();
        ArrayList toSort = new ArrayList();
        for (String s : this.allResults.keySet()) {
            for (ArrayList arrayList : this.allResults.get(s).keySet()) {
                HashMap original = (HashMap)arrayList.get(0);
                for (String set : original.keySet()) {
                    newMultimap.put(original.get(set), (Object)set);
                    toSort.add(original.get(set));
                }
            }
        }
        Collections.sort(toSort);
        ArrayListMultimap newMultimap2 = ArrayListMultimap.create();
        ArrayList<Double> toSort2 = new ArrayList<Double>();
        for (String string : this.allResults.keySet()) {
            for (ArrayList<HashMap<String, Double>> ahhs : this.allResults.get(string).keySet()) {
                HashMap<String, Double> original = ahhs.get(1);
                for (String set : original.keySet()) {
                    newMultimap2.put((Object)original.get(set), (Object)set);
                    toSort2.add(original.get(set));
                }
            }
        }
        Collections.sort(toSort2);
        String lineSep = System.getProperty("line.separator");
        String string = null;
        OutputStreamWriter fout = null;
        try {
            File file = this.utils.fileUtil.getFile((Component)this.utils.swingApp.getJFrame(), "Export Most Correlated Results (Sorted) in Text File", 1, this.getFilters());
            if (file != null) {
                String string2 = file.getAbsolutePath();
                fout = new FileWriter(file);
                fout.write("HyperModules Results" + lineSep);
                fout.write("Date: " + DateFormat.getDateTimeInstance().format(new Date()) + lineSep + lineSep);
                fout.write("Sorted Adjusted Results:" + lineSep);
                for (Double d : toSort2) {
                    for (String hs : newMultimap2.get((Object)d)) {
                        if (d == 1.0) continue;
                        fout.write(hs + " - " + d + lineSep);
                    }
                }
                fout.write("Sorted Original Results:" + lineSep);
                for (Double d : toSort) {
                    for (String hs : newMultimap.get((Object)d)) {
                        if (d == 1.0) continue;
                        fout.write(hs + " - " + d + lineSep);
                    }
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + string + "\"", 0);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportResults() {
        String lineSep = System.getProperty("line.separator");
        String fileName = null;
        OutputStreamWriter fout = null;
        try {
            File file = this.utils.fileUtil.getFile((Component)this.utils.swingApp.getJFrame(), "Export Results in Text File", 1, this.getFilters());
            if (file != null) {
                fileName = file.getAbsolutePath();
                fout = new FileWriter(file);
                fout.write("HyperModules Results" + lineSep);
                fout.write("Date: " + DateFormat.getDateTimeInstance().format(new Date()) + lineSep + lineSep);
                for (String key : this.allResults.keySet()) {
                    fout.write("seed: " + key + lineSep + lineSep);
                    fout.write("True Results: " + lineSep);
                    for (ArrayList<HashMap<String, Double>> conv : this.allResults.get(key).keySet()) {
                        for (String nodes : conv.get(0).keySet()) {
                            fout.write(nodes + "\t" + conv.get(0).get(nodes) + lineSep);
                        }
                    }
                    fout.write(lineSep);
                    fout.write("AdjustedResults: " + lineSep);
                    for (ArrayList<HashMap<String, Double>> conv : this.allResults.get(key).keySet()) {
                        for (String nodes : conv.get(1).keySet()) {
                            fout.write(nodes + "\t" + conv.get(1).get(nodes) + lineSep);
                        }
                    }
                    fout.write(lineSep);
                    fout.write("Random Results: " + lineSep);
                    for (ArrayList<HashMap<String, Double>> conv : this.allResults.get(key).keySet()) {
                        for (String nodes : this.allResults.get(key).get(conv).keySet()) {
                            fout.write(nodes + "\t" + this.allResults.get(key).get(conv).get((Object)nodes) + lineSep);
                        }
                    }
                    fout.write(lineSep);
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + fileName + "\"", 0);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<FileChooserFilter> getFilters() {
        ArrayList<FileChooserFilter> filters = new ArrayList<FileChooserFilter>();
        filters.add(new FileChooserFilter("Text format", "TXT"));
        return filters;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.SOUTH;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "HyperModules Results";
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ErrorDialog ed;
        int row;
        if (ae.getSource() == this.exportMostCorrelated) {
            this.exportMostCorrelated();
        }
        if (ae.getSource() == this.generate) {
            row = this.resultsTable.getSelectedRow();
            if (row >= 0) {
                this.sas = new String[2];
                this.sas[0] = this.addToTable.get(row)[0];
                this.sas[1] = this.addToTable.get(row)[1];
                this.selectedP = Double.valueOf(this.addToTable.get(row)[2]);
                if (this.sas[1] != "none") {
                    this.utils.taskMgr.execute(new TaskIterator(new Task[]{new GenerateNetworkTask(this.sas, this.network, this.utils, this.sampleValues)}));
                }
            } else {
                ed = new ErrorDialog(this.utils, "Please select one valid network to visualize.");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                System.out.println("Please select a valid network to visualize.");
            }
        }
        if (ae.getSource() == this.discard) {
            this.utils.discardResults(this);
        }
        if (ae.getSource() == this.chart) {
            row = this.resultsTable.getSelectedRow();
            if (row >= 0) {
                this.sas = new String[2];
                this.sas[0] = this.addToTable.get(row)[0];
                this.sas[1] = this.addToTable.get(row)[1];
                this.selectedP = Double.valueOf(this.addToTable.get(row)[2]);
                if (this.sas[1] != "none") {
                    if (this.parameters.get("stat").equals("logRank")) {
                        ChartDisplay cd = new ChartDisplay(this.clinicalValues, this.sampleValues, this.network);
                        cd.display(this.sas[1]);
                    } else {
                        ChartDisplayFisher cdf = new ChartDisplayFisher(this.parameters.get("foregroundvariable"), this.selectedP, this.otherValues, this.sampleValues, this.network);
                        cdf.display(this.sas[1]);
                    }
                }
            } else {
                ed = new ErrorDialog(this.utils, "Please select one valid entry to display the chart for.");
                ed.setLocationRelativeTo(null);
                ed.setVisible(true);
                System.out.println("Please select one valid entry to display the chart for.");
            }
        }
        if (ae.getSource() == this.setCutoff) {
            if (Double.valueOf(this.cutoff.getText()) > 1.0 || Double.valueOf(this.cutoff.getText()) < 0.0) {
                System.out.println("Please enter a pValue between 0 and 1.");
            } else {
                this.pValueCutoff = Double.valueOf(this.cutoff.getText());
                System.out.println(this.pValueCutoff);
                this.setUpTable(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.tableHeader) {
            int colNumber = this.resultsTable.columnAtPoint(e.getPoint());
            this.sortTable(colNumber);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames;
        private ArrayList<String[]> data = new ArrayList();

        public Model(String[] columns) {
            this.columnNames = columns;
        }

        public void AddCSVData(ArrayList<String[]> DataIn) {
            this.data = DataIn;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data.get(row)[col];
        }
    }
}

