/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.statistics;

import JSci.maths.statistics.NormalDistribution;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class LogRankTest {
    private HashSet<Double> allTimeHash = new HashSet();
    private ArrayList<Double> uniqueTimes;
    private int hashSize;

    public LogRankTest(double[] followupDays) {
        for (int i = 0; i < followupDays.length; ++i) {
            this.allTimeHash.add(followupDays[i]);
        }
        this.hashSize = this.allTimeHash.size();
        this.uniqueTimes = new ArrayList();
        for (Double add : this.allTimeHash) {
            this.uniqueTimes.add(add);
        }
        Collections.sort(this.uniqueTimes);
    }

    public Double[] logRank(ArrayDeque<Double> sortedTime1, ArrayDeque<Double> sortedTime2, ArrayDeque<Double> sortedCensor1, ArrayDeque<Double> sortedCensor2) {
        double[] n1i = new double[this.hashSize];
        double[] n2i = new double[this.hashSize];
        double[] o1i = new double[this.hashSize];
        double[] o2i = new double[this.hashSize];
        double n1 = sortedTime1.size();
        double n2 = sortedTime2.size();
        for (int i = 0; i < this.uniqueTimes.size(); ++i) {
            double o1 = 0.0;
            double o2 = 0.0;
            n1i[i] = n1;
            n2i[i] = n2;
            while (!sortedTime1.isEmpty() && this.uniqueTimes.get(i).equals(sortedTime1.peekFirst())) {
                if (sortedCensor1.remove() == 1.0) {
                    o1 += 1.0;
                    n1 -= 1.0;
                    sortedTime1.poll();
                    continue;
                }
                sortedTime1.poll();
                n1 -= 1.0;
            }
            while (!sortedTime2.isEmpty() && this.uniqueTimes.get(i).equals(sortedTime2.peekFirst())) {
                if (sortedCensor2.remove() == 1.0) {
                    o2 += 1.0;
                    n2 -= 1.0;
                    sortedTime2.poll();
                    continue;
                }
                sortedTime2.poll();
                n2 -= 1.0;
            }
            o1i[i] = o1;
            o2i[i] = o2;
        }
        double ni = 0.0;
        double oi = 0.0;
        double totalVariance = 0.0;
        double statistic = 0.0;
        for (int i = 0; i < this.uniqueTimes.size(); ++i) {
            ni = n1i[i] + n2i[i];
            oi = o1i[i] + o2i[i];
            statistic += o1i[i] - oi / ni * n1i[i];
            if (ni - 1.0 == 0.0) continue;
            totalVariance += oi * (n1i[i] / ni) * (1.0 - n1i[i] / ni) * (ni - oi) / (ni - 1.0);
        }
        double pValue = 2.0 * (1.0 - new NormalDistribution().cumulative(Math.abs(statistic / Math.pow(totalVariance, 0.5))));
        Double[] returnValue = new Double[]{statistic, totalVariance, pValue};
        return returnValue;
    }

    public boolean logRankSurvivalTest(ArrayDeque<Double> sortedTime1, ArrayDeque<Double> sortedTime2, ArrayDeque<Double> sortedCensor1, ArrayDeque<Double> sortedCensor2) {
        double[] n1i = new double[this.hashSize];
        double[] n2i = new double[this.hashSize];
        double[] o1i = new double[this.hashSize];
        double[] o2i = new double[this.hashSize];
        double n1 = sortedTime1.size();
        double n2 = sortedTime2.size();
        for (int i = 0; i < this.uniqueTimes.size(); ++i) {
            double o1 = 0.0;
            double o2 = 0.0;
            n1i[i] = n1;
            n2i[i] = n2;
            while (!sortedTime1.isEmpty() && this.uniqueTimes.get(i).equals(sortedTime1.peekFirst())) {
                if (sortedCensor1.remove() == 1.0) {
                    o1 += 1.0;
                    n1 -= 1.0;
                    sortedTime1.poll();
                    continue;
                }
                sortedTime1.poll();
                n1 -= 1.0;
            }
            while (!sortedTime2.isEmpty() && this.uniqueTimes.get(i).equals(sortedTime2.peekFirst())) {
                if (sortedCensor2.remove() == 1.0) {
                    o2 += 1.0;
                    n2 -= 1.0;
                    sortedTime2.poll();
                    continue;
                }
                sortedTime2.poll();
                n2 -= 1.0;
            }
            o1i[i] = o1;
            o2i[i] = o2;
        }
        double c = 0.0;
        for (int i = 0; i < o1i.length; ++i) {
            c += o1i[i];
        }
        double d = 0.0;
        for (int i = 0; i < this.uniqueTimes.size(); ++i) {
            double oi = o1i[i] + o2i[i];
            double ni = n1i[i] + n2i[i];
            d += oi / ni * n1i[i];
        }
        return !(d < c);
    }
}

