/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.hypermodules.internal.OriginalTest;
import org.cytoscape.hypermodules.internal.ShuffleTestCall;
import org.cytoscape.hypermodules.internal.ShuffleTestTMCall;
import org.cytoscape.hypermodules.internal.statistics.ConnectR;
import org.cytoscape.hypermodules.internal.statistics.FDRAdjust;
import org.cytoscape.hypermodules.internal.statistics.MyFET;
import org.cytoscape.hypermodules.internal.task.OpenResultsTaskFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class AlgorithmTask
implements Task {
    private HashMap<String, HashMap<String, Double>> originalResults;
    private HashMap<String, HashMap<String, Double>> classification;
    private HashMap<String, Multimap<String, Double>> shuffling;
    private ArrayList<HashMap<String, Multimap<String, Double>>> combinedShuffling;
    private HashMap<String, HashMap<String, Double>> adjustedResults;
    private HashMap<String, HashMap<String, Double>> adjustedWithR;
    private CytoscapeUtils utils;
    private String expandOption;
    private String statTest;
    private ArrayList<String[]> sampleValues;
    private ArrayList<String[]> filteredSampleValues;
    private ArrayList<String[]> clinicalValues;
    private Multimap<String, String> sampleValueHash;
    private ArrayList<String[]> otherValues;
    private int nShuffled;
    private CyNetwork network;
    private String foregroundvariable;
    private boolean interrupted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmTask(CyNetwork currNetwork, int nShuffled, String expandOption, String statTest, String foregroundVariable, ArrayList<String[]> sampleValues, ArrayList<String[]> clinicalValues, ArrayList<String[]> otherValues, CytoscapeUtils utils) {
        this.utils = utils;
        this.expandOption = expandOption;
        this.statTest = statTest;
        this.foregroundvariable = foregroundVariable;
        this.sampleValues = sampleValues;
        this.otherValues = otherValues;
        this.nShuffled = nShuffled;
        this.network = currNetwork;
        this.sampleValueHash = ArrayListMultimap.create();
        for (int i = 0; i < sampleValues.size(); ++i) {
            this.sampleValueHash.put((Object)sampleValues.get(i)[0], (Object)sampleValues.get(i)[1]);
        }
        if (statTest.equals("logRank")) {
            int k;
            ArrayList<String[]> sortedClinicals = new ArrayList<String[]>();
            ArrayListMultimap followupDaysPosition = ArrayListMultimap.create();
            for (int k2 = 0; k2 < clinicalValues.size(); ++k2) {
                boolean b = true;
                try {
                    Double d = Double.valueOf(clinicalValues.get(k2)[2]);
                    continue;
                }
                catch (NumberFormatException e) {
                    b = false;
                    continue;
                }
                finally {
                    if (b) {
                        followupDaysPosition.put((Object)Double.valueOf(clinicalValues.get(k2)[2]), (Object)k2);
                    }
                }
            }
            ArrayList<Double> sortedTime = new ArrayList<Double>();
            ArrayList<Integer> sortedPositions = new ArrayList<Integer>();
            for (Double d : followupDaysPosition.keySet()) {
                sortedTime.add(d);
            }
            Collections.sort(sortedTime);
            HashMap<Double, Boolean> alreadyAdded = new HashMap<Double, Boolean>();
            for (Double key : followupDaysPosition.keySet()) {
                alreadyAdded.put(key, false);
            }
            for (k = 0; k < sortedTime.size(); ++k) {
                if (!((Boolean)alreadyAdded.get(sortedTime.get(k))).booleanValue()) {
                    Collection coll = followupDaysPosition.get(sortedTime.get(k));
                    for (Integer value : coll) {
                        sortedPositions.add(value);
                    }
                }
                alreadyAdded.put((Double)sortedTime.get(k), true);
            }
            for (k = 0; k < sortedPositions.size(); ++k) {
                String[] thisString = new String[]{clinicalValues.get((Integer)sortedPositions.get(k))[0], clinicalValues.get((Integer)sortedPositions.get(k))[1], clinicalValues.get((Integer)sortedPositions.get(k))[2]};
                sortedClinicals.add(thisString);
            }
            this.clinicalValues = sortedClinicals;
        } else {
            this.clinicalValues = clinicalValues;
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.interrupted = false;
        long before = System.nanoTime();
        OriginalTest ot = new OriginalTest(this.expandOption, this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, this.utils, taskMonitor, this.network);
        int nCores = Runtime.getRuntime().availableProcessors();
        this.originalResults = ot.callTest();
        this.fixOriginalResults();
        if (this.statTest.equals("logRank")) {
            this.classification = ot.testHighOrLow(this.originalResults);
        }
        this.combinedShuffling = new ArrayList();
        int shuffleCount = 0;
        if (this.interrupted) {
            System.out.println("Task was cancelled.");
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(nCores);
        ArrayList<Future<HashMap<String, Multimap<String, Double>>>> list = new ArrayList<Future<HashMap<String, Multimap<String, Double>>>>();
        ShuffleTestTMCall sttm = new ShuffleTestTMCall(nCores, this.nShuffled / nCores, this.expandOption, this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, taskMonitor, this.network);
        Future<HashMap<String, Multimap<String, Double>>> submit = executor.submit(sttm);
        list.add(submit);
        shuffleCount += this.nShuffled / nCores;
        for (int i = 1; i < nCores - 1; ++i) {
            ShuffleTestCall st = new ShuffleTestCall(this.nShuffled / nCores, this.expandOption, this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, this.network);
            Future<HashMap<String, Multimap<String, Double>>> submitPool = executor.submit(st);
            list.add(submitPool);
            shuffleCount += this.nShuffled / nCores;
        }
        ShuffleTestCall st = new ShuffleTestCall(this.nShuffled - shuffleCount, this.expandOption, this.statTest, this.foregroundvariable, this.sampleValues, this.clinicalValues, this.otherValues, this.network);
        Future<HashMap<String, Multimap<String, Double>>> submitPool = executor.submit(st);
        list.add(submitPool);
        if (this.interrupted) {
            for (Future future : list) {
                future.cancel(true);
            }
            System.out.println("Task was cancelled.");
            return;
        }
        for (Future future : list) {
            try {
                if (this.interrupted) {
                    for (Future future2 : list) {
                        future2.cancel(true);
                    }
                    System.out.println("Task was cancelled.");
                    return;
                }
                this.combinedShuffling.add((HashMap<String, Multimap<String, Double>>)future.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
        taskMonitor.setTitle("Adjusting Results");
        this.moveShuffled();
        System.out.println("Finished Moving");
        System.out.println("Shuffled size: " + this.getShuffleSize());
        this.adjustResults();
        System.out.println("Finished Adjusting");
        System.out.println("Packaging Data");
        HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> allResults = this.resultsFormat();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("length", "2");
        hashMap.put("expand", this.expandOption);
        hashMap.put("nShuffled", String.valueOf(this.nShuffled));
        hashMap.put("stat", this.statTest);
        hashMap.put("foregroundvariable", this.foregroundvariable);
        OpenResultsTaskFactory resultsTaskFac = new OpenResultsTaskFactory(hashMap, this.utils, allResults, this.network, this.sampleValues, this.clinicalValues, this.otherValues);
        this.utils.taskMgr.execute(resultsTaskFac.createTaskIterator());
        long l = System.nanoTime();
        double timeToRun = (double)(l - before) / 1.0E9;
        System.out.println("Time to run: " + timeToRun + " seconds");
    }

    private void fixOriginalResults() {
        HashMap newOriginal = new HashMap();
        for (String s : this.originalResults.keySet()) {
            HashMap<String, Double> newHash = new HashMap<String, Double>();
            for (String t : this.originalResults.get(s).keySet()) {
                String[] st = t.split(":");
                HashSet<String> hs = new HashSet<String>();
                for (int i = 0; i < st.length; ++i) {
                    hs.add(st[i]);
                }
                String newString = "";
                for (String u : hs) {
                    newString = newString + u + ":";
                }
                newString = newString.substring(0, newString.length() - 1);
                Double d = this.originalResults.get(s).get(t);
                newHash.put(newString, d);
            }
            newOriginal.put(s, newHash);
        }
        this.originalResults = newOriginal;
    }

    private int getShuffleSize() {
        int c = 0;
        for (String s : this.shuffling.keySet()) {
            c += this.shuffling.get(s).size();
        }
        return c;
    }

    private void moveShuffled() {
        this.shuffling = new HashMap();
        HashMap<String, Multimap<String, Double>> lastCore = this.combinedShuffling.get(this.combinedShuffling.size() - 1);
        for (String str : lastCore.keySet()) {
            ArrayListMultimap mhsd = ArrayListMultimap.create();
            for (String hs : lastCore.get(str).keySet()) {
                for (Double d : lastCore.get(str).get((Object)hs)) {
                    mhsd.put((Object)hs, (Object)d);
                }
            }
            this.shuffling.put(str, (Multimap<String, Double>)mhsd);
        }
        for (int i = 1; i < this.combinedShuffling.size(); ++i) {
            HashMap<String, Multimap<String, Double>> thisCore = this.combinedShuffling.get(i);
            for (String s : thisCore.keySet()) {
                for (String hs : thisCore.get(s).keySet()) {
                    for (Double d : thisCore.get(s).get((Object)hs)) {
                        this.shuffling.get(s).put((Object)hs, (Object)d);
                    }
                }
            }
        }
    }

    private void adjustResults() {
        this.adjustedResults = new HashMap();
        for (String s : this.originalResults.keySet()) {
            FDRAdjust fdr = new FDRAdjust(this.originalResults.get(s), this.shuffling.get(s));
            HashMap<String, Double> adjusted = fdr.fdrAdjust();
            this.adjustedResults.put(s, adjusted);
        }
    }

    private void adjustWithR() throws REngineException, REXPMismatchException {
        this.adjustedWithR = new HashMap();
        for (String s : this.originalResults.keySet()) {
            ConnectR cr = new ConnectR(this.originalResults.get(s), this.shuffling.get(s));
            HashMap<String, Double> adjusted = cr.fdrAdjust();
            this.adjustedWithR.put(s, adjusted);
        }
    }

    private HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> resultsFormat() {
        HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> allResults = new HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>>();
        for (String s : this.adjustedResults.keySet()) {
            ArrayList<HashMap<String, Double>> ah = new ArrayList<HashMap<String, Double>>();
            ah.add(this.originalResults.get(s));
            ah.add(this.adjustedResults.get(s));
            if (this.statTest.equals("logRank")) {
                ah.add(this.classification.get(s));
            }
            HashMap<ArrayList<HashMap<String, Double>>, Object> hah = new HashMap<ArrayList<HashMap<String, Double>>, Object>();
            hah.put(ah, null);
            allResults.put(s, hah);
        }
        HashSet<String> sam = new HashSet<String>();
        for (int i = 0; i < this.sampleValues.size(); ++i) {
            String add = this.sampleValues.get(i)[0] + ";" + this.sampleValues.get(i)[1];
            sam.add(add);
        }
        this.filteredSampleValues = new ArrayList();
        for (String s : sam) {
            String[] t = s.split(";");
            this.filteredSampleValues.add(t);
        }
        for (int i = 0; i < this.filteredSampleValues.size(); ++i) {
        }
        allResults = this.filterRedundantResults(allResults);
        return allResults;
    }

    public HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> filterRedundantResults(HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> input) {
        HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>> output = new HashMap<String, HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>>>();
        HashMap<String, Double> masterList = new HashMap<String, Double>();
        ArrayList<String> everyString = new ArrayList<String>();
        for (String s : input.keySet()) {
            for (ArrayList<HashMap<String, Double>> ahsd : input.get(s).keySet()) {
                HashMap<String, Double> original = ahsd.get(0);
                for (String i : original.keySet()) {
                    masterList.put(i, original.get(i));
                    everyString.add(i);
                }
            }
        }
        ArrayList rejectedList = new ArrayList();
        for (int i = 0; i < everyString.size(); ++i) {
            double d = (Double)masterList.get(everyString.get(i));
            for (int j = i; j < everyString.size(); ++j) {
                double e = (Double)masterList.get(everyString.get(j));
                if (d != e || i == j || !this.checkConditions((String)everyString.get(i), (String)everyString.get(j))) continue;
                rejectedList.add(everyString.get(j));
            }
        }
        System.out.println("Redundant Modules Filtered: " + rejectedList.size());
        for (String s : input.keySet()) {
            HashMap hah = new HashMap();
            HashMap<ArrayList<HashMap<String, Double>>, Multimap<String, Double>> inputhah = input.get(s);
            for (ArrayList<HashMap<String, Double>> ahsd : inputhah.keySet()) {
                ArrayList newahsd = new ArrayList();
                HashMap<String, Double> orig = ahsd.get(0);
                HashMap<String, Double> neworig = new HashMap<String, Double>();
                for (String o : orig.keySet()) {
                    boolean rejected = false;
                    for (int i = 0; i < rejectedList.size(); ++i) {
                        if (!((String)rejectedList.get(i)).equals(o)) continue;
                        rejectedList.remove(i);
                        rejected = true;
                        break;
                    }
                    if (rejected) continue;
                    neworig.put(this.seedAtBeginning(s, o), AlgorithmTask.roundToSignificantFigures(orig.get(o), 5));
                }
                HashMap<String, Double> adj = ahsd.get(1);
                HashMap<String, Double> newadj = new HashMap<String, Double>();
                for (String o : orig.keySet()) {
                    boolean rejected = false;
                    for (int i = 0; i < rejectedList.size(); ++i) {
                        if (!((String)rejectedList.get(i)).equals(o)) continue;
                        rejectedList.remove(i);
                        rejected = true;
                        break;
                    }
                    if (rejected) continue;
                    newadj.put(this.seedAtBeginning(s, o), AlgorithmTask.roundToSignificantFigures(adj.get(o), 5));
                }
                HashMap<String, Double> patn = new HashMap<String, Double>();
                for (String x : neworig.keySet()) {
                    patn.put(x, Double.valueOf(this.getNumPatients(x)));
                }
                HashMap<String, Double> oddsratio = new HashMap<String, Double>();
                if (this.statTest.equals("logRank")) {
                    for (String x : neworig.keySet()) {
                        oddsratio.put(x, AlgorithmTask.roundToSignificantFigures(this.getRatioLogRank(x), 5));
                    }
                } else {
                    for (String x : neworig.keySet()) {
                        oddsratio.put(x, AlgorithmTask.roundToSignificantFigures(this.getRatioFisher(x), 5));
                    }
                }
                newahsd.add(neworig);
                newahsd.add(newadj);
                newahsd.add(patn);
                newahsd.add(oddsratio);
                hah.put(newahsd, inputhah.get(ahsd));
            }
            output.put(s, hah);
        }
        return output;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (Double.isNaN(num)) {
            return Double.NaN;
        }
        if (Double.isInfinite(num)) {
            return num;
        }
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public String seedAtBeginning(String s, String t) {
        if (t.equals("none")) {
            return "none";
        }
        String[] splitted = t.split(":");
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < splitted.length; ++i) {
            hs.add(splitted[i]);
        }
        hs.remove(s);
        String returnVal = s;
        for (String x : hs) {
            returnVal = returnVal + ":" + x;
        }
        return returnVal;
    }

    public boolean checkConditions(String s, String t) {
        int i;
        String[] genes1 = s.split(":");
        String[] genes2 = t.split(":");
        HashSet<String> g1 = new HashSet<String>();
        HashSet<String> g2 = new HashSet<String>();
        for (i = 0; i < genes1.length; ++i) {
            g1.add(genes1[i]);
        }
        for (i = 0; i < genes2.length; ++i) {
            g2.add(genes2[i]);
        }
        boolean sSubsetOfT = true;
        for (String x : g1) {
            if (g2.contains(x)) continue;
            sSubsetOfT = false;
        }
        if (g1.contains("EIF2S1") && g1.contains("EIF2S3")) {
            int i2;
            for (i2 = 0; i2 < genes1.length; ++i2) {
                System.out.print(genes1[i2] + " ");
            }
            System.out.println();
            for (i2 = 0; i2 < genes2.length; ++i2) {
                System.out.print(genes2[i2] + " ");
            }
            System.out.println();
            System.out.println("returning: " + sSubsetOfT);
        }
        return sSubsetOfT;
    }

    public String getPatientList(String genes) {
        String ret = "";
        String[] t = genes.split(":");
        HashSet<String> pats = new HashSet<String>();
        for (int i = 0; i < t.length; ++i) {
            for (String s : this.sampleValueHash.get((Object)t[i])) {
                pats.add(s);
            }
        }
        for (String s : pats) {
            ret = ret + s + ",";
        }
        if (ret.charAt(ret.length() - 1) == ',') {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public int getNumPatients(String genes) {
        int result = 0;
        String[] splitted = genes.split(":");
        HashSet<String> checker = new HashSet<String>();
        for (int i = 0; i < splitted.length; ++i) {
            checker.add(splitted[i]);
        }
        HashSet<String> patients = new HashSet<String>();
        for (int i = 0; i < this.filteredSampleValues.size(); ++i) {
            if (!checker.contains(this.filteredSampleValues.get(i)[0]) || this.filteredSampleValues.get(i)[1].equals("no_sample")) continue;
            patients.add(this.filteredSampleValues.get(i)[1]);
        }
        result = patients.size();
        return result;
    }

    public double getRatioLogRank(String genes) {
        String[] g = genes.split(":");
        HashSet<String> gs = new HashSet<String>();
        for (int i = 0; i < g.length; ++i) {
            gs.add(g[i]);
        }
        HashSet<String> inModulePatients = new HashSet<String>();
        for (int i = 0; i < this.filteredSampleValues.size(); ++i) {
            if (!gs.contains(this.filteredSampleValues.get(i)[0]) || this.filteredSampleValues.get(i)[1].equals("no_sample")) continue;
            inModulePatients.add(this.filteredSampleValues.get(i)[1]);
        }
        ArrayList<Double> inModuleFollowup = new ArrayList<Double>();
        ArrayList<Double> outOfModuleFollowup = new ArrayList<Double>();
        for (int i = 0; i < this.clinicalValues.size(); ++i) {
            if (inModulePatients.contains(this.clinicalValues.get(i)[0])) {
                inModuleFollowup.add(Double.valueOf(this.clinicalValues.get(i)[2]));
                continue;
            }
            outOfModuleFollowup.add(Double.valueOf(this.clinicalValues.get(i)[2]));
        }
        if (inModuleFollowup.size() > 0) {
            double p1 = 0.0;
            p1 = inModuleFollowup.size() % 2 == 0 ? ((Double)inModuleFollowup.get(inModuleFollowup.size() / 2) + (Double)inModuleFollowup.get(inModuleFollowup.size() / 2 - 1)) / 2.0 : (Double)inModuleFollowup.get(inModuleFollowup.size() / 2);
            double p2 = 0.0;
            p2 = outOfModuleFollowup.size() % 2 == 0 ? ((Double)outOfModuleFollowup.get(outOfModuleFollowup.size() / 2) + (Double)outOfModuleFollowup.get(outOfModuleFollowup.size() / 2 - 1)) / 2.0 : (Double)outOfModuleFollowup.get(outOfModuleFollowup.size() / 2);
            return Math.log(p1 / p2);
        }
        return Double.NaN;
    }

    public double getRatioFisher(String thisNetwork) {
        String[] genes = thisNetwork.split(":");
        String v1 = this.foregroundvariable;
        HashSet<String> gs = new HashSet<String>();
        for (int i = 0; i < genes.length; ++i) {
            gs.add(genes[i]);
        }
        ArrayList<String> patients = new ArrayList<String>();
        for (int i = 0; i < this.filteredSampleValues.size(); ++i) {
            if (!gs.contains(this.filteredSampleValues.get(i)[0]) || this.filteredSampleValues.get(i)[1].equals("no_sample")) continue;
            patients.add(this.filteredSampleValues.get(i)[1]);
        }
        boolean[] var2patients = new boolean[this.otherValues.size()];
        for (int k = 0; k < this.otherValues.size(); ++k) {
            var2patients[k] = false;
            for (int l = 0; l < patients.size(); ++l) {
                if (!((String)patients.get(l)).equals(this.otherValues.get(k)[0])) continue;
                var2patients[k] = true;
            }
        }
        int alpha = 0;
        for (int k = 0; k < var2patients.length; ++k) {
            if (!var2patients[k]) continue;
            ++alpha;
        }
        int c = 0;
        int matrix00 = 0;
        for (int k = 0; k < this.otherValues.size(); ++k) {
            if (var2patients[k] && this.otherValues.get(k)[1].equals(this.foregroundvariable)) {
                ++matrix00;
            }
            if (!this.otherValues.get(k)[1].equals(this.foregroundvariable)) continue;
            ++c;
        }
        MyFET fet = new MyFET(this.otherValues.size(), c, alpha, matrix00);
        Double rvalue = fet.getLogOdds();
        if (!Double.isNaN(rvalue) && !Double.isInfinite(rvalue)) {
            return rvalue;
        }
        if (rvalue == Double.POSITIVE_INFINITY) {
            rvalue = 1000.0;
        }
        if (rvalue == Double.NEGATIVE_INFINITY) {
            rvalue = -1000.0;
        }
        return rvalue;
    }

    public void cancel() {
        this.interrupted = true;
    }
}

