/*
 * Decompiled with CFR 0.152.
 */
package jsc.ci;

import jsc.ci.ConfidenceInterval;

public class AbstractConfidenceInterval
implements ConfidenceInterval {
    protected double confidenceCoeff;
    protected double lowerLimit;
    protected double upperLimit;

    public AbstractConfidenceInterval() {
        this.setConfidenceCoeff(0.95);
    }

    public AbstractConfidenceInterval(double d) {
        this.setConfidenceCoeff(d);
    }

    public AbstractConfidenceInterval(double d, double d2, double d3) {
        this(d);
        this.lowerLimit = d2;
        this.upperLimit = d3;
    }

    public double getAlpha() {
        return 1.0 - this.confidenceCoeff;
    }

    public double getConfidenceCoeff() {
        return this.confidenceCoeff;
    }

    public double getConfidenceLevel() {
        return 100.0 * this.confidenceCoeff;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setConfidenceCoeff(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient.");
        }
        this.confidenceCoeff = d;
    }

    public String toString() {
        return new String(100.0 * this.confidenceCoeff + "% confidence interval [" + this.lowerLimit + ", " + this.upperLimit + "]");
    }
}

