/*
 * Decompiled with CFR 0.152.
 */
package jsc.ci;

import java.util.Arrays;
import java.util.Vector;
import jsc.ci.AbstractConfidenceInterval;
import jsc.util.Sort;

public class DistributionFreeCI
extends AbstractConfidenceInterval {
    public static final int ONE_SAMPLE = 0;
    public static final int PAIRED_SAMPLE = 1;
    public static final int TWO_SAMPLE_SHIFT = 2;
    public static final int TWO_SAMPLE_RATIO = 3;
    static final int LOOP_MAX = 1000000;
    protected int d;
    protected double achievedConfidence;

    public DistributionFreeCI(double d) {
        super(d);
    }

    protected void computeInterval(int n, int n2, double[] dArray, double[] dArray2) {
        int n3;
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid problem type.");
        }
        if (n == 0 && jsc.util.Arrays.isConstant(dArray)) {
            this.upperLimit = this.lowerLimit = dArray[0];
            return;
        }
        if ((n == 2 || n == 3) && jsc.util.Arrays.isConstant(dArray) && jsc.util.Arrays.isConstant(dArray2)) {
            throw new IllegalArgumentException("Constant data.");
        }
        int n4 = dArray.length;
        int n5 = n == 0 ? n4 : dArray2.length;
        if (n == 1 && n5 != n4) {
            throw new IllegalArgumentException("Arrays not equal length.");
        }
        double d = 0.0;
        int n6 = n4 * n5;
        int n7 = Math.max(n4, n5);
        int[] nArray = new int[n7 + 1];
        double[] dArray3 = new double[n7 + 1];
        double[] dArray4 = new double[n7 + 1];
        int n8 = n4;
        int n9 = 1;
        while (n9 <= n8) {
            dArray3[n9] = dArray[n9 - 1];
            ++n9;
        }
        if (n == 0 || n == 1) {
            if (n == 1) {
                n3 = n5;
                n9 = 1;
                while (n9 <= n3) {
                    dArray4[n9] = dArray2[n9 - 1];
                    ++n9;
                }
                n9 = 1;
                while (n9 <= n8) {
                    dArray3[n9] = dArray3[n9] - dArray4[n9];
                    ++n9;
                }
            } else {
                n3 = n8;
            }
            Sort.sort(dArray3, null, 1, n8, true);
            if (dArray3[1] <= 0.0) {
                d = Math.abs(dArray3[1]);
                n9 = 1;
                while (n9 <= n8) {
                    int n10 = n9++;
                    dArray3[n10] = dArray3[n10] + d;
                }
            }
            n9 = 1;
            while (n9 <= n8) {
                dArray4[n9] = -dArray3[n9];
                ++n9;
            }
        } else {
            n3 = n5;
            n9 = 1;
            while (n9 <= n3) {
                dArray4[n9] = dArray2[n9 - 1];
                ++n9;
            }
            Sort.sort(dArray3, null, 1, n8, true);
            Sort.sort(dArray4, null, 1, n3, false);
            if (n == 3) {
                if (dArray3[1] <= 0.0 || dArray4[n3] <= 0.0) {
                    throw new IllegalArgumentException("Data not greater than zero.");
                }
                n9 = 1;
                while (n9 <= n8) {
                    dArray3[n9] = Math.log(dArray3[n9]);
                    ++n9;
                }
                n9 = 1;
                while (n9 <= n3) {
                    dArray4[n9] = Math.log(dArray4[n9]);
                    ++n9;
                }
            }
            if (!(dArray3[1] > 0.0) || !(dArray4[n3] > 0.0)) {
                if (dArray3[1] < 0.0 && dArray4[n3] > 0.0) {
                    d = Math.abs(dArray3[1]);
                }
                if (dArray3[1] > 0.0 && dArray4[n3] < 0.0) {
                    d = Math.abs(dArray4[n3]);
                }
                if (dArray3[1] < dArray4[n3]) {
                    d = Math.abs(dArray3[1]);
                }
                n9 = 1;
                while (n9 <= n8) {
                    int n11 = n9++;
                    dArray3[n11] = dArray3[n11] + d;
                }
                n9 = 1;
                while (n9 <= n3) {
                    int n12 = n9++;
                    dArray4[n12] = dArray4[n12] + d;
                }
            }
        }
        Double[] doubleArray = this.diff(n, n2, n8, dArray3, n3, dArray4, n6, nArray);
        this.lowerLimit = doubleArray[n2];
        if (n == 0 || n == 1) {
            this.lowerLimit = this.lowerLimit / 2.0 - d;
        }
        if (n == 3) {
            this.lowerLimit = Math.exp(this.lowerLimit);
        }
        Sort.sort(dArray3, null, 1, n8, false);
        Sort.sort(dArray4, null, 1, n3, true);
        doubleArray = this.diff(n, n2, n3, dArray4, n8, dArray3, n6, nArray);
        this.upperLimit = -doubleArray[n2].doubleValue();
        if (n == 0 || n == 1) {
            this.upperLimit = this.upperLimit / 2.0 - d;
            return;
        }
        if (n == 3) {
            this.upperLimit = Math.exp(this.upperLimit);
        }
    }

    private Double[] diff(int n, int n2, int n3, double[] dArray, int n4, double[] dArray2, int n5, int[] nArray) {
        int n6;
        Vector<Double> vector = new Vector<Double>(2 + 2 * n2, 5);
        vector.add(new Double(0.0));
        int n7 = 0;
        double d = 0.0;
        if (n == 0 || n == 1) {
            n6 = 1;
            while (n6 <= n3) {
                nArray[n6] = n6;
                ++n6;
            }
        } else {
            n6 = 1;
            while (n6 <= n4) {
                nArray[n6] = 1;
                ++n6;
            }
        }
        double d2 = (double)n2 * Math.abs(dArray[n3] - dArray[1] + dArray2[1] - dArray2[n4]) / (double)n5;
        int n8 = 0;
        block2: while (true) {
            boolean bl;
            double d3 = dArray[1] + (d += d2);
            int n9 = nArray[1];
            boolean bl2 = false;
            n6 = n9;
            while (n6 <= n3) {
                if (dArray[n6] > d3) {
                    bl2 = true;
                    break;
                }
                ++n7;
                vector.add(new Double(dArray[n6] - dArray2[1]));
                ++n6;
            }
            nArray[1] = bl2 ? n6 : n3 + 1;
            int n10 = 2;
            boolean bl3 = true;
            do {
                if (++n8 > 1000000) {
                    throw new IllegalArgumentException("Cannot calculate confidence interval.");
                }
                if (!bl3) {
                    n10 = n6;
                }
                bl3 = false;
                int n11 = n10;
                while (n11 <= n4) {
                    double d4 = d - dArray2[1] + dArray2[n11];
                    if (d4 <= 0.0) break;
                    d3 = dArray[1] + d4;
                    n9 = nArray[n11];
                    bl2 = false;
                    n6 = n9;
                    while (n6 <= n3) {
                        if (dArray[n6] > d3) {
                            bl2 = true;
                            break;
                        }
                        ++n7;
                        vector.add(new Double(dArray[n6] - dArray2[n11]));
                        ++n6;
                    }
                    nArray[n11] = bl2 ? n6 : n3 + 1;
                    ++n11;
                }
                if (n7 > n2 + 1) {
                    Double[] doubleArray = vector.toArray(new Double[1]);
                    Sort.sort(doubleArray, null, 1, n7, true);
                    return doubleArray;
                }
                if (nArray[1] <= n3) continue block2;
                d += d2;
                bl = false;
                n6 = n10;
                while (n6 <= n4) {
                    if (nArray[n6] <= n3) {
                        bl = true;
                        break;
                    }
                    ++n6;
                }
                if (bl) continue;
                Double[] doubleArray = vector.toArray(new Double[1]);
                Sort.sort(doubleArray, null, 1, n7, true);
                return doubleArray;
            } while (bl);
        }
    }

    public double getAchievedConfidence() {
        return this.achievedConfidence;
    }

    public int getD() {
        return this.d;
    }

    public static double[] differences(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                dArray3[n3++] = dArray[n4] - dArray2[n5];
                ++n5;
            }
            ++n4;
        }
        Arrays.sort(dArray3);
        return dArray3;
    }

    public static double[] walshAverages(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n * (n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            while (n4 < n) {
                dArray2[n2++] = (dArray[n3] + dArray[n4]) / 2.0;
                ++n4;
            }
            ++n3;
        }
        Arrays.sort(dArray2);
        return dArray2;
    }

    public String toString() {
        return new String(super.toString() + ". Achieved confidence = " + this.achievedConfidence);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{-1.0, -2.3, 0.8, -0.1, -2.0, -0.9, 0.3, -2.4, 0.5, -2.5, 1.3, -2.1};
            double[] dArray2 = DistributionFreeCI.walshAverages(dArray);
            System.out.print("\nWalsh averages: ");
            int n = 0;
            while (n < dArray2.length) {
                System.out.print(dArray2[n] + ",");
                ++n;
            }
            double[] dArray3 = new double[]{122.0, 127.0, 110.0, 115.0, 132.0, 131.0, 105.0, 124.0, 112.0, 123.0};
            double[] dArray4 = new double[]{104.0, 103.0, 121.0, 114.0, 95.0, 102.0, 119.0, 108.0, 130.0, 109.0, 99.0, 113.0};
            double[] dArray5 = DistributionFreeCI.differences(dArray3, dArray4);
            System.out.print("\nDifferences: ");
            n = 0;
            while (n < dArray5.length) {
                System.out.print(dArray5[n] + ",");
                ++n;
            }
        }
    }
}

