/*
 * Decompiled with CFR 0.152.
 */
package jsc.combinatorics;

import java.util.NoSuchElementException;
import java.util.Random;
import jsc.combinatorics.Enumerator;
import jsc.combinatorics.Permutation;
import jsc.combinatorics.Selection;
import jsc.util.Maths;

public class Permutations
implements Enumerator {
    private boolean hasNext;
    private long count;
    private Random rand;
    private boolean firstCall;
    private int n;
    private int[] pi;
    private int[] rho;
    private int[] randPerm;
    private final double permutationCount;

    public Permutations(int n) {
        this.n = n;
        this.permutationCount = Maths.factorial(n);
        if (n < 1) {
            throw new IllegalArgumentException("Less than one object.");
        }
        this.pi = new int[n + 1];
        this.rho = new int[n + 1];
        this.rand = new Random();
        this.randPerm = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.randPerm[n2] = n2 + 1;
            ++n2;
        }
        this.reset();
    }

    public double countSelections() {
        return this.permutationCount;
    }

    public int getN() {
        return this.n;
    }

    private Permutation getPermutation() {
        int[] nArray = new int[this.n];
        int n = 1;
        while (n <= this.n) {
            nArray[n - 1] = this.pi[n];
            ++n;
        }
        if ((double)this.count > this.permutationCount) {
            this.hasNext = false;
        }
        return new Permutation(nArray, false);
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Permutation nextPermutation() {
        this.pi[0] = 0;
        if (this.firstCall) {
            this.firstCall = false;
            ++this.count;
            return this.getPermutation();
        }
        int n = this.n - 1;
        while (this.pi[n + 1] < this.pi[n]) {
            --n;
        }
        if (n == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.n;
        while (this.pi[n2] < this.pi[n]) {
            --n2;
        }
        int n3 = this.pi[n2];
        this.pi[n2] = this.pi[n];
        this.pi[n] = n3;
        int n4 = n + 1;
        while (n4 <= this.n) {
            this.rho[n4] = this.pi[n4];
            ++n4;
        }
        n4 = n + 1;
        while (n4 <= this.n) {
            this.pi[n4] = this.rho[this.n + n + 1 - n4];
            ++n4;
        }
        ++this.count;
        return this.getPermutation();
    }

    public Selection nextSelection() {
        return this.nextPermutation();
    }

    public Permutation randomPermutation() {
        int n = 0;
        while (n < this.n) {
            int n2 = n + this.rand.nextInt(this.n - n);
            int n3 = this.randPerm[n2];
            this.randPerm[n2] = this.randPerm[n];
            this.randPerm[n] = n3;
            ++n;
        }
        return new Permutation(this.randPerm, false);
    }

    public Selection randomSelection() {
        return this.randomPermutation();
    }

    public void reset() {
        int n = 1;
        while (n <= this.n) {
            this.pi[n] = n;
            ++n;
        }
        this.firstCall = true;
        this.count = 1L;
        this.hasNext = true;
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            Permutation permutation;
            int n = 3;
            Permutations permutations = new Permutations(n);
            int n2 = (int)permutations.countSelections();
            System.out.println("Number of permutations = " + n2);
            System.out.println("All permutations");
            while (permutations.hasNext()) {
                permutation = permutations.nextPermutation();
                System.out.println(permutation.toString());
            }
            permutations.reset();
            System.out.println("All permutations");
            while (permutations.hasNext()) {
                permutation = permutations.nextPermutation();
                System.out.println(permutation.toString());
            }
        }
    }
}

