/*
 * Decompiled with CFR 0.152.
 */
package jsc.contingencytables;

import jsc.contingencytables.ContingencyTable;
import jsc.distributions.ChiSquared;
import jsc.tests.SignificanceTest;

public class ChiSquaredTest
implements SignificanceTest {
    private boolean smallE = false;
    private int df;
    double chiSquared;
    private double SP;
    private double[][] E;
    private double[][] resids;
    private ContingencyTable tableCopy;

    public ChiSquaredTest(ContingencyTable contingencyTable) {
        this.tableCopy = contingencyTable.copy();
        int n = contingencyTable.getColumnCount();
        if (n < 2) {
            throw new IllegalArgumentException("Less than 2 columns.");
        }
        int n2 = contingencyTable.getRowCount();
        if (n2 < 2) {
            throw new IllegalArgumentException("Less than 2 rows.");
        }
        int[] nArray = contingencyTable.getColumnTotals();
        int[] nArray2 = contingencyTable.getRowTotals();
        double d = contingencyTable.getN();
        this.df = (n2 - 1) * (n - 1);
        double d2 = this.varpear(d, n2, n, nArray2, nArray);
        this.E = new double[n2][n];
        this.resids = new double[n2][n];
        int[][] nArray3 = contingencyTable.getFrequencies();
        this.chiSquared = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.E[n3][n4] = (double)(nArray2[n3] * nArray[n4]) / d;
                if (this.E[n3][n4] <= 0.0) {
                    throw new IllegalArgumentException("An expected frequency is zero.");
                }
                if (this.E[n3][n4] < 5.0 && d2 >= (double)(this.df + this.df)) {
                    this.smallE = true;
                }
                this.resids[n3][n4] = ((double)nArray3[n3][n4] - this.E[n3][n4]) * ((double)nArray3[n3][n4] - this.E[n3][n4]) / this.E[n3][n4];
                this.chiSquared += this.resids[n3][n4];
                ++n4;
            }
            ++n3;
        }
        this.SP = ChiSquared.upperTailProb(this.chiSquared, this.df);
    }

    public ContingencyTable getContingencyTable() {
        return this.tableCopy;
    }

    public int getN() {
        return this.tableCopy.getN();
    }

    public int getRowCount() {
        return this.tableCopy.getRowCount();
    }

    public int[] getRowTotals() {
        return this.tableCopy.getRowTotals();
    }

    public int getColumnCount() {
        return this.tableCopy.getColumnCount();
    }

    public int[] getColumnTotals() {
        return this.tableCopy.getColumnTotals();
    }

    public double[][] getExpectedFrequencies() {
        return this.E;
    }

    public double getExpectedFrequency(int n, int n2) {
        return this.E[n][n2];
    }

    public int[][] getObservedFrequencies() {
        return this.tableCopy.getFrequencies();
    }

    public int getObservedFrequency(int n, int n2) {
        return this.tableCopy.getFrequency(n, n2);
    }

    public double[][] getResiduals() {
        return this.resids;
    }

    public double getResidual(int n, int n2) {
        return this.resids[n][n2];
    }

    public int getDegreesOfFreedom() {
        return this.df;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.chiSquared;
    }

    public boolean hasSmallExpectedFrequency() {
        return this.smallE;
    }

    private double varpear(double d, int n, int n2, int[] nArray, int[] nArray2) {
        double d2 = 0.0;
        if (d < 4.0) {
            return Double.MAX_VALUE;
        }
        double d3 = (d - (double)n) * ((double)n - 1.0) / (d - 1.0);
        double d4 = (d - (double)n2) * ((double)n2 - 1.0) / (d - 1.0);
        int n3 = 0;
        while (n3 < n) {
            if ((double)nArray[n3] <= 0.0) {
                return Double.MAX_VALUE;
            }
            d2 += 1.0 / (double)nArray[n3];
            ++n3;
        }
        double d5 = (d2 - (double)(n * n) / d) * d / (d - 2.0);
        d2 = 0.0;
        n3 = 0;
        while (n3 < n2) {
            if ((double)nArray2[n3] <= 0.0) {
                return Double.MAX_VALUE;
            }
            d2 += 1.0 / (double)nArray2[n3];
            ++n3;
        }
        double d6 = (d2 - (double)(n2 * n2) / d) * d / (d - 2.0);
        return 2.0 * d / (d - 3.0) * (d3 - d5) * (d4 - d6) + d * d / (d - 1.0) * d5 * d6;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"Improved", "Same or worse"};
            String[] stringArray3 = new String[]{"Placebo", "Drug 1", "Drug 2", "Drug 3", "Drug 4", "Drug 5"};
            int[][] nArrayArray = new int[][]{{8, 12, 21, 15, 14, 19}, {22, 18, 9, 15, 16, 11}};
            ContingencyTable contingencyTable = new ContingencyTable(stringArray2, stringArray3, (int[][])nArrayArray);
            System.out.println(contingencyTable.toString());
            ChiSquaredTest chiSquaredTest = new ChiSquaredTest(contingencyTable);
            System.out.println("Chi-squared = " + chiSquaredTest.getTestStatistic() + " SP = " + chiSquaredTest.getSP());
            int[] nArray = new int[]{2, 1, 2, 2, 2, 3, 3, 2, 1, 1, 2, 3, 2, 3, 2, 3, 1, 2, 3, 2};
            int[] nArray2 = new int[]{8, 8, 9, 8, 9, 9, 9, 8, 8, 9, 8, 8, 9, 8, 8, 9, 9, 8, 8, 9};
            contingencyTable = new ContingencyTable(nArray, nArray2);
            System.out.println(contingencyTable.toString());
            chiSquaredTest = new ChiSquaredTest(contingencyTable);
            System.out.println("Chi-squared = " + chiSquaredTest.getTestStatistic() + " SP = " + chiSquaredTest.getSP());
        }
    }
}

