/*
 * Decompiled with CFR 0.152.
 */
package jsc.datastructures;

public class PairedData {
    private int n;
    private double[] x;
    private double[] y;

    public PairedData(double[] dArray, double[] dArray2) {
        this.n = dArray.length;
        if (this.n != dArray2.length) {
            throw new IllegalArgumentException("Arrays not equal length.");
        }
        if (this.n < 1) {
            throw new IllegalArgumentException("No data.");
        }
        this.x = new double[this.n];
        this.y = new double[this.n];
        System.arraycopy(dArray, 0, this.x, 0, this.n);
        System.arraycopy(dArray2, 0, this.y, 0, this.n);
    }

    public PairedData(double[][] dArray) {
        this.n = dArray.length;
        if (this.n < 1) {
            throw new IllegalArgumentException("No data.");
        }
        this.x = new double[this.n];
        this.y = new double[this.n];
        int n = 0;
        while (n < this.n) {
            this.x[n] = dArray[n][0];
            this.y[n] = dArray[n][1];
            ++n;
        }
    }

    public double[] differences() {
        double[] dArray = new double[this.n];
        int n = 0;
        while (n < this.n) {
            dArray[n] = this.x[n] - this.y[n];
            ++n;
        }
        return dArray;
    }

    public int getN() {
        return this.n;
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nPaired data");
        stringBuffer.append("\nX\tY");
        int n = 0;
        while (n < this.getN()) {
            stringBuffer.append("\n" + this.x[n] + "\t" + this.y[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{17.4, 15.7, 12.9, 9.8, 13.4, 18.7, 13.9, 11.0, 5.4, 10.4, 16.4, 5.6};
            double[] dArray2 = new double[]{13.6, 10.1, 10.3, 9.2, 11.1, 20.4, 10.4, 11.4, 4.9, 8.9, 11.2, 4.8};
            PairedData pairedData = new PairedData(dArray, dArray2);
            double[] dArray3 = pairedData.getX();
            double[] dArray4 = pairedData.getY();
            double[] dArray5 = pairedData.differences();
            int n = 0;
            while (n < pairedData.getN()) {
                System.out.println(dArray3[n] + " " + dArray4[n] + " " + dArray5[n]);
                ++n;
            }
            double[][] dArrayArray = new double[][]{{17.4, 13.6}, {15.7, 10.1}, {12.9, 10.3}, {9.8, 9.2}, {13.4, 11.1}, {18.7, 20.4}, {13.9, 10.4}, {11.0, 11.4}, {5.4, 4.9}, {10.4, 8.9}, {16.4, 11.2}, {5.6, 4.8}};
            pairedData = new PairedData(dArrayArray);
            System.out.println(pairedData.toString());
        }
    }
}

