/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;

public class DiscreteUniform
extends AbstractDiscreteDistribution {
    private long a;
    private long b;
    private double n;

    public DiscreteUniform(long l, long l2) {
        super(l, l2);
        this.setInterval(l, l2);
    }

    public double cdf(double d) {
        if (d < (double)this.a || d > (double)this.b) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return (1.0 + d - (double)this.a) / this.n;
    }

    public long getA() {
        return this.a;
    }

    public long getB() {
        return this.b;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 1.0) {
            return this.b;
        }
        long l = this.a;
        double d2 = 1.0 / this.n;
        while (d2 < d && l < this.b) {
            d2 = (1.0 + (double)(++l) - (double)this.a) / this.n;
        }
        return l;
    }

    public double mean() {
        return 0.5 * (double)(this.a + this.b);
    }

    public double pdf(double d) {
        if (d < (double)this.a || d > (double)this.b) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 / this.n;
    }

    public double random() {
        return Math.floor((double)this.a + this.rand.nextDouble() * this.n);
    }

    public void setInterval(long l, long l2) {
        if (l2 <= l) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.a = l;
        this.b = l2;
        this.minValue = l;
        this.maxValue = l2;
        this.n = l2 - l + 1L;
    }

    public String toString() {
        return new String("Discrete uniform distribution: a = " + this.a + ", b = " + this.b + ".");
    }

    public double variance() {
        double d = this.mean();
        double d2 = 0.0;
        long l = this.a;
        while (l <= this.b) {
            double d3 = (double)l - d;
            d2 += d3 * d3;
            ++l;
        }
        return d2 / this.n;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            long l = 1L;
            long l2 = 10L;
            double d = 0.5;
            DiscreteUniform discreteUniform = new DiscreteUniform(l, l2);
            int n = 10000;
            int[] nArray = new int[n];
            discreteUniform = new DiscreteUniform(10L, 20L);
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)discreteUniform.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)discreteUniform, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

