/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.Distribution;
import jsc.goodnessfit.ChiSquaredFitTest;
import jsc.util.Maths;

public class ExtendedHypergeometric
extends AbstractDiscreteDistribution {
    private int n1;
    private int n2;
    private int m;
    private int mode;
    private int ll;
    private int uu;
    private double mean;
    private double variance;
    private double psi;
    private int lStar;
    private int uStar;
    private double[] prob;

    public ExtendedHypergeometric(int n, int n2, int n3, double d, double d2) {
        super(Math.max(0, n3 - n2), Math.min(n, n3));
        this.setParameters(n, n2, n3, d, d2);
    }

    public ExtendedHypergeometric(int n, int n2, int n3, double d) {
        this(n, n2, n3, d, 0.0);
    }

    public double cdf(double d) {
        if (d < (double)this.ll || d > (double)this.uu) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d < (double)this.lStar) {
            return 0.0;
        }
        if (d >= (double)this.uStar) {
            return 1.0;
        }
        double d2 = 0.0;
        long l = this.lStar;
        while ((double)l <= d) {
            d2 += this.prob[(int)(l - (long)this.lStar)];
            ++l;
        }
        return d2;
    }

    public int getEffectiveMaxX() {
        return this.uStar;
    }

    public int getEffectiveMinX() {
        return this.lStar;
    }

    public double getMaximumPdf() {
        double d = 0.0;
        int n = 0;
        while (n < this.prob.length) {
            if (this.prob[n] > d) {
                d = this.prob[n];
            }
            ++n;
        }
        return d;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return Math.max(this.lStar - 1, this.ll);
        }
        if (d == 1.0) {
            return this.uStar;
        }
        long l = this.lStar;
        double d2 = this.prob[0];
        while (l < (long)this.uStar && d2 < d) {
            d2 += this.prob[(int)(++l - (long)this.lStar)];
        }
        return l;
    }

    public double mean() {
        return this.mean;
    }

    public int mode() {
        return this.mode;
    }

    public double pdf(double d) {
        if (d < (double)this.ll || d > (double)this.uu) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d < (double)this.lStar || d > (double)this.uStar) {
            return 0.0;
        }
        return this.prob[(int)d - this.lStar];
    }

    public double random() {
        double d = 0.0;
        double d2 = this.rand.nextDouble();
        long l = this.lStar;
        int n = 0;
        while (n < this.prob.length) {
            if (d2 < (d += this.prob[n])) {
                return l;
            }
            ++l;
            ++n;
        }
        return this.uStar;
    }

    private double rFunction(int n) {
        double d = n;
        return ((double)this.n1 - d + 1.0) * ((double)this.m - d + 1.0) / d / ((double)(this.n2 - this.m) + d) * this.psi;
    }

    public void setParameters(int n, int n2, int n3, double d, double d2) {
        double d3;
        this.ll = Math.max(0, n3 - n2);
        this.uu = Math.min(n, n3);
        int n4 = n + n2;
        if (n < 0 || n2 < 0 || n3 < 0 || n3 > n4 || d <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.minValue = this.ll;
        this.maxValue = this.uu;
        this.n1 = n;
        this.n2 = n2;
        this.m = n3;
        this.psi = d;
        double d4 = d - 1.0;
        double d5 = -((double)(n3 + n + 2) * d + (double)n2 - (double)n3);
        double d6 = d * (double)(n + 1) * (double)(n3 + 1);
        double d7 = d5 + (double)(d5 < 0.0 ? -1 : 1) * Math.sqrt(d5 * d5 - 4.0 * d4 * d6);
        d7 = -d7 / 2.0;
        this.mode = (int)Maths.truncate(d6 / d7);
        if (this.uu < this.mode || this.mode < this.ll) {
            this.mode = (int)Maths.truncate(d7 / d4);
        }
        double[] dArray = new double[this.uu + 2];
        dArray[this.mode] = 1.0;
        double d8 = 0.1 * d2;
        int n5 = this.mode + 1;
        while (n5 <= this.uu) {
            d3 = this.rFunction(n5);
            dArray[n5] = dArray[n5 - 1] * d3;
            if (dArray[n5] <= d8 && d3 < 0.8333333333333333) break;
            ++n5;
        }
        this.uStar = Math.min(n5, this.uu);
        n5 = this.mode - 1;
        while (n5 >= this.ll) {
            d3 = this.rFunction(n5 + 1);
            dArray[n5] = dArray[n5 + 1] / d3;
            if (dArray[n5] <= d8 && d3 > 1.2) break;
            --n5;
        }
        this.lStar = Math.max(this.ll, n5);
        int n6 = this.uStar - this.lStar + 1;
        this.prob = new double[n6];
        n5 = this.lStar;
        int n7 = 0;
        while (n5 <= this.uStar) {
            this.prob[n7] = dArray[n5];
            ++n5;
            ++n7;
        }
        double d9 = 0.0;
        n5 = 0;
        while (n5 < n6) {
            d9 += this.prob[n5];
            ++n5;
        }
        if (d9 <= 0.0) {
            throw new IllegalArgumentException("Zero probabilities.");
        }
        n5 = 0;
        while (n5 < n6) {
            int n8 = n5++;
            this.prob[n8] = this.prob[n8] / d9;
        }
        this.mean = 0.0;
        this.variance = 0.0;
        n5 = 0;
        n7 = this.lStar;
        while (n7 <= this.uStar) {
            this.mean += (double)n7 * this.prob[n5];
            ++n5;
            ++n7;
        }
        n5 = 0;
        n7 = this.lStar;
        while (n7 <= this.uStar) {
            this.variance += ((double)n7 - this.mean) * ((double)n7 - this.mean) * this.prob[n5];
            ++n5;
            ++n7;
        }
    }

    public String toString() {
        return new String("Extended hypergeometric distribution: n1 = " + this.n1 + ", n2 = " + this.n2 + ", m = " + this.m + ", psi = " + this.psi + ".");
    }

    public double variance() {
        return this.variance;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n;
            int n2 = n = 500;
            int n3 = n;
            int n4 = n;
            double d = 6.0;
            double d2 = 1.0E-14;
            ExtendedHypergeometric extendedHypergeometric = new ExtendedHypergeometric(500, 500, 500, 6.0, 1.0E-14);
            System.out.println(extendedHypergeometric.toString());
            int n5 = 1000000;
            int[] nArray = new int[n5];
            int[] nArray2 = new int[]{50, 500, 5000, 50, 500, 5000};
            double[] dArray = new double[]{1.5, 1.5, 1.5, 6.0, 6.0, 6.0};
            System.out.println("tolerance = " + d2);
            int n6 = 0;
            while (n6 < nArray2.length) {
                extendedHypergeometric.setParameters(nArray2[n6], nArray2[n6], nArray2[n6], dArray[n6], d2);
                double d3 = 0.0;
                double d4 = 0.0;
                long l = System.currentTimeMillis();
                int n7 = 0;
                while (n7 < n5) {
                    nArray[n7] = (int)extendedHypergeometric.random();
                    ++n7;
                }
                long l2 = System.currentTimeMillis();
                n7 = 0;
                while (n7 < n5) {
                    d3 += (double)nArray[n7];
                    ++n7;
                }
                double d5 = Maths.round(d3 / (double)n5, 4);
                n7 = 0;
                while (n7 < n5) {
                    d4 += ((double)nArray[n7] - d5) * ((double)nArray[n7] - d5);
                    ++n7;
                }
                double d6 = Maths.round(d4 / (double)n5, 4);
                System.out.println("m=" + nArray2[n6] + " psi=" + dArray[n6] + " l=" + extendedHypergeometric.getEffectiveMinX() + " mode=" + extendedHypergeometric.mode() + " u=" + extendedHypergeometric.getEffectiveMaxX() + " " + (l2 - l) / 1000L + " secs" + " mean=" + d5 + " var=" + d6);
                ++n6;
            }
            n5 = 10000;
            extendedHypergeometric = new ExtendedHypergeometric(50, 50, 90, 6.0, d2);
            int[] nArray3 = new int[n5];
            n6 = 0;
            while (n6 < n5) {
                nArray3[n6] = (int)extendedHypergeometric.random();
                ++n6;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray3), (Distribution)extendedHypergeometric, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("n = " + n5 + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

