/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.DoubleTally;
import jsc.distributions.Distribution;
import jsc.distributions.RankSumOfSquares;
import jsc.goodnessfit.ChiSquaredFitTest;

public class FriedmanM
extends RankSumOfSquares {
    public FriedmanM(int n, int n2) {
        super(n, n2);
        double d = 12.0 * ((double)n2 - 1.0) / ((double)(n * n2) * ((double)(n2 * n2) - 1.0));
        int n3 = 0;
        while (n3 < this.getValueCount()) {
            this.values[n3] = d * this.values[n3];
            ++n3;
        }
    }

    public String toString() {
        return new String("Friedman's M distribution: n = " + this.n + ", k = " + this.k + ".");
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10;
            int n2 = 3;
            int n3 = 10000;
            FriedmanM friedmanM = new FriedmanM(10, 3);
            double[] dArray = new double[n3];
            int n4 = 0;
            while (n4 < n3) {
                dArray[n4] = friedmanM.random();
                ++n4;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new DoubleTally(dArray), (Distribution)friedmanM, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n3 + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

