/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.distributions.Beta;
import jsc.distributions.ChiSquared;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class StudentsT
extends AbstractDistribution {
    static final double LOGPI = Math.log(Math.PI);
    private ChiSquared chiSquared;
    private double df;

    public StudentsT(double d) {
        this.setDf(d);
    }

    public double cdf(double d) {
        double d2 = StudentsT.tailProb(d, this.df);
        return d > 0.0 ? 1.0 - d2 : d2;
    }

    public double getDf() {
        return this.df;
    }

    public double getMaximumPdf() {
        return Math.exp(Maths.logGamma(0.5 * (this.df + 1.0)) - Maths.logGamma(0.5 * this.df) - 0.5 * Math.log(Math.PI * this.df));
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = d > 0.5 ? 1.0 - d : d;
        double d3 = Beta.inverseIncompleteBeta(this.df / 2.0, 0.5, Maths.lnB(this.df / 2.0, 0.5), d2 + d2);
        if (d3 == 1.0) {
            return 0.0;
        }
        if (d < 0.5) {
            if (d3 == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return -Math.sqrt(this.df * (1.0 - d3) / d3);
        }
        if (d3 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(this.df * (1.0 - d3) / d3);
    }

    public double mean() {
        return this.df > 1.0 ? 0.0 : Double.NaN;
    }

    public double pdf(double d) {
        return Math.exp(Maths.logGamma(0.5 * (this.df + 1.0)) - Maths.logGamma(0.5 * this.df) - 0.5 * ((this.df + 1.0) * Math.log(1.0 + d * d / this.df) + LOGPI + Math.log(this.df)));
    }

    public double random() {
        return this.rand.nextGaussian() / Math.sqrt(this.chiSquared.random() / this.df);
    }

    public void setDf(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.df = d;
        this.chiSquared = new ChiSquared(d);
        this.chiSquared.setSeed(this.rand.nextLong() + 1L);
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
        this.chiSquared.setSeed(this.rand.nextLong() + 1L);
    }

    public static double tailProb(double d, double d2) {
        return Beta.incompleteBeta(d2 / (d2 + d * d), d2 / 2.0, 0.5, Maths.lnB(d2 / 2.0, 0.5)) / 2.0;
    }

    public String toString() {
        return new String("Student's t distribution: df = " + this.df + ".");
    }

    public double variance() {
        return this.df > 2.0 ? this.df / (this.df - 2.0) : Double.NaN;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            StudentsT studentsT = new StudentsT(10.0);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = studentsT.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, studentsT, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

