/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.Distribution;
import jsc.distributions.Normal;
import jsc.goodnessfit.ChiSquaredFitTest;

public class WilcoxonT
extends AbstractDiscreteDistribution {
    public static final int MAX_PRODUCT = 10000;
    static final double LOG2 = Math.log(2.0);
    private int n;
    private int n2;
    private double[] p;

    public WilcoxonT(int n) {
        super(0L, n * (n + 1) / 2);
        if (n < 1) {
            throw new IllegalArgumentException("Sample size too small.");
        }
        if (this.maxValue > 10000L) {
            throw new IllegalArgumentException("Cannot calculate exact distribution: try normal approximation.");
        }
        this.n = n;
        this.n2 = (int)Math.ceil(0.5 * (double)this.maxValue);
        this.p = new double[1 + this.n2];
        int n2 = 0;
        while (n2 <= this.n2) {
            this.p[n2] = Math.exp(Math.log(this.wcount(n, n2)) - (double)n * LOG2);
            ++n2;
        }
    }

    public long criticalValue(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        long l = this.minValue;
        double d2 = this.pdf(l);
        while (l < this.maxValue && d2 < d) {
            d2 += this.pdf(++l);
        }
        return --l;
    }

    public double mean() {
        return 0.25 * (double)this.n * ((double)this.n + 1.0);
    }

    public static Normal normalApproximation(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Sample size too small.");
        }
        double d = 0.25 * (double)n * ((double)n + 1.0);
        double d2 = Math.sqrt((double)n * ((double)n + 1.0) / 24.0 * ((double)(n + n) + 1.0));
        return new Normal(d, d2);
    }

    public double pdf(double d) {
        int n = (int)d;
        if ((long)n < this.minValue || (long)n > this.maxValue) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (n <= this.n2) {
            return this.p[n];
        }
        return this.p[(int)(this.maxValue - (long)n)];
    }

    private int wcount(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return 1;
            }
            return 0;
        }
        if (n2 < 0) {
            return 0;
        }
        return this.wcount(n - 1, n2) + this.wcount(n - 1, n2 - n);
    }

    public String toString() {
        return new String("Wilcoxon T distribution: n = " + this.n + ".");
    }

    public double variance() {
        return (double)this.n * ((double)this.n + 1.0) / 24.0 * ((double)(this.n + this.n) + 1.0);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            WilcoxonT wilcoxonT = new WilcoxonT(25);
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)wilcoxonT.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)wilcoxonT, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

