/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.datastructures.GroupedData;
import jsc.descriptive.MeanVar;
import jsc.distributions.FishersF;
import jsc.tests.SignificanceTest;

public class OneWayANOVA
implements SignificanceTest {
    private final int treatmentCount;
    private final int N;
    private final double F;
    private final double SP;
    private final double ess;
    private double rss;
    private final double tss;
    private final double ems;
    private final double rms;
    private final MeanVar[] mv;

    public OneWayANOVA(GroupedData groupedData) {
        this.treatmentCount = groupedData.getGroupCount();
        if (this.treatmentCount < 2) {
            throw new IllegalArgumentException("Less than two samples.");
        }
        this.N = groupedData.getN();
        this.mv = new MeanVar[this.treatmentCount];
        MeanVar meanVar = new MeanVar(groupedData.getData());
        double d = meanVar.getMean();
        this.tss = ((double)this.N - 1.0) * meanVar.getVariance();
        this.rss = 0.0;
        int n = 0;
        while (n < this.treatmentCount) {
            double[] dArray = groupedData.getData(n);
            this.mv[n] = new MeanVar(dArray);
            int n2 = 0;
            while (n2 < this.mv[n].getN()) {
                double d2 = dArray[n2] - this.mv[n].getMean();
                this.rss += d2 * d2;
                ++n2;
            }
            ++n;
        }
        this.ess = this.tss - this.rss;
        this.ems = this.ess / (double)(this.treatmentCount - 1);
        this.rms = this.rss / (double)(this.N - this.treatmentCount);
        this.F = this.ems / this.rms;
        this.SP = FishersF.upperTailProb(this.F, this.treatmentCount - 1, this.N - this.treatmentCount);
    }

    public int getTreatmentCount() {
        return this.treatmentCount;
    }

    public int getN() {
        return this.N;
    }

    public int getSize(int n) {
        return this.mv[n].getN();
    }

    public double getMean(int n) {
        return this.mv[n].getMean();
    }

    public double getSd(int n) {
        return this.mv[n].getSd();
    }

    public double getEss() {
        return this.ess;
    }

    public double getEms() {
        return this.ems;
    }

    public double getRss() {
        return this.rss;
    }

    public double getRms() {
        return this.rms;
    }

    public double getTss() {
        return this.tss;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.F;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"1", "1", "1", "1", "2", "2", "2", "2", "3", "3", "3", "3", "4", "4", "4", "4"};
            double[] dArray = new double[]{18.95, 12.62, 11.94, 14.42, 10.06, 7.19, 7.03, 14.66, 10.92, 13.28, 14.52, 12.51, 9.3, 21.2, 16.11, 21.41};
            GroupedData groupedData = new GroupedData(dArray, stringArray2);
            OneWayANOVA oneWayANOVA = new OneWayANOVA(groupedData);
            System.out.println(" ESS = " + oneWayANOVA.getEss() + " EMS = " + oneWayANOVA.getEms());
            System.out.println(" RSS = " + oneWayANOVA.getRss() + " RMS = " + oneWayANOVA.getRms());
            System.out.println(" TSS = " + oneWayANOVA.getTss());
            int n = 0;
            while (n < oneWayANOVA.getTreatmentCount()) {
                System.out.println(groupedData.getLabel(n) + "\tN = " + oneWayANOVA.getSize(n) + "\tMean = " + oneWayANOVA.getMean(n) + "\tsd = " + oneWayANOVA.getSd(n));
                ++n;
            }
            System.out.println("F = " + oneWayANOVA.getTestStatistic() + " SP = " + oneWayANOVA.getSP());
        }
    }
}

