/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import java.util.Arrays;
import jsc.distributions.Tail;
import jsc.independentsamples.TwoSampleTtest;
import jsc.tests.H1;
import jsc.tests.PermutationTest;
import jsc.tests.SignificanceTest;

public class PitmanTwoSampleTest
implements SignificanceTest {
    static final double PTOL = 0.001;
    private double cv;
    private double T;
    private double SP;
    private H1 alternative;

    public PitmanTwoSampleTest(double[] dArray, double[] dArray2, H1 h1) {
        double d;
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n + n2;
        this.alternative = h1;
        int[] nArray = new int[n3];
        if (jsc.util.Arrays.isIntegers(dArray) && jsc.util.Arrays.isIntegers(dArray2)) {
            int[] nArray2 = new int[n3];
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = (int)dArray[n4];
                nArray[n4] = 1;
                ++n4;
            }
            n4 = 0;
            while (n4 < n2) {
                nArray2[n4 + n] = (int)dArray2[n4];
                nArray[n4 + n] = 2;
                ++n4;
            }
            d = this.pitmanProbInt(nArray2, nArray, n3);
        } else {
            double[] dArray3 = new double[n3];
            int n5 = 0;
            while (n5 < n) {
                dArray3[n5] = dArray[n5];
                nArray[n5] = 1;
                ++n5;
            }
            n5 = 0;
            while (n5 < n2) {
                dArray3[n5 + n] = dArray2[n5];
                nArray[n5 + n] = 2;
                ++n5;
            }
            d = this.pitmanProb(dArray3, nArray, n3, 0.001);
        }
        this.SP = d;
    }

    public PitmanTwoSampleTest(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, H1.NOT_EQUAL);
    }

    private double pitmanProb(double[] dArray, int[] nArray, int n, double d) {
        double d2;
        double d3;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n5 = n;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n6 = 0;
        while (n6 < n) {
            if (n6 == 0) {
                d6 = dArray[n6];
                d7 = dArray[n6];
            } else {
                d6 = dArray[n6] > d6 ? d6 : dArray[n6];
                double d8 = d7 = dArray[n6] > d7 ? dArray[n6] : d7;
            }
            if (nArray[n6] == 1) {
                ++n2;
                d4 += dArray[n6];
            } else {
                ++n3;
                d5 += dArray[n6];
            }
            ++n6;
        }
        double d9 = d4 / (double)n2;
        double d10 = d5 / (double)n3;
        int n7 = d9 > d10 ? 2 : 1;
        n6 = 0;
        while (n6 < n) {
            int n8 = n6++;
            dArray[n8] = dArray[n8] - d6;
        }
        int n9 = n2 < n3 ? 1 : 2;
        d4 -= (double)n2 * d6;
        d5 -= (double)n3 * d6;
        d7 -= d6;
        if (n7 != n9) {
            n6 = 0;
            while (n6 < n) {
                dArray[n6] = d7 - dArray[n6];
                ++n6;
            }
            d4 = (double)n2 * d7 - d4;
            d5 = (double)n3 * d7 - d5;
        }
        this.T = d3 = n9 == 1 ? d4 : d5;
        int n10 = n2 < n3 ? n2 : n3;
        double d11 = n10;
        double d12 = n;
        double d13 = 0.0;
        double d14 = 0.0;
        n6 = 0;
        while (n6 < n) {
            d13 += dArray[n6];
            d14 += dArray[n6] * dArray[n6];
            int n11 = n6 + 1;
            while (n11 < n) {
                d14 -= 2.0 * dArray[n6] * dArray[n11] / (d12 - 1.0);
                ++n11;
            }
            ++n6;
        }
        d13 = d11 / d12 * d13;
        d14 = d11 / d12 * (1.0 - d11 / d12) * d14;
        double d15 = Math.sqrt(d11 / d12 * (1.0 - d11 / d12) * (d12 + (d13 - d3) * (d13 - d3) * (d12 + 1.0) / (d12 * d14)) / 12.0);
        double d16 = d13 * (d13 - d3) / (d * d14);
        double d17 = 2.0 / d;
        int n12 = (int)(d15 * (d16 > d17 ? d16 : d17));
        double d18 = (double)n12 / d3;
        n6 = 0;
        while (n6 < n) {
            nArray3[n6] = (int)(dArray[n6] * d18 + 0.5);
            if (nArray[n6] == n9) {
                n4 += nArray3[n6];
            }
            ++n6;
        }
        n12 = n4;
        n5 = (n12 + 2) * n10;
        double[] dArray2 = new double[n5];
        Arrays.sort(nArray3);
        n6 = 0;
        while (n6 < n) {
            nArray3[n6] = nArray3[n6] < n12 + 1 ? nArray3[n6] : n12 + 1;
            ++n6;
        }
        n6 = 0;
        while (n6 < n10) {
            nArray2[n6] = n6 * (n12 + 2);
            ++n6;
        }
        int n13 = nArray2[0] + nArray3[0];
        dArray2[n13] = dArray2[n13] + 1.0;
        int n14 = nArray3[0];
        int n15 = 1;
        while (n15 < n) {
            int n16 = n10 + n15 - n > 1 ? n10 + n15 - n : 1;
            int n17 = n14 + nArray3[n15];
            int n18 = n15 > n10 - 1 ? n10 - 1 : n15;
            while (n18 >= n16) {
                int n19;
                if (n17 > n12) {
                    n19 = n12 - nArray3[n15] + 1;
                    while (n19 <= n12 + 1) {
                        int n20 = nArray2[n18] + n12 + 1;
                        dArray2[n20] = dArray2[n20] + dArray2[nArray2[n18 - 1] + n19];
                        ++n19;
                    }
                }
                int n21 = n12 > n17 ? n17 : n12;
                n19 = nArray3[n15];
                while (n19 <= n21) {
                    int n22 = nArray2[n18] + n19;
                    dArray2[n22] = dArray2[n22] + dArray2[nArray2[n18 - 1] + n19 - nArray3[n15]];
                    ++n19;
                }
                --n18;
            }
            int n23 = nArray2[0] + nArray3[n15];
            dArray2[n23] = dArray2[n23] + 1.0;
            n14 = n17;
            ++n15;
        }
        double d19 = 0.0;
        nArray3 = null;
        if (this.alternative == H1.LESS_THAN && n7 == 1 || this.alternative == H1.GREATER_THAN && n7 == 2) {
            n6 = 0;
            while (n6 <= n12) {
                d19 += dArray2[nArray2[n10 - 1] + n6];
                ++n6;
            }
            d2 = d19 / (d19 + dArray2[nArray2[n10 - 1] + n12 + 1]);
        } else if (this.alternative == H1.NOT_EQUAL) {
            n6 = 0;
            while (n6 <= n12) {
                d19 += dArray2[nArray2[n10 - 1] + n6];
                ++n6;
            }
            d2 = 2.0 * d19 / (d19 + dArray2[nArray2[n10 - 1] + n12 + 1]);
        } else {
            n6 = 0;
            while (n6 < n12) {
                d19 += dArray2[nArray2[n10 - 1] + n6];
                ++n6;
            }
            d2 = 1.0 - d19 / (d19 + dArray2[nArray2[n10 - 1] + n12 + 1] + dArray2[nArray2[n10 - 1] + n12]);
        }
        this.cv = 100.0 * dArray2[nArray2[n10 - 1] + n12] * d15 / d19;
        return d2;
    }

    private double pitmanProbInt(int[] nArray, int[] nArray2, int n) {
        double d;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        int[] nArray3 = new int[n];
        int n9 = 0;
        while (n9 < n) {
            if (n9 == 0) {
                n2 = nArray[n9];
                n3 = nArray[n9];
            } else {
                n2 = nArray[n9] > n2 ? n2 : nArray[n9];
                int n10 = n3 = nArray[n9] > n3 ? nArray[n9] : n3;
            }
            if (nArray2[n9] == 1) {
                ++n4;
                n6 += nArray[n9];
            } else {
                ++n5;
                n7 += nArray[n9];
            }
            ++n9;
        }
        double d2 = n6 / n4;
        double d3 = n7 / n5;
        int n11 = d2 > d3 ? 2 : 1;
        n9 = 0;
        while (n9 < n) {
            int n12 = n9++;
            nArray[n12] = nArray[n12] - n2;
        }
        int n13 = n4 < n5 ? 1 : 2;
        n6 -= n4 * n2;
        n7 -= n5 * n2;
        n3 -= n2;
        if (n11 != n13) {
            n9 = 0;
            while (n9 < n) {
                nArray[n9] = n3 - nArray[n9];
                ++n9;
            }
            n6 = n4 * n3 - n6;
            n7 = n5 * n3 - n7;
        }
        int n14 = n13 == 1 ? n6 : n7;
        this.T = n14;
        int n15 = n4 < n5 ? n4 : n5;
        int n16 = n14;
        Arrays.sort(nArray);
        n9 = 0;
        while (n9 < n) {
            nArray[n9] = nArray[n9] < n16 + 1 ? nArray[n9] : n16 + 1;
            ++n9;
        }
        n8 = (n16 + 2) * n15;
        double[] dArray = new double[n8];
        n9 = 0;
        while (n9 < n15) {
            nArray3[n9] = n9 * (n16 + 2);
            ++n9;
        }
        int n17 = nArray3[0] + nArray[0];
        dArray[n17] = dArray[n17] + 1.0;
        int n18 = nArray[0];
        int n19 = 1;
        while (n19 < n) {
            int n20 = n15 + n19 - n > 1 ? n15 + n19 - n : 1;
            int n21 = n18 + nArray[n19];
            int n22 = n19 > n15 - 1 ? n15 - 1 : n19;
            while (n22 >= n20) {
                int n23;
                if (n21 > n16) {
                    n23 = n16 - nArray[n19] + 1;
                    while (n23 <= n16 + 1) {
                        int n24 = nArray3[n22] + n16 + 1;
                        dArray[n24] = dArray[n24] + dArray[nArray3[n22 - 1] + n23];
                        ++n23;
                    }
                }
                int n25 = n16 > n21 ? n21 : n16;
                n23 = nArray[n19];
                while (n23 <= n25) {
                    int n26 = nArray3[n22] + n23;
                    dArray[n26] = dArray[n26] + dArray[nArray3[n22 - 1] + n23 - nArray[n19]];
                    ++n23;
                }
                --n22;
            }
            int n27 = nArray3[0] + nArray[n19];
            dArray[n27] = dArray[n27] + 1.0;
            n18 = n21;
            ++n19;
        }
        double d4 = 0.0;
        d4 = 0.0;
        if (this.alternative == H1.LESS_THAN && n11 == 1 || this.alternative == H1.GREATER_THAN && n11 == 2) {
            n9 = 0;
            while (n9 <= n16) {
                d4 += dArray[nArray3[n15 - 1] + n9];
                ++n9;
            }
            d = d4 / (d4 + dArray[nArray3[n15 - 1] + n16 + 1]);
        } else if (this.alternative == H1.NOT_EQUAL) {
            n9 = 0;
            while (n9 <= n16) {
                d4 += dArray[nArray3[n15 - 1] + n9];
                ++n9;
            }
            d = 2.0 * d4 / (d4 + dArray[nArray3[n15 - 1] + n16 + 1]);
        } else {
            n9 = 0;
            while (n9 < n16) {
                d4 += dArray[nArray3[n15 - 1] + n9];
                ++n9;
            }
            d = 1.0 - d4 / (d4 + dArray[nArray3[n15 - 1] + n16 + 1] + dArray[nArray3[n15 - 1] + n16]);
        }
        return d;
    }

    public double getCV() {
        return this.cv;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.T;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{90.0, 72.0, 61.0, 66.0, 81.0, 69.0, 59.0, 70.0};
            double[] dArray2 = new double[]{62.0, 85.0, 78.0, 66.0, 80.0, 91.0, 69.0, 77.0, 84.0};
            H1[] h1Array = new H1[]{H1.LESS_THAN, H1.NOT_EQUAL, H1.GREATER_THAN};
            Tail[] tailArray = new Tail[]{Tail.LOWER, Tail.TWO, Tail.UPPER};
            int n = 0;
            while (n < 3) {
                PitmanTwoSampleTest pitmanTwoSampleTest = new PitmanTwoSampleTest(dArray2, dArray, h1Array[n]);
                System.out.println("     Pitman: SP = " + pitmanTwoSampleTest.getSP() + " T = " + pitmanTwoSampleTest.getTestStatistic() + " CV = " + pitmanTwoSampleTest.getCV());
                TwoSampleTtest twoSampleTtest = new TwoSampleTtest(dArray2, dArray, h1Array[n], true);
                PermutationTest permutationTest = new PermutationTest(twoSampleTtest, tailArray[n], false, 0, 0.0, null);
                System.out.println("Permutation: SP = " + permutationTest.getSP() + " tObs = " + permutationTest.getTestStatistic());
                System.out.println("     t-test: SP = " + twoSampleTtest.getSP() + " t = " + twoSampleTtest.getTestStatistic());
                ++n;
            }
        }
    }
}

