/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.event.StatisticListener;
import jsc.independentsamples.TwoSampleBootstrapTest;
import jsc.independentsamples.TwoSampleTtest;
import jsc.tests.H1;

public class TwoSampleBootstrapMeansTest
extends TwoSampleBootstrapTest {
    private double[] rA;
    private double[] rB;
    private final double[] zA;
    private final double[] zB;

    public TwoSampleBootstrapMeansTest(double[] dArray, double[] dArray2, int n) {
        this(dArray, dArray2, H1.NOT_EQUAL, n, null);
    }

    public TwoSampleBootstrapMeansTest(double[] dArray, double[] dArray2, H1 h1, int n, StatisticListener statisticListener) {
        super(new TwoSampleTtest(dArray, dArray2, h1, false), H1.toTail(h1), statisticListener);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < this.nA) {
            d += dArray[n2];
            d3 += dArray[n2];
            ++n2;
        }
        d /= (double)this.nA;
        n2 = 0;
        while (n2 < this.nB) {
            d2 += dArray2[n2];
            d3 += dArray2[n2];
            ++n2;
        }
        d2 /= (double)this.nB;
        d3 /= (double)this.N;
        this.rA = new double[this.nA];
        this.rB = new double[this.nB];
        this.zA = new double[this.nA];
        this.zB = new double[this.nB];
        n2 = 0;
        while (n2 < this.nA) {
            this.zA[n2] = dArray[n2] - d + d3;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nB) {
            this.zB[n2] = dArray2[n2] - d2 + d3;
            ++n2;
        }
        this.calculateSP(n);
    }

    protected double bootstrapSample() {
        int n = 0;
        while (n < this.nA) {
            this.rA[n] = this.zA[this.rand.nextInt(this.nA)];
            ++n;
        }
        n = 0;
        while (n < this.nB) {
            this.rB[n] = this.zB[this.rand.nextInt(this.nB)];
            ++n;
        }
        return this.t.resampleStatistic(this.rA, this.rB);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{94.0, 197.0, 16.0, 38.0, 99.0, 141.0, 23.0};
            double[] dArray2 = new double[]{52.0, 104.0, 146.0, 10.0, 50.0, 31.0, 40.0, 27.0, 46.0};
            H1 h1 = H1.NOT_EQUAL;
            TwoSampleTtest twoSampleTtest = new TwoSampleTtest(dArray, dArray2, h1, false);
            System.out.println("T = " + twoSampleTtest.getTestStatistic() + " SP = " + twoSampleTtest.getSP());
            long l = System.currentTimeMillis();
            TwoSampleBootstrapMeansTest twoSampleBootstrapMeansTest = new TwoSampleBootstrapMeansTest(dArray, dArray2, h1, 5000000, null);
            long l2 = System.currentTimeMillis();
            System.out.println("Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("Bootstrap SP = " + twoSampleBootstrapMeansTest.getSP());
        }
    }
}

