/*
 * Decompiled with CFR 0.152.
 */
package jsc.mathfunction;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Stack;
import java.util.Vector;
import jsc.mathfunction.CodeList;
import jsc.mathfunction.MathFunctionException;
import jsc.mathfunction.MathFunctionVariables;

public abstract class AbstractMathFunction {
    private static final int NUMBER = 6;
    private static final int OPTI_CONST = 7;
    private static final int DUMMYCODE = 8;
    private static final int END = 9;
    private static final int LABEL = -1;
    static final int VARIABLE = 0;
    public static final int UNARY_OP = 1;
    public static final int BINARY_OP = 2;
    public static final int CONSTANT = 3;
    private static final int OPEN_BRACKET = 4;
    private static final int CLOSE_BRACKET = 5;
    static final String AUG_MISS = "Missing operand or argument after ";
    static final String OP_MISS = "Missing operator or function";
    static final String OPEN_MISS = "Missing open bracket";
    static final String CLOSE_MISS = "Missing close bracket";
    static final String NOCODELIST = "Invalid function";
    static final String NOEXP = "Null expression";
    static final String CODE_ERROR = "Implementation error: unrecognized code";
    static final String TYPE_ERROR = "Implementation error: unrecognized code type";
    static final String VARIABLE_NAN = "Value of variable is not a number";
    private int nMax;
    CodeList codeList;
    private int nVarFound;
    private boolean[] var_flag;
    private long eval_count;
    private Stack cs = new Stack();
    private int count;
    private MathFunctionVariables clv;
    private String parsedExpression;
    protected DecimalFormat decimalFormat;
    protected DecimalFormat scientificFormat;

    public AbstractMathFunction(MathFunctionVariables mathFunctionVariables) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (!(numberFormat instanceof DecimalFormat)) {
            throw new IllegalArgumentException("DecimalFormat not available for locale.");
        }
        this.decimalFormat = (DecimalFormat)numberFormat;
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        this.scientificFormat = (DecimalFormat)numberFormat2;
        this.scientificFormat.applyPattern("#.#E0");
        this.var_flag = null;
        this.codeList = null;
        this.resetVariables(mathFunctionVariables);
        this.initialize();
    }

    public AbstractMathFunction() {
        this(null);
    }

    private void checkSubclass() throws MathFunctionException {
        int n = 0;
        while (n < this.getNumberOfTokens()) {
            if (this.getCode(n) < 10) {
                throw new MathFunctionException("Implementation error: code must be > 9");
            }
            char c = this.getToken(n).charAt(0);
            if (c == '.' || Character.isDigit(c)) {
                throw new MathFunctionException("Implementation error: token must not start with \".\" or a digit");
            }
            ++n;
        }
    }

    private void check_syntax(Vector vector) throws MathFunctionException {
        Code code = (Code)vector.firstElement();
        int n = code.type;
        int n2 = code.code;
        int n3 = 0;
        int n4 = 0;
        int n5 = vector.size();
        if (n == 2 || n == 1 && n5 == 1) {
            throw new MathFunctionException(AUG_MISS + this.getTokenFromCode(n2));
        }
        if (n == 5) {
            throw new MathFunctionException(OPEN_MISS);
        }
        if (n == 4) {
            ++n3;
        }
        int n6 = 1;
        while (n6 < n5) {
            code = (Code)vector.elementAt(n6);
            int n7 = code.type;
            boolean bl = n6 == n5 - 1;
            switch (n7) {
                case 4: {
                    ++n3;
                }
                case 1: {
                    if (bl) {
                        throw new MathFunctionException(AUG_MISS + this.getTokenFromCode(code.code));
                    }
                }
                case 0: 
                case 3: {
                    if (n != 3 && n != 0 && n != 5) break;
                    throw new MathFunctionException(OP_MISS);
                }
                case 2: {
                    if (bl) {
                        throw new MathFunctionException(AUG_MISS + this.getTokenFromCode(code.code));
                    }
                }
                case 5: {
                    if (n != 3 && n != 0 && n != 5) {
                        throw new MathFunctionException(AUG_MISS + this.getTokenFromCode(n2));
                    }
                    if (n7 == 5) {
                        ++n4;
                    }
                    if (n4 <= n3) break;
                    throw new MathFunctionException(OPEN_MISS);
                }
            }
            n = n7;
            n2 = code.code;
            ++n6;
        }
        if (n3 > n4) {
            throw new MathFunctionException(CLOSE_MISS);
        }
        if (n3 < n4) {
            throw new MathFunctionException(OPEN_MISS);
        }
        this.nMax = 1 + n5 - 2 * n3;
    }

    /*
     * Unable to fully structure code
     */
    private void code_list_parse(Vector var1_1) throws MathFunctionException {
        block11: {
            this.codeList = null;
            this.codeList = new CodeList(this.nMax);
            this.cs.clear();
            this.cs.push(new Code(8, 8));
            var2_2 = 0;
            while (var2_2 < var1_1.size()) {
                var3_3 = (Code)var1_1.elementAt(var2_2);
                switch (var3_3.type) {
                    case 0: {
                        this.out_to_code_list(var3_3);
                        break;
                    }
                    case 3: {
                        this.out_to_code_list(var3_3);
                        break;
                    }
                    case 2: {
                        while (this.precedence(((Code)this.cs.peek()).code) >= this.precedence(var3_3.code)) {
                            this.out_to_code_list((Code)this.cs.pop());
                        }
                        this.cs.push(new Code(CodeList.getLabelCode(this.codeList.size()), -1));
                        this.cs.push(var3_3);
                        break;
                    }
                    case 1: 
                    case 4: {
                        this.cs.push(var3_3);
                        break;
                    }
                    case 5: {
                        if (true) ** GOTO lbl33
                        do {
                            this.out_to_code_list(var4_4);
lbl33:
                            // 2 sources

                            var4_4 = (Code)this.cs.pop();
                        } while (var4_4.code != 4);
                        break;
                    }
                    default: {
                        throw new MathFunctionException("Implementation error: unrecognized code type");
                    }
                }
                ++var2_2;
            }
            break block11;
lbl41:
            // 1 sources

            while (true) {
                this.out_to_code_list(var3_3);
                break;
            }
        }
        var3_3 = (Code)this.cs.pop();
        ** while (var3_3.code != 8)
lbl46:
        // 1 sources

    }

    private void codify(String string, Vector vector) throws MathFunctionException {
        char c;
        this.count = 0;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('\u0000');
        String string2 = stringBuffer.toString();
        while ((c = string2.charAt(n)) != '\u0000') {
            String string3 = string2.substring(n);
            if (c == '.' || Character.isDigit(c)) {
                vector.add(new Code(6, 3, this.parse_number(string3)));
                n = n + this.count - 1;
            } else if (!Character.isWhitespace(c)) {
                Code code = this.pattern_match(string3, -1);
                vector.add(code);
                n = n + this.count - 1;
                if (code.type == 0) {
                    this.var_flag[code.code] = true;
                }
                if (this.isAmbiguous(code.code) && vector.size() > 1) {
                    Code code2 = (Code)vector.elementAt(vector.size() - 2);
                    if ((code2.type == 0 || code2.type == 3 || code2.type == 5) && code.type == 1) {
                        vector.removeElementAt(vector.size() - 1);
                        vector.add(this.pattern_match(string3, code.code));
                    }
                }
            }
            ++n;
        }
    }

    public double eval() throws MathFunctionException {
        if (this.codeList == null) {
            throw new MathFunctionException(NOCODELIST);
        }
        int n = 1;
        while (n <= this.codeList.size()) {
            int n2 = this.codeList.getCode(n);
            int n3 = this.codeList.getType(n);
            switch (n3) {
                case 3: {
                    break;
                }
                case 0: {
                    double d = this.clv.getVariableValue(n2);
                    if (Double.isNaN(d)) {
                        throw new MathFunctionException(VARIABLE_NAN);
                    }
                    this.codeList.setValue(d, n);
                    break;
                }
                case 1: {
                    this.codeList.setValue(this.unaryOperation(n2, this.codeList.getRightValue(n)), n);
                    break;
                }
                case 2: {
                    this.codeList.setValue(this.binaryOperation(n2, this.codeList.getLeftValue(n), this.codeList.getRightValue(n)), n);
                    break;
                }
                default: {
                    throw new MathFunctionException(TYPE_ERROR);
                }
            }
            ++n;
        }
        ++this.eval_count;
        return this.codeList.getValue();
    }

    public long getEvalCount() {
        return this.eval_count;
    }

    public String getLegalCharacters() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("0123456789.,-+E()");
        int n = 0;
        while (n < this.getNumberOfTokens()) {
            stringBuffer.append(this.getToken(n));
            ++n;
        }
        n = 0;
        while (n < this.clv.getNumberOfVariables()) {
            stringBuffer.append(this.clv.getVariableName(n));
            ++n;
        }
        Vector<Object> vector = new Vector<Object>();
        n = 0;
        while (n < stringBuffer.length()) {
            object = new Character(Character.toLowerCase(stringBuffer.charAt(n)));
            if (!vector.contains(object)) {
                vector.addElement(object);
            }
            ++n;
        }
        object = vector.toString();
        return object;
    }

    public int getNumberOfVariablesUsed() {
        return this.nVarFound;
    }

    public String getParsedExpression() {
        return this.parsedExpression;
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer("\nUnary operators:");
        int n = 0;
        while (n < this.getNumberOfTokens()) {
            if (this.getType(this.getCode(n)) == 1) {
                stringBuffer.append(" " + this.getToken(n));
            }
            ++n;
        }
        stringBuffer.append("\nBinary operators:");
        n = 0;
        while (n < this.getNumberOfTokens()) {
            if (this.getType(this.getCode(n)) == 2) {
                stringBuffer.append(" " + this.getToken(n));
            }
            ++n;
        }
        stringBuffer.append("\nImplicit binary operator: ");
        if (this.getImplicitCode() < 0) {
            stringBuffer.append("none");
        } else {
            stringBuffer.append(this.getTokenFromCode(this.getImplicitCode()));
        }
        stringBuffer.append("\nConstants:");
        n = 0;
        while (n < this.getNumberOfTokens()) {
            if (this.getType(this.getCode(n)) == 3) {
                stringBuffer.append(" " + this.getToken(n));
            }
            ++n;
        }
        stringBuffer.append("\nBrackets: ()");
        stringBuffer.append("\nVariables:");
        n = 0;
        while (n < this.clv.getNumberOfVariables()) {
            stringBuffer.append(" " + this.clv.getVariableName(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String getTokenFromCode(int n) {
        if (n == 4) {
            return "(";
        }
        if (n == 5) {
            return ")";
        }
        int n2 = 0;
        while (n2 < this.getNumberOfTokens()) {
            if (n == this.getCode(n2)) {
                return this.getToken(n2);
            }
            ++n2;
        }
        return null;
    }

    public boolean hasParsed() {
        return this.codeList != null;
    }

    private void initialize() {
        if (this.codeList != null) {
            this.codeList.setSize(0);
        }
        this.eval_count = 0L;
        this.nVarFound = 0;
        int n = 0;
        while (n < this.clv.getNumberOfVariables()) {
            this.var_flag[n] = false;
            ++n;
        }
    }

    private void insert(Vector vector) {
        Code code = (Code)vector.firstElement();
        int n = code.type;
        int n2 = 0;
        while (++n2 < vector.size()) {
            code = (Code)vector.elementAt(n2);
            int n3 = code.type;
            if (this.operand(n) && this.operand(n3) || this.operand(n) && n3 == 1 || this.operand(n) && n3 == 4 || n == 5 && n3 == 4 || n == 5 && this.operand(n3) || n == 5 && n3 == 1) {
                vector.insertElementAt(new Code(this.getImplicitCode(), 2), n2++);
            }
            n = n3;
        }
    }

    private boolean operand(int n) {
        return n == 3 || n == 0;
    }

    private void out_to_code_list(Code code) throws MathFunctionException {
        int n = this.codeList.incrementSize();
        switch (code.type) {
            case 0: {
                this.codeList.setType(code.type, n);
                this.codeList.setCode(code.code, n);
                break;
            }
            case 3: {
                this.codeList.setValue(code.constant, n);
                this.codeList.setType(code.type, n);
                this.codeList.setCode(code.code, n);
                break;
            }
            case 1: {
                if (this.codeList.getType(n - 1) == 3) {
                    this.codeList.setValue(this.unaryOperation(code.code, this.codeList.getValue(n - 1)), n - 1);
                    this.codeList.setCode(7, n);
                    this.codeList.setType(3, n);
                    n = this.codeList.decrementSize();
                    break;
                }
                this.codeList.setRight(CodeList.getLabelCode(n - 1), n);
                this.codeList.setCode(code.code, n);
                this.codeList.setType(code.type, n);
                break;
            }
            case 2: {
                int n2 = ((Code)this.cs.pop()).code;
                if (this.codeList.getLabelLine(n2) == n - 2 && this.codeList.getType(n - 2) == 3 && this.codeList.getType(n - 1) == 3) {
                    this.codeList.setValue(this.binaryOperation(code.code, this.codeList.getValue(n - 2), this.codeList.getValue(n - 1)), n - 2);
                    this.codeList.setCode(7, n);
                    this.codeList.setType(3, n);
                    this.codeList.decrementSize();
                    n = this.codeList.decrementSize();
                    break;
                }
                this.codeList.setLeft(n2, n);
                this.codeList.setRight(CodeList.getLabelCode(n - 1), n);
                this.codeList.setCode(code.code, n);
                this.codeList.setType(code.type, n);
                break;
            }
            default: {
                throw new MathFunctionException(TYPE_ERROR);
            }
        }
    }

    public double parse(String string) throws MathFunctionException {
        this.parsedExpression = string;
        int n = string.length();
        this.initialize();
        if (n < 1) {
            throw new MathFunctionException(NOEXP);
        }
        this.checkSubclass();
        Vector vector = new Vector(n);
        this.codify(string, vector);
        int n2 = 0;
        while (n2 < this.clv.getNumberOfVariables()) {
            if (this.var_flag[n2]) {
                ++this.nVarFound;
            }
            ++n2;
        }
        if (this.getImplicitCode() > 0) {
            this.insert(vector);
        }
        this.check_syntax(vector);
        this.code_list_parse(vector);
        if (this.getNumberOfVariablesUsed() > 0) {
            return Double.NaN;
        }
        return this.codeList.getValue();
    }

    private double parse_number(String string) throws MathFunctionException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.scientificFormat.parse(string, parsePosition);
        if (number == null) {
            parsePosition.setIndex(0);
            number = this.decimalFormat.parse(string, parsePosition);
            if (number == null) {
                throw new MathFunctionException("Error in number constant \"" + string.substring(0, parsePosition.getErrorIndex() + 1) + "\"");
            }
        }
        this.count = parsePosition.getIndex();
        return number.doubleValue();
    }

    private Code pattern_match(String string, int n) throws MathFunctionException {
        String string2;
        if (string.charAt(0) == '(') {
            this.count = 1;
            return new Code(4, 4);
        }
        if (string.charAt(0) == ')') {
            this.count = 1;
            return new Code(5, 5);
        }
        int n2 = 0;
        int n3 = string.length();
        n2 = 0;
        while (n2 < this.getNumberOfTokens()) {
            string2 = this.getToken(n2);
            this.count = string2.length();
            if (string.substring(0, Math.min(this.count, n3)).equalsIgnoreCase(string2)) {
                int n4 = this.getCode(n2);
                int n5 = this.getType(n4);
                if (n4 != n) {
                    return n5 == 3 ? new Code(n4, n5, this.getConstant(n4)) : new Code(n4, n5);
                }
            }
            ++n2;
        }
        n2 = this.clv.getNumberOfVariables() - 1;
        while (n2 >= 0) {
            string2 = this.clv.getVariableName(n2);
            this.count = string2.length();
            if (string.substring(0, Math.min(this.count, n3)).equalsIgnoreCase(string2)) {
                return new Code(n2, 0);
            }
            --n2;
        }
        this.count = 1;
        throw new MathFunctionException("Unrecognized sequence: " + string.substring(0, Math.min(4, string.length() - 1)) + "...");
    }

    private int precedence(int n) throws MathFunctionException {
        if (n == 8) {
            return 0;
        }
        if (n == 4 || n == 5) {
            return 1;
        }
        int n2 = 0;
        while (n2 < this.getNumberOfTokens()) {
            if (n == this.getCode(n2)) {
                int n3 = this.getPrecedence(n2);
                if (n3 < 2) {
                    throw new MathFunctionException("Implementation error: precedence must be > 1");
                }
                return n3;
            }
            ++n2;
        }
        throw new MathFunctionException(CODE_ERROR);
    }

    public void resetEvalCount() {
        this.eval_count = 0L;
    }

    public void resetVariables(MathFunctionVariables mathFunctionVariables) {
        this.clv = mathFunctionVariables == null ? new ConstantMathFunction() : mathFunctionVariables;
        int n = this.clv.getNumberOfVariables();
        this.var_flag = (boolean[])(n == 0 ? null : new boolean[n]);
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void setDecimalFormatPattern(String string) {
        this.decimalFormat.applyPattern(string);
    }

    public void setScientificFormat(DecimalFormat decimalFormat) {
        this.scientificFormat = decimalFormat;
    }

    public void setScientificFormatPattern(String string) {
        this.scientificFormat.applyPattern(string);
    }

    private String tokenToString(int n) {
        if (n < 0) {
            return "L" + this.codeList.getLabelLine(n);
        }
        return this.getTokenFromCode(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getSummary());
        stringBuffer.append("\n\nCode list");
        if (this.codeList.size() < 1) {
            stringBuffer.append(" empty");
        }
        int n = 1;
        while (n <= this.codeList.size()) {
            stringBuffer.append("\nL" + n + " ");
            int n2 = this.codeList.getCode(n);
            int n3 = this.codeList.getType(n);
            switch (n3) {
                case 2: {
                    stringBuffer.append(this.tokenToString(this.codeList.getLeft(n)) + " ");
                }
                case 1: {
                    stringBuffer.append(this.tokenToString(n2) + " ");
                    stringBuffer.append(this.tokenToString(this.codeList.getRight(n)));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.codeList.getValue(n));
                    break;
                }
                case 0: {
                    stringBuffer.append(this.clv.getVariableName(n2));
                    break;
                }
                default: {
                    stringBuffer.append("??");
                }
            }
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean variableUsed(int n) {
        return this.var_flag[n];
    }

    public boolean variableUsed(String string) {
        int n = 0;
        while (n < this.clv.getNumberOfVariables()) {
            if (this.var_flag[n] && string.equalsIgnoreCase(this.clv.getVariableName(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract double binaryOperation(int var1, double var2, double var4) throws MathFunctionException;

    public abstract int getCode(int var1);

    public abstract double getConstant(int var1);

    public abstract int getImplicitCode();

    public abstract int getNumberOfTokens();

    public abstract int getPrecedence(int var1);

    public abstract String getToken(int var1);

    public abstract int getType(int var1);

    public abstract boolean isAmbiguous(int var1);

    public abstract double unaryOperation(int var1, double var2) throws MathFunctionException;

    class ConstantMathFunction
    implements MathFunctionVariables {
        ConstantMathFunction() {
        }

        public int getNumberOfVariables() {
            return 0;
        }

        public String getVariableName(int n) {
            return "";
        }

        public double getVariableValue(int n) {
            return 0.0;
        }
    }

    private class Code {
        int code;
        int type;
        double constant;

        Code(int n, int n2) {
            this.code = n;
            this.type = n2;
            this.constant = Double.NaN;
        }

        Code(int n, int n2, double d) {
            this.code = n;
            this.type = n2;
            this.constant = d;
        }
    }
}

