/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import java.util.Arrays;
import jsc.datastructures.PairedData;
import jsc.distributions.Tail;
import jsc.onesample.PairedTtest;
import jsc.tests.H1;
import jsc.tests.PermutationTest;
import jsc.tests.SignificanceTest;

public class FisherSymmetryTest
implements SignificanceTest {
    static final double PTOL = 0.001;
    private boolean negsumSmaller;
    private double cv;
    private double T;
    private final double SP;
    private H1 alternative;

    public FisherSymmetryTest(double[] dArray, H1 h1) {
        this.alternative = h1;
        double d = jsc.util.Arrays.isIntegers(dArray) ? this.fisherProbInt(dArray) : this.fisherProb(dArray, 0.001);
        this.SP = h1 == H1.NOT_EQUAL ? d + d : (h1 == H1.LESS_THAN ? (this.negsumSmaller ? 1.0 - d : d) : (this.negsumSmaller ? d : 1.0 - d));
    }

    public FisherSymmetryTest(double[] dArray) {
        this(dArray, H1.NOT_EQUAL);
    }

    public FisherSymmetryTest(PairedData pairedData, H1 h1) {
        this(pairedData.differences(), h1);
    }

    public FisherSymmetryTest(PairedData pairedData) {
        this(pairedData, H1.NOT_EQUAL);
    }

    private double fisherProb(double[] dArray, double d) {
        double d2;
        int n;
        double d3;
        int n2 = dArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        long l = n2;
        int[] nArray = new int[n2];
        boolean[] blArray = new boolean[n2];
        int n7 = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        while (n7 < n2) {
            d7 += dArray[n7] * dArray[n7];
            if (dArray[n7] >= 0.0) {
                ++n3;
                d4 += dArray[n7];
                blArray[n7] = true;
            } else {
                ++n4;
                d5 -= dArray[n7];
                dArray[n7] = -dArray[n7];
                blArray[n7] = false;
            }
            ++n7;
        }
        d6 = (d4 + d5) / 2.0;
        d7 /= 4.0;
        if (d4 < d5) {
            d3 = d4;
            n = n3;
            this.negsumSmaller = false;
        } else {
            d3 = d5;
            n = n4;
            this.negsumSmaller = true;
        }
        double d8 = Math.sqrt(((double)n2 - (d6 - d3) * (d6 - d3) / d7) / 48.0);
        double d9 = d6 * (d6 - d3) / (d * d7);
        double d10 = 2.0 / d;
        int n8 = (int)(d8 * (d9 > d10 ? d9 : d10));
        int n9 = n3 < n4 ? n3 : n4;
        double d11 = n9 > 0 ? (double)n8 / d3 : 1.0;
        n7 = 0;
        while (n7 < n2) {
            nArray[n7] = (int)(dArray[n7] * d11 + 0.5);
            if (blArray[n7]) {
                n5 += nArray[n7];
            } else {
                n6 += nArray[n7];
            }
            ++n7;
        }
        n8 = n5 < n6 ? n5 : n6;
        l = n8 + 2;
        double[] dArray2 = new double[n8 + 2];
        Arrays.sort(nArray);
        n7 = 0;
        while (n7 < n2) {
            nArray[n7] = nArray[n7] < n8 + 1 ? nArray[n7] : n8 + 1;
            ++n7;
        }
        dArray2[0] = dArray2[0] + 1.0;
        int n10 = nArray[0];
        dArray2[n10] = dArray2[n10] + 1.0;
        int n11 = nArray[0];
        int n12 = 1;
        while (n12 < n2) {
            int n13;
            int n14;
            int n15 = n11 + nArray[n12];
            if (n15 > n8) {
                int n16 = n8 + 1;
                dArray2[n16] = dArray2[n16] * 2.0;
                n14 = n8;
                while (n14 >= n8 - nArray[n12] + 1) {
                    int n17 = n8 + 1;
                    dArray2[n17] = dArray2[n17] + dArray2[n14];
                    --n14;
                }
            }
            n14 = n13 = n8 > n15 ? n15 : n8;
            while (n14 >= nArray[n12]) {
                int n18 = n14;
                dArray2[n18] = dArray2[n18] + dArray2[n14 - nArray[n12]];
                --n14;
            }
            n11 = n15;
            ++n12;
        }
        double d12 = 0.0;
        if (this.alternative == H1.GREATER_THAN && !this.negsumSmaller || this.alternative == H1.LESS_THAN && this.negsumSmaller) {
            n7 = 0;
            while (n7 < n8) {
                d12 += dArray2[n7];
                ++n7;
            }
            d2 = d12 / (d12 + dArray2[n8 + 1] + dArray2[n8]);
        } else {
            n7 = 0;
            while (n7 <= n8) {
                d12 += dArray2[n7];
                ++n7;
            }
            d2 = d12 / (d12 + dArray2[n8 + 1]);
        }
        this.cv = 100.0 * dArray2[n8] * d8 / d12;
        dArray2 = null;
        nArray = null;
        blArray = null;
        this.T = d3;
        return d2;
    }

    private double fisherProbInt(double[] dArray) {
        double d;
        int n;
        int n2 = dArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (dArray[n5] >= 0.0) {
                n3 = (int)((double)n3 + dArray[n5]);
            } else {
                n4 = (int)((double)n4 - dArray[n5]);
                dArray[n5] = -dArray[n5];
            }
            ++n5;
        }
        if (n3 < n4) {
            n = n3;
            this.negsumSmaller = false;
        } else {
            n = n4;
            this.negsumSmaller = true;
        }
        int n6 = n;
        long l = n6 + 2;
        double[] dArray2 = new double[n6 + 2];
        Arrays.sort(dArray);
        n5 = 0;
        while (n5 < n2) {
            dArray[n5] = dArray[n5] < (double)(n6 + 1) ? dArray[n5] : (double)(n6 + 1);
            ++n5;
        }
        n5 = 0;
        while (n5 <= n6 + 1) {
            dArray2[n5] = 0.0;
            ++n5;
        }
        dArray2[0] = dArray2[0] + 1.0;
        int n7 = (int)dArray[0];
        dArray2[n7] = dArray2[n7] + 1.0;
        int n8 = (int)dArray[0];
        int n9 = 1;
        while (n9 < n2) {
            int n10;
            int n11;
            int n12 = (int)((double)n8 + dArray[n9]);
            if (n12 > n6) {
                dArray2[n6 + 1] = 2.0 * dArray2[n6 + 1];
                n11 = n6;
                while ((double)n11 >= (double)n6 - dArray[n9] + 1.0) {
                    int n13 = n6 + 1;
                    dArray2[n13] = dArray2[n13] + dArray2[n11];
                    --n11;
                }
            }
            n11 = n10 = n6 > n12 ? n12 : n6;
            while ((double)n11 >= dArray[n9]) {
                int n14 = n11;
                dArray2[n14] = dArray2[n14] + dArray2[n11 - (int)dArray[n9]];
                --n11;
            }
            n8 = n12;
            ++n9;
        }
        double d2 = 0.0;
        if (this.alternative == H1.GREATER_THAN && !this.negsumSmaller || this.alternative == H1.LESS_THAN && this.negsumSmaller) {
            n5 = 0;
            while (n5 < n6) {
                d2 += dArray2[n5];
                ++n5;
            }
            d = d2 / (d2 + dArray2[n6 + 1] + dArray2[n6]);
        } else {
            n5 = 0;
            while (n5 <= n6) {
                d2 += dArray2[n5];
                ++n5;
            }
            d = d2 / (d2 + dArray2[n6 + 1]);
        }
        dArray2 = null;
        this.T = n;
        return d;
    }

    public double getCV() {
        return this.cv;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.T;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{-8.0, -7.0, -6.0, -5.0, -5.0, -5.0, -5.0, -4.0, -4.0, -4.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0};
            FisherSymmetryTest fisherSymmetryTest = new FisherSymmetryTest(dArray, H1.LESS_THAN);
            System.out.println("Fisher symm: SP = " + fisherSymmetryTest.getSP() + " T = " + fisherSymmetryTest.getTestStatistic() + " CV = " + fisherSymmetryTest.getCV());
            double[] dArray2 = new double[]{70.0, 80.0, 62.0, 50.0, 70.0, 30.0, 49.0, 60.0};
            double[] dArray3 = new double[]{75.0, 82.0, 65.0, 58.0, 68.0, 41.0, 55.0, 67.0};
            PairedData pairedData = new PairedData(dArray2, dArray3);
            H1[] h1Array = new H1[]{H1.LESS_THAN, H1.NOT_EQUAL, H1.GREATER_THAN};
            Tail[] tailArray = new Tail[]{Tail.LOWER, Tail.TWO, Tail.UPPER};
            int n = 0;
            while (n < 3) {
                fisherSymmetryTest = new FisherSymmetryTest(pairedData, h1Array[n]);
                System.out.println("Fisher symm: SP = " + fisherSymmetryTest.getSP() + " T = " + fisherSymmetryTest.getTestStatistic() + " CV = " + fisherSymmetryTest.getCV());
                PairedTtest pairedTtest = new PairedTtest(pairedData, h1Array[n]);
                PermutationTest permutationTest = new PermutationTest(pairedTtest, tailArray[n], false, 0, 0.0, null);
                System.out.println("Permutation: SP = " + permutationTest.getSP() + " tObs = " + permutationTest.getTestStatistic());
                System.out.println("   Paired t: SP = " + pairedTtest.getSP() + " t = " + pairedTtest.getTestStatistic());
                ++n;
            }
        }
    }
}

