/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.datastructures.PairedData;
import jsc.distributions.Normal;
import jsc.distributions.Poisson;
import jsc.onesample.FisherSymmetryTest;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;
import jsc.util.Rank;

public class WilcoxonTest
implements SignificanceTest {
    static final int SMALL_SAMPLE_SIZE = 499;
    static final double LOG2 = Math.log(2.0);
    final H1 alternative;
    int n1;
    private final double T;
    private double s2Sum;
    private final double SP;
    private double[] signedRanks;

    public WilcoxonTest(double[] dArray, double d, H1 h1, double d2, boolean bl, boolean bl2) {
        this.alternative = h1;
        int n = dArray.length;
        double d3 = 0.0;
        double d4 = 0.0;
        this.n1 = 0;
        int[] nArray = new int[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d5 = dArray[n2] - d;
            if (bl || !(Math.abs(d5) <= d2)) {
                dArray2[this.n1] = Math.abs(d5);
                nArray[this.n1] = d5 >= 0.0 ? 1 : -1;
                ++this.n1;
            }
            ++n2;
        }
        if (this.n1 < 1) {
            throw new IllegalArgumentException("No non-zero differences.");
        }
        Rank rank = new Rank(this.n1, dArray2, d2);
        this.signedRanks = new double[this.n1];
        this.s2Sum = 0.0;
        n2 = 0;
        while (n2 < this.n1) {
            double d6 = rank.getRank(n2);
            this.s2Sum += d6 * d6;
            if (nArray[n2] > 0) {
                d3 += d6;
                this.signedRanks[n2] = d6;
            } else {
                d4 += d6;
                this.signedRanks[n2] = -d6;
            }
            ++n2;
        }
        this.T = h1 == H1.LESS_THAN ? d3 : (h1 == H1.GREATER_THAN ? d4 : Math.min(d3, d4));
        this.SP = bl2 ? this.approxSP() : this.exactSP();
    }

    public WilcoxonTest(double[] dArray, double d, H1 h1, boolean bl) {
        this(dArray, d, h1, 0.0, bl, dArray.length > 499);
    }

    public WilcoxonTest(double[] dArray, double d, H1 h1) {
        this(dArray, d, h1, 0.0, false, dArray.length > 499);
    }

    public WilcoxonTest(double[] dArray, double d) {
        this(dArray, d, H1.NOT_EQUAL, 0.0, false, dArray.length > 499);
    }

    public WilcoxonTest(PairedData pairedData, H1 h1, double d, boolean bl, boolean bl2) {
        this(pairedData.differences(), 0.0, h1, d, bl, bl2);
    }

    public WilcoxonTest(PairedData pairedData, H1 h1, boolean bl) {
        this(pairedData.differences(), 0.0, h1, 0.0, bl, pairedData.getN() > 24);
    }

    public WilcoxonTest(PairedData pairedData, H1 h1) {
        this(pairedData.differences(), 0.0, h1, 0.0, false, pairedData.getN() > 24);
    }

    public WilcoxonTest(PairedData pairedData) {
        this(pairedData.differences(), 0.0, H1.NOT_EQUAL, 0.0, false, pairedData.getN() > 24);
    }

    public double approxSP() {
        double d = this.getZ();
        if (this.alternative == H1.NOT_EQUAL) {
            return 2.0 * Normal.standardTailProb(d, d > 0.0);
        }
        return Normal.standardTailProb(d, false);
    }

    public double exactSP() {
        FisherSymmetryTest fisherSymmetryTest = new FisherSymmetryTest(this.signedRanks, this.alternative);
        return fisherSymmetryTest.getSP();
    }

    public int getN() {
        return this.n1;
    }

    public double[] getSignedRanks() {
        return this.signedRanks;
    }

    public double getSP() {
        return this.SP;
    }

    public double getTestStatistic() {
        return this.T;
    }

    public double getZ() {
        double d;
        double d2 = (d - ((d = this.T - 0.25 * (double)this.n1 * ((double)this.n1 + 1.0)) < 0.0 ? -0.5 : 0.5)) / Math.sqrt(0.25 * this.s2Sum);
        return d2;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 500;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            Poisson poisson = new Poisson(1.0);
            poisson.setSeed(100L);
            Poisson poisson2 = new Poisson(1.5);
            poisson2.setSeed(200L);
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = poisson.random();
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                dArray2[n2] = poisson2.random();
                ++n2;
            }
            PairedData pairedData = new PairedData(dArray, dArray2);
            WilcoxonTest wilcoxonTest = new WilcoxonTest(pairedData, H1.NOT_EQUAL, 0.0, false, false);
            System.out.println("T = " + wilcoxonTest.getTestStatistic() + " SP = " + wilcoxonTest.getSP() + " Approx SP=" + wilcoxonTest.approxSP());
            double[] dArray3 = new double[]{-2.0, 0.0, 0.0, 1.0, 0.0, 0.0, 4.0, 4.0, 1.0, 1.0, 5.0, 3.0, 5.0, 3.0, -1.0, 1.0, -1.0, 5.0, 8.0, 2.0, 2.0, 2.0, -3.0, -2.0, 1.0, 4.0, 8.0, 2.0, 3.0, -1.0};
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = false;
            boolean bl2 = false;
            System.out.println("Normal approx: " + bl);
            System.out.println("Include zeros: " + bl2);
            wilcoxonTest = new WilcoxonTest(dArray3, d, H1.NOT_EQUAL, d2, bl2, bl);
            System.out.println("H1:m <> " + d + " N=" + wilcoxonTest.getN() + " T=" + wilcoxonTest.getTestStatistic() + " SP=" + wilcoxonTest.getSP());
            wilcoxonTest = new WilcoxonTest(dArray3, d, H1.LESS_THAN, d2, bl2, bl);
            System.out.println("H1:m < " + d + " N=" + wilcoxonTest.getN() + " T=" + wilcoxonTest.getTestStatistic() + " SP=" + wilcoxonTest.getSP());
            wilcoxonTest = new WilcoxonTest(dArray3, d, H1.GREATER_THAN, d2, bl2, bl);
            System.out.println("H1:m > " + d + " N=" + wilcoxonTest.getN() + " T=" + wilcoxonTest.getTestStatistic() + " SP=" + wilcoxonTest.getSP());
            double[] dArray4 = new double[]{70.0, 80.0, 62.0, 50.0, 70.0, 30.0, 49.0, 60.0};
            double[] dArray5 = new double[]{75.0, 82.0, 65.0, 58.0, 68.0, 41.0, 55.0, 67.0};
            pairedData = new PairedData(dArray4, dArray5);
            wilcoxonTest = new WilcoxonTest(pairedData, H1.NOT_EQUAL, 0.0, false, false);
            System.out.println("H1: averages not equal: T = " + wilcoxonTest.getTestStatistic() + " SP = " + wilcoxonTest.getSP());
            wilcoxonTest = new WilcoxonTest(pairedData, H1.LESS_THAN);
            System.out.println("H1: average A < average B: T = " + wilcoxonTest.getTestStatistic() + " SP = " + wilcoxonTest.getSP());
            wilcoxonTest = new WilcoxonTest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: average A > average B: T = " + wilcoxonTest.getTestStatistic() + " SP = " + wilcoxonTest.getSP());
            double[] dArray6 = new double[]{17.4, 15.7, 12.9, 9.8, 13.4, 18.7, 13.9, 11.0, 5.4, 10.4, 16.4, 5.6};
            double[] dArray7 = new double[]{13.6, 10.1, 10.3, 9.2, 11.1, 20.4, 10.4, 11.4, 4.9, 8.9, 11.2, 4.8};
            pairedData = new PairedData(dArray6, dArray7);
            wilcoxonTest = new WilcoxonTest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: average A > average B: T = " + wilcoxonTest.getTestStatistic() + " SP = " + wilcoxonTest.getSP());
            double[] dArray8 = new double[]{20.1, 19.5, 19.0, 21.1, 23.1, 22.6, 18.9, 22.8, 27.1, 19.8, 21.7, 18.9, 20.4};
            double[] dArray9 = new double[]{21.2, 18.7, 19.0, 20.8, 19.9, 21.4, 17.9, 23.1, 24.3, 18.5, 20.3, 18.7, 19.4};
            pairedData = new PairedData(dArray8, dArray9);
            wilcoxonTest = new WilcoxonTest(pairedData, H1.GREATER_THAN);
            System.out.println("H1: average A > average B: T = " + wilcoxonTest.getTestStatistic() + " SP = " + wilcoxonTest.getSP());
            double[] dArray10 = new double[]{82.0, 69.0, 73.0, 43.0, 58.0, 56.0, 76.0, 65.0};
            double[] dArray11 = new double[]{63.0, 42.0, 74.0, 37.0, 51.0, 43.0, 80.0, 62.0};
            pairedData = new PairedData(dArray10, dArray11);
            wilcoxonTest = new WilcoxonTest(pairedData, H1.NOT_EQUAL, 0.0, false, false);
            System.out.println("H1:A <> B: T=" + wilcoxonTest.getTestStatistic() + " z=" + wilcoxonTest.getZ() + " SP=" + wilcoxonTest.getSP());
        }
    }
}

