/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.awt.Color;
import java.awt.Toolkit;
import java.text.ParseException;
import javax.swing.JTextField;
import jsc.swt.text.IntegerFormat;
import jsc.swt.text.MaxWidthFormat;
import jsc.swt.text.RealFormat;

public class DisplayField
extends JTextField {
    private RealFormat realFormatter;
    private IntegerFormat integerFormatter;
    private Toolkit toolkit;

    public DisplayField(String string, int n) {
        this(string, n, new MaxWidthFormat(7));
    }

    public DisplayField(String string, int n, RealFormat realFormat) {
        this(string, n, new IntegerFormat(), realFormat);
    }

    public DisplayField(String string, int n, IntegerFormat integerFormat, RealFormat realFormat) {
        super(string, n);
        this.setEditable(false);
        this.setBackground(Color.white);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = integerFormat;
        this.realFormatter = realFormat;
    }

    public int getIntegerValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return n;
    }

    public double getRealValue() {
        double d = 0.0;
        try {
            d = this.realFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return d;
    }

    public boolean isFocusable() {
        return false;
    }

    public void setGroupingSeparator(char c) {
        this.integerFormatter.setGroupingSeparator(c);
        this.realFormatter.setGroupingSeparator(c);
    }

    public void setGroupingUsed(boolean bl) {
        this.integerFormatter.setGroupingUsed(bl);
        this.realFormatter.setGroupingUsed(bl);
    }

    public void setIntegerFormat(IntegerFormat integerFormat) {
        this.integerFormatter = integerFormat;
    }

    public void setIntegerValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    public void setRealFormat(RealFormat realFormat) {
        this.realFormatter = realFormat;
    }

    public void setRealValue(double d) {
        this.setText(this.realFormatter.format(d));
    }
}

