/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DataMatrix
implements Serializable {
    int columnCount;
    int rowCount;
    Class defaultClass;
    String defaultNamePrefix;
    Vector columnClasses;
    Vector columnData;
    Vector columnNames;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public DataMatrix(int n, int n2, String string, Class clazz) {
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException("Invalid data matrix");
        }
        this.rowCount = n;
        this.columnCount = n2;
        this.defaultNamePrefix = string;
        this.defaultClass = clazz;
        this.columnNames = new Vector(n2);
        this.columnClasses = new Vector(n2);
        this.columnData = new Vector(n2);
        int n3 = 1;
        while (n3 <= n2) {
            this.columnNames.addElement(string + n3);
            this.columnClasses.addElement(clazz);
            Vector<Object> vector = new Vector<Object>(n);
            this.columnData.addElement(vector);
            int n4 = 0;
            while (n4 < n) {
                vector.addElement(null);
                ++n4;
            }
            ++n3;
        }
    }

    public DataMatrix(int n, int n2) {
        this(n, n2, "", class$java$lang$Double == null ? (class$java$lang$Double = DataMatrix.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public DataMatrix(String string, boolean bl, String string2, String string3, String string4) {
        this(0, 1, string4, class$java$lang$String == null ? (class$java$lang$String = DataMatrix.class$("java.lang.String")) : class$java$lang$String);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), string3);
            int n4 = stringTokenizer2.countTokens();
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        int n5 = 2;
        while (n5 <= n2) {
            this.addColumn();
            ++n5;
        }
        stringTokenizer = new StringTokenizer(string, string2);
        int n6 = 0;
        n3 = 0;
        while (n3 < n) {
            String string5;
            StringTokenizer stringTokenizer3 = new StringTokenizer(stringTokenizer.nextToken(), string3);
            int n7 = stringTokenizer3.countTokens();
            if (n3 == 0 && bl) {
                n6 = 1;
                n5 = 0;
                while (n5 < n7) {
                    string5 = stringTokenizer3.nextToken();
                    this.setColumnName(n5, string5);
                    ++n5;
                }
            } else {
                this.addRow();
                n5 = 0;
                while (n5 < n7) {
                    string5 = stringTokenizer3.nextToken();
                    this.setValueAt(string5, n3 - n6, n5);
                    ++n5;
                }
            }
            ++n3;
        }
        n5 = 0;
        while (n5 < this.columnCount) {
            if (this.isColumnDataInteger(n5)) {
                this.convertStringToInteger(n5);
                this.setColumnClass(n5, class$java$lang$Integer == null ? DataMatrix.class$("java.lang.Integer") : class$java$lang$Integer);
            } else if (this.isColumnDataDouble(n5)) {
                this.convertStringToDouble(n5);
                this.setColumnClass(n5, class$java$lang$Double == null ? DataMatrix.class$("java.lang.Double") : class$java$lang$Double);
            }
            ++n5;
        }
    }

    public int addColumn() {
        ++this.columnCount;
        this.columnNames.addElement(this.defaultNamePrefix + this.columnCount);
        this.columnClasses.addElement(this.defaultClass);
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        this.columnData.addElement(vector);
        int n = 0;
        while (n < this.rowCount) {
            vector.addElement(null);
            ++n;
        }
        return this.columnCount - 1;
    }

    public void addRow() {
        ++this.rowCount;
        int n = 0;
        while (n < this.columnCount) {
            Vector vector = (Vector)this.columnData.elementAt(n);
            vector.addElement(null);
            ++n;
        }
    }

    private void convertDoubleToInteger(int n) {
        Vector vector = (Vector)this.columnData.elementAt(n);
        int n2 = 0;
        while (n2 < this.rowCount) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                Double d = (Double)e;
                int n3 = d.intValue();
                if (n3 < 0) {
                    n3 = 0;
                }
                vector.setElementAt(new Integer(n3), n2);
            }
            ++n2;
        }
    }

    private void convertStringToDouble(int n) {
        Vector vector = (Vector)this.columnData.elementAt(n);
        int n2 = 0;
        while (n2 < this.rowCount) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                String string = e.toString();
                try {
                    vector.setElementAt(new Double(string), n2);
                }
                catch (Exception exception) {
                    vector.setElementAt(new Double(0.0), n2);
                }
            }
            ++n2;
        }
    }

    private void convertStringToInteger(int n) {
        this.convertStringToDouble(n);
        this.convertDoubleToInteger(n);
    }

    public void copyColumn(int n, int n2) {
        this.setColumnName(n2, this.getColumnName(n));
        this.setColumnClass(n2, this.getColumnClass(n));
        Vector vector = (Vector)this.columnData.elementAt(n);
        Vector vector2 = (Vector)this.columnData.elementAt(n2);
        int n3 = 0;
        while (n3 < this.rowCount) {
            vector2.setElementAt(vector.elementAt(n3), n3);
            ++n3;
        }
    }

    public void copyRow(int n, int n2) {
        int n3 = 0;
        while (n3 < this.columnCount) {
            Vector vector = (Vector)this.columnData.elementAt(n3);
            vector.setElementAt(vector.elementAt(n), n2);
            ++n3;
        }
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnClasses.elementAt(n);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Vector getColumnData(int n) {
        return (Vector)this.columnData.elementAt(n);
    }

    public String getColumnName(int n) {
        return (String)this.columnNames.elementAt(n);
    }

    public Vector getColumnNames(boolean bl, boolean bl2, boolean bl3, int n) {
        Vector<String> vector = new Vector<String>(this.columnCount);
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.getColumnValueCount(n2) >= n) {
                Class clazz = this.getColumnClass(n2);
                if (bl && clazz == (class$java$lang$Double == null ? DataMatrix.class$("java.lang.Double") : class$java$lang$Double) || bl2 && clazz == (class$java$lang$Integer == null ? DataMatrix.class$("java.lang.Integer") : class$java$lang$Integer) || bl3 && clazz == (class$java$lang$String == null ? DataMatrix.class$("java.lang.String") : class$java$lang$String)) {
                    vector.addElement(this.getColumnName(n2));
                }
            }
            ++n2;
        }
        return vector;
    }

    public int getColumnValueCount(int n) {
        Vector vector = (Vector)this.columnData.elementAt(n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rowCount) {
            if (vector.elementAt(n3) != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public Class getDefaultColumnClass() {
        return this.defaultClass;
    }

    public String getDefaultNamePrefix() {
        return this.defaultNamePrefix;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.columnData.elementAt(n2);
        return vector.elementAt(n);
    }

    public void insertColumn(int n) {
        ++this.columnCount;
        if (n > this.columnNames.size()) {
            n = this.columnNames.size();
        }
        this.columnNames.insertElementAt(this.defaultNamePrefix + this.columnCount, n);
        this.columnClasses.insertElementAt(this.defaultClass, n);
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        this.columnData.insertElementAt(vector, n);
        int n2 = 0;
        while (n2 < this.rowCount) {
            vector.addElement(null);
            ++n2;
        }
    }

    public void insertRow(int n) {
        ++this.rowCount;
        int n2 = 0;
        while (n2 < this.columnCount) {
            Vector vector = (Vector)this.columnData.elementAt(n2);
            vector.insertElementAt(null, n);
            ++n2;
        }
    }

    public void insertValue(Object object, int n, int n2) {
        Vector vector = (Vector)this.columnData.elementAt(n2);
        vector.insertElementAt(object, n);
        vector.removeElementAt(vector.size() - 1);
    }

    public boolean isColumnDataDouble(int n) {
        Vector vector = (Vector)this.columnData.elementAt(n);
        int n2 = 0;
        while (n2 < this.rowCount) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                String string = e.toString();
                try {
                    Double d = new Double(string);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean isColumnDataInteger(int n) {
        Vector vector = (Vector)this.columnData.elementAt(n);
        int n2 = 0;
        while (n2 < this.rowCount) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                String string = e.toString();
                try {
                    Integer n3 = new Integer(string);
                    if (n3 < 0) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public void removeCell(int n, int n2) {
        Vector vector = (Vector)this.columnData.elementAt(n2);
        vector.removeElementAt(n);
        vector.addElement(null);
    }

    public void removeColumn(int n) {
        --this.columnCount;
        this.columnNames.removeElementAt(n);
        this.columnClasses.removeElementAt(n);
        this.columnData.removeElementAt(n);
    }

    public void removeColumn(String string) {
        int n = this.columnNames.indexOf(string);
        this.removeColumn(n);
    }

    public void removeRow(int n) {
        --this.rowCount;
        int n2 = 0;
        while (n2 < this.columnCount) {
            Vector vector = (Vector)this.columnData.elementAt(n2);
            vector.removeElementAt(n);
            ++n2;
        }
    }

    public void setColumnClass(int n, Class clazz) {
        this.columnClasses.setElementAt(clazz, n);
    }

    public void setColumnName(int n, String string) {
        this.columnNames.setElementAt(string, n);
    }

    public void setDefaultColumnClass(Class clazz) {
        this.defaultClass = clazz;
    }

    public void setValueAt(Object object, int n, int n2) {
        Vector vector = (Vector)this.columnData.elementAt(n2);
        vector.setElementAt(object, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

