/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jsc.swt.datatable.DataMatrix;

public class DataModel
extends AbstractTableModel {
    boolean editable = true;
    boolean changed = false;
    DataMatrix dataMatrix;

    public DataModel(DataMatrix dataMatrix) {
        this.dataMatrix = dataMatrix;
        this.addTableModelListener(new DataChangeListener());
    }

    public int addColumn() {
        int n = this.dataMatrix.addColumn();
        this.fireTableStructureChanged();
        return n;
    }

    public void addRow() {
        this.dataMatrix.addRow();
        this.fireTableDataChanged();
    }

    public void copyColumn(int n, int n2) {
        this.dataMatrix.copyColumn(n, n2);
    }

    public void copyRow(int n, int n2) {
        this.dataMatrix.copyRow(n, n2);
    }

    public Class getColumnClass(int n) {
        return this.dataMatrix.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.dataMatrix.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.dataMatrix.getColumnName(n);
    }

    public Vector getColumnNames(boolean bl, boolean bl2, boolean bl3, int n) {
        return this.dataMatrix.getColumnNames(bl, bl2, bl3, n);
    }

    public Class getDefaultColumnClass() {
        return this.dataMatrix.getDefaultColumnClass();
    }

    public String getDefaultNamePrefix() {
        return this.dataMatrix.getDefaultNamePrefix();
    }

    public int getRowCount() {
        return this.dataMatrix.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        return this.dataMatrix.getValueAt(n, n2);
    }

    public void insertColumn(int n) {
        this.dataMatrix.insertColumn(n);
        this.fireTableStructureChanged();
    }

    public int insertRow(int n) {
        this.dataMatrix.insertRow(n);
        this.fireTableDataChanged();
        return n;
    }

    public void insertValue(Object object, int n, int n2) {
        this.dataMatrix.insertValue(object, n, n2);
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return this.editable;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isColumnDataDouble(int n) {
        return this.dataMatrix.isColumnDataDouble(n);
    }

    public boolean isColumnDataInteger(int n) {
        return this.dataMatrix.isColumnDataInteger(n);
    }

    public void removeCell(int n, int n2) {
        this.dataMatrix.removeCell(n, n2);
    }

    public void removeColumn(int n) {
        this.dataMatrix.removeColumn(n);
        this.fireTableStructureChanged();
    }

    public void removeColumn(String string) {
        this.dataMatrix.removeColumn(string);
        this.fireTableStructureChanged();
    }

    public void removeRow(int n) {
        this.dataMatrix.removeRow(n);
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void setColumnClass(int n, Class clazz) {
        this.dataMatrix.setColumnClass(n, clazz);
        this.fireTableDataChanged();
    }

    public void setColumnName(int n, String string) {
        this.dataMatrix.setColumnName(n, string);
        this.fireTableStructureChanged();
    }

    public void setDefaultColumnClass(Class clazz) {
        this.dataMatrix.setDefaultColumnClass(clazz);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.dataMatrix.setValueAt(object, n, n2);
        this.fireTableCellUpdated(n, n2);
    }

    public void swapRow(int n, int n2) {
        this.dataMatrix.copyRow(n, this.getRowCount() - 1);
        this.dataMatrix.copyRow(n2, n);
        this.dataMatrix.copyRow(this.getRowCount() - 1, n2);
    }

    public void trimTableRows(int n) {
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        int n4 = n2 - 1;
        while (n4 >= n2 - n) {
            int n5 = 0;
            while (n5 < n3) {
                if (this.getValueAt(n4, n5) != null) {
                    return;
                }
                ++n5;
            }
            this.removeRow(n4);
            --n4;
        }
    }

    class DataChangeListener
    implements TableModelListener {
        DataChangeListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            DataModel.this.changed = true;
        }
    }
}

