/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import jsc.Utilities;
import jsc.mathfunction.MathFunctionException;
import jsc.mathfunction.StatisticalMathFunction;
import jsc.swt.control.IllegalCharactersField;
import jsc.swt.control.PosIntegerField;
import jsc.swt.control.RealField;
import jsc.swt.datatable.CalculatorVariables;
import jsc.swt.datatable.DataMatrix;
import jsc.swt.datatable.DataModel;
import jsc.swt.datatable.RecodeTable;
import jsc.swt.datatable.Table;
import jsc.util.Maths;
import jsc.util.Sort;

public class DataTable
extends Table {
    public static final String FSDS = "\"";
    public static final String DELIMITERS = " ,\"\t\n\r";
    public static final String ROW_DELIMITERS = "\n\r";
    public static final String COL_DELIMITERS = " ,\"\t";
    public static final int SQUARE = 1;
    public static final int SQRT = 2;
    public static final int LOGE = 3;
    public static final int LOG10 = 6;
    public static final int RECIP_SQRT = 4;
    public static final int RECIP = 5;
    JTextField columnNameEditor = new JTextField();
    JTableHeader tableHeader;
    TableColumnModel columnModel;
    JTable tableView;
    DataModel dataModel;
    int clickedColumn;
    int lastRowInserted;
    final IllegalCharactersField illegalCharsField = new IllegalCharactersField(0, "\"");
    final PosIntegerField integerField = new PosIntegerField(0, 5);
    final RealField realField = new RealField(0.0, 5, this.realFormat);
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public DataTable(DataModel dataModel) {
        super(dataModel);
        this.dataModel = dataModel;
        this.tableView = this;
        this.tableHeader = this.getTableHeader();
        this.columnModel = this.getColumnModel();
        this.columnNameEditor.setVisible(false);
        this.tableHeader.add(this.columnNameEditor);
        this.columnNameEditor.addFocusListener(new ColumnNameFocusHandler());
        this.columnNameEditor.addKeyListener(new ColumnNameEditorListener());
        this.integerField.setHorizontalAlignment(4);
        this.setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerCellEditor());
        this.realField.setHorizontalAlignment(4);
        this.setDefaultEditor(class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double, new DoubleCellEditor());
        this.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String, new StringCellEditor());
        this.addMouseListenerToHeaderInTable();
        this.lastRowInserted = this.getRowCount() - 1;
        this.setAutoResizeMode(0);
    }

    public int addColumn() {
        int n = this.convertColumnIndexToView(this.dataModel.addColumn());
        this.setColumnName(n, this.getColumnName(n));
        return n;
    }

    void addMouseListenerToHeaderInTable() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel = DataTable.this.getColumnModel();
                DataTable.this.clickedColumn = n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (DataTable.this.clickedColumn == -1) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown()) {
                    DataTable.this.changeColumnType(DataTable.this.clickedColumn, mouseEvent.getX(), mouseEvent.getY());
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    DataTable.this.editColumnName(DataTable.this.clickedColumn);
                }
            }
        };
        this.tableHeader.addMouseListener(mouseAdapter);
    }

    public void addRow() {
        this.dataModel.addRow();
    }

    public int calculate(StatisticalMathFunction statisticalMathFunction, CalculatorVariables calculatorVariables) {
        int n = this.addColumn();
        this.setColumnClass(n, class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double);
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            block4: {
                double d;
                calculatorVariables.setRowIndex(n2);
                try {
                    d = statisticalMathFunction.eval();
                }
                catch (MathFunctionException mathFunctionException) {
                    break block4;
                }
                if (!Double.isNaN(d)) {
                    this.setValueAt(new Double(d), n2, n);
                }
            }
            ++n2;
        }
        return n;
    }

    public void changeColumnType() {
        this.changeColumnType(Math.max(0, this.getSelectedColumn()));
    }

    public void changeColumnType(int n) {
        Rectangle rectangle = this.tableHeader.getHeaderRect(n);
        this.changeColumnType(n, rectangle.x, rectangle.y);
    }

    void changeColumnType(int n, int n2, int n3) {
        JPopupMenu jPopupMenu = new JPopupMenu("Column type");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Categorical");
        jRadioButtonMenuItem.setMnemonic('C');
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Continuous");
        jRadioButtonMenuItem2.setMnemonic('O');
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Integer");
        jRadioButtonMenuItem3.setMnemonic('I');
        jRadioButtonMenuItem.addActionListener(new CategoricalListener());
        jRadioButtonMenuItem2.addActionListener(new ContinuousListener());
        jRadioButtonMenuItem3.addActionListener(new IntegerListener());
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        jPopupMenu.add(jRadioButtonMenuItem);
        jPopupMenu.add(jRadioButtonMenuItem2);
        jPopupMenu.add(jRadioButtonMenuItem3);
        Class<?> clazz = this.getColumnClass(n);
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String)) {
            jRadioButtonMenuItem.setSelected(true);
        } else if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double)) {
            jRadioButtonMenuItem2.setSelected(true);
        } else if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            jRadioButtonMenuItem3.setSelected(true);
        }
        jPopupMenu.show(this.tableView, n2, n3);
    }

    public void clear() {
        if (this.getCellSelectionEnabled()) {
            this.clearSelectedCells();
        } else if (this.getColumnSelectionAllowed()) {
            this.clearSelectedColumns();
        } else if (this.getRowSelectionAllowed()) {
            this.clearSelectedRows();
        }
    }

    void clearSelectedCells() {
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                if (this.isCellSelected(n3, n4)) {
                    this.dataModel.removeCell(n3, this.convertColumnIndexToModel(n4));
                }
                --n4;
            }
            --n3;
        }
        this.dataModel.fireTableDataChanged();
    }

    void clearSelectedColumns() {
        int n = this.getSelectedColumnCount();
        int[] nArray = this.getSelectedColumns();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getColumnName(nArray[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            this.dataModel.removeColumn(stringArray[n3]);
            ++n3;
        }
        this.dataModel.fireTableDataChanged();
    }

    void clearSelectedRows() {
        int[] nArray = this.getSelectedRows();
        int n = this.getSelectedRowCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.dataModel.removeRow(nArray[n2]);
            --n2;
        }
        this.dataModel.fireTableDataChanged();
    }

    private void convertDoubleToInteger(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            Object object = this.getValueAt(n2, n);
            if (object instanceof Double) {
                Double d = (Double)object;
                int n3 = d.intValue();
                if (n3 < 0) {
                    n3 = 0;
                }
                this.setValueAt(new Integer(n3), n2, n);
            }
            ++n2;
        }
    }

    private void convertDoubleToString(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            Object object = this.getValueAt(n2, n);
            if (object instanceof Double) {
                Double d = (Double)object;
                String string = this.realFormat.format(d);
                this.setValueAt(string, n2, n);
            }
            ++n2;
        }
    }

    private void convertIntegerToDouble(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            Object object = this.getValueAt(n2, n);
            if (object instanceof Integer) {
                Integer n3 = (Integer)object;
                double d = n3.doubleValue();
                this.setValueAt(new Double(d), n2, n);
            }
            ++n2;
        }
    }

    private void convertIntegerToString(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            Object object = this.getValueAt(n2, n);
            if (object instanceof Integer) {
                Integer n3 = (Integer)object;
                String string = this.integerFormat.format(n3.intValue());
                this.setValueAt(string, n2, n);
            }
            ++n2;
        }
    }

    private void convertStringToDouble(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            Object object = this.getValueAt(n2, n);
            if (object != null) {
                Number number;
                String string = object.toString();
                try {
                    number = this.realFormat.parse(string);
                }
                catch (ParseException parseException) {
                    return;
                }
                double d = number.doubleValue();
                this.setValueAt(new Double(d), n2, n);
            }
            ++n2;
        }
    }

    private void convertStringToInteger(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            Object object = this.getValueAt(n2, n);
            if (object != null) {
                Number number;
                String string = object.toString();
                try {
                    number = this.integerFormat.parse(string);
                }
                catch (ParseException parseException) {
                    return;
                }
                int n3 = number.intValue();
                this.setValueAt(new Integer(n3), n2, n);
            }
            ++n2;
        }
    }

    public void editColumnName() {
        this.editColumnName(Math.max(0, this.getSelectedColumn()));
    }

    public void editColumnName(int n) {
        Rectangle rectangle = this.tableHeader.getHeaderRect(n);
        this.columnNameEditor.setBounds(rectangle);
        this.columnNameEditor.setText(this.getColumnName(n));
        this.columnNameEditor.selectAll();
        this.columnNameEditor.setVisible(true);
        this.columnNameEditor.requestFocus();
    }

    public String[] getCategoricalData(String string) {
        int n = this.getColumnIndex(string);
        int n2 = this.getRowCount();
        Vector<String> vector = new Vector<String>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object object = this.getValueAt(n3, n);
            if (object != null) {
                vector.addElement(object.toString());
            }
            ++n3;
        }
        int n4 = vector.size();
        String[] stringArray = new String[n4];
        n3 = 0;
        while (n3 < n4) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public Class getColumnClass(String string) {
        return this.getColumnClass(this.getColumnIndex(string));
    }

    public int getColumnIndex(String string) {
        return this.columnModel.getColumnIndex(string);
    }

    public Vector getColumnNames(boolean bl, boolean bl2, boolean bl3, int n) {
        return this.dataModel.getColumnNames(bl, bl2, bl3, n);
    }

    public Class getDefaultColumnClass() {
        return this.dataModel.getDefaultColumnClass();
    }

    public String getDefaultNamePrefix() {
        return this.dataModel.getDefaultNamePrefix();
    }

    public double[] getNumericalData(String string) {
        int n = this.getColumnIndex(string);
        int n2 = this.getRowCount();
        Vector<Object> vector = new Vector<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object object = this.getValueAt(n3, n);
            if (object instanceof Double) {
                vector.addElement(object);
            } else if (object instanceof Integer) {
                Integer n4 = (Integer)object;
                vector.addElement(new Double(n4.doubleValue()));
            }
            ++n3;
        }
        int n5 = vector.size();
        double[] dArray = new double[n5];
        n3 = 0;
        while (n3 < n5) {
            dArray[n3] = (Double)vector.elementAt(n3);
            ++n3;
        }
        return dArray;
    }

    public double[][] getNumericalData(String[] stringArray) {
        Object object;
        int n;
        int n2 = stringArray.length;
        int n3 = this.getRowCount();
        Vector<double[]> vector = new Vector<double[]>(n3);
        int n4 = 0;
        while (n4 < n3) {
            n = 1;
            object = new double[n2];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = this.getColumnIndex(stringArray[n5]);
                double d = this.getNumericalValueAt(n4, n6);
                if (Double.isNaN(d)) {
                    n = 0;
                    break;
                }
                object[n5] = d;
                ++n5;
            }
            if (n != 0) {
                vector.addElement((double[])object);
            }
            ++n4;
        }
        n = vector.size();
        object = new double[n][];
        n4 = 0;
        while (n4 < n) {
            object[n4] = (double)((double[])vector.elementAt(n4));
            ++n4;
        }
        return object;
    }

    public double getNumericalValueAt(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (object instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        if (object instanceof Integer) {
            Integer n3 = (Integer)object;
            return n3.doubleValue();
        }
        return Double.NaN;
    }

    public void insertColumn() {
        int n = this.getSelectedColumn();
        if (n < 0) {
            return;
        }
        this.dataModel.insertColumn(++n);
    }

    public void insertRow() {
        int n = this.getSelectedRow();
        if (n < 0) {
            n = this.lastRowInserted;
        }
        this.lastRowInserted = this.dataModel.insertRow(++n);
    }

    public boolean isChanged() {
        return this.dataModel.isChanged();
    }

    public boolean isColumnDataDouble(int n) {
        return this.dataModel.isColumnDataDouble(this.convertColumnIndexToModel(n));
    }

    public boolean isColumnDataInteger(int n) {
        return this.dataModel.isColumnDataInteger(this.convertColumnIndexToModel(n));
    }

    public void insertValue(Object object, int n, int n2) {
        this.dataModel.insertValue(object, n, this.convertColumnIndexToModel(n2));
    }

    public boolean isNameInUse(int n, String string) {
        int n2 = 0;
        while (n2 < this.getColumnCount()) {
            if (string.equals(this.getColumnName(n2)) && n2 != n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void paste() {
        switch (Table.copiedData.getCopyMode()) {
            case 3: {
                this.pasteCells(Table.copiedData);
                break;
            }
            case 2: {
                this.pasteColumns();
                break;
            }
            case 1: {
                this.pasteRows();
            }
        }
    }

    public void pasteCells(DataMatrix dataMatrix) {
        int n;
        int n2;
        int n3 = this.getSelectedRow();
        int n4 = this.getSelectedColumn();
        if (n3 < 0 || n4 < 0) {
            return;
        }
        int n5 = dataMatrix.getRowCount();
        if (n5 < 1) {
            return;
        }
        int n6 = dataMatrix.getColumnCount();
        int n7 = n4 + n6;
        if (n7 > (n2 = this.getColumnCount())) {
            n = 1;
            while (n <= n7 - n2) {
                this.addColumn();
                ++n;
            }
        }
        int n8 = 1;
        while (n8 <= n5) {
            this.addRow();
            ++n8;
        }
        n = 0;
        while (n < n6) {
            int n9 = n4 + n;
            n8 = 0;
            while (n8 < n5) {
                int n10 = n3 + n8;
                this.insertValue(dataMatrix.getValueAt(n8, n), n10, n9);
                ++n8;
            }
            Class clazz = dataMatrix.getColumnClass(n);
            if (clazz == (class$java$lang$Integer == null ? DataTable.class$("java.lang.Integer") : class$java$lang$Integer) && this.isColumnDataInteger(n9)) {
                this.convertStringToInteger(n9);
                this.setColumnClass(n9, class$java$lang$Integer == null ? DataTable.class$("java.lang.Integer") : class$java$lang$Integer);
            } else if (clazz == (class$java$lang$Double == null ? DataTable.class$("java.lang.Double") : class$java$lang$Double) && this.isColumnDataDouble(n9)) {
                this.convertStringToDouble(n9);
                this.setColumnClass(n9, class$java$lang$Double == null ? DataTable.class$("java.lang.Double") : class$java$lang$Double);
            } else {
                this.setColumnClass(n9, class$java$lang$String == null ? DataTable.class$("java.lang.String") : class$java$lang$String);
            }
            ++n;
        }
        this.dataModel.trimTableRows(n5);
        this.dataModel.fireTableDataChanged();
    }

    public void pasteColumns() {
        int n = Table.copiedData.getRowCount();
        if (n < 1) {
            return;
        }
        int n2 = 0;
        while (n2 < Table.copiedData.getColumnCount()) {
            int n3 = this.addColumn();
            this.setColumnClass(n3, Table.copiedData.getColumnClass(n2));
            this.setColumnName(n3, Table.copiedData.getColumnName(n2));
            int n4 = 0;
            while (n4 < n) {
                this.setValueAt(Table.copiedData.getValueAt(n4, n2), n4, n3);
                ++n4;
            }
            ++n2;
        }
        this.dataModel.fireTableDataChanged();
    }

    public void pasteFromSystemClipboard() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            DataMatrix dataMatrix = new DataMatrix(string, false, ROW_DELIMITERS, COL_DELIMITERS, "");
            this.pasteCells(dataMatrix);
        }
        catch (Exception exception) {
            this.getToolkit().beep();
            return;
        }
    }

    public void pasteRows() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = Table.copiedData.getColumnCount();
        int n3 = Table.copiedData.getRowCount();
        if (n3 < 1) {
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            this.dataModel.insertRow(n);
            int n5 = 0;
            while (n5 < n2) {
                this.setValueAt(Table.copiedData.getValueAt(n4, n5), n, n5);
                ++n5;
            }
            ++n;
            ++n4;
        }
        this.dataModel.fireTableDataChanged();
    }

    public void promoteColumnClass(int n) {
        Class<?> clazz = this.getColumnClass(n);
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String)) {
            if (this.isColumnDataInteger(n)) {
                this.convertStringToInteger(n);
                this.setColumnClass(n, class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer);
                return;
            }
            if (this.isColumnDataDouble(n)) {
                this.convertStringToDouble(n);
                this.setColumnClass(n, class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double);
                return;
            }
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer) && this.isColumnDataDouble(n)) {
            this.convertIntegerToDouble(n);
            this.setColumnClass(n, class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double);
        }
    }

    public int recode(String string, RecodeTable recodeTable) {
        int n = this.addColumn();
        this.setColumnClass(n, class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String);
        int n2 = this.getRowCount();
        int n3 = recodeTable.getRowCount();
        int n4 = this.getColumnIndex(string);
        int n5 = 0;
        while (n5 < n2) {
            Object object = this.getValueAt(n5, n4);
            if (object != null) {
                int n6 = 0;
                while (n6 < n3) {
                    String string2 = object.toString();
                    Object object2 = recodeTable.getValueAt(n6, 1);
                    if (object2 != null && string2.equals(recodeTable.getValueAt(n6, 0))) {
                        object = object2;
                        break;
                    }
                    ++n6;
                }
                this.setValueAt(object, n5, n);
            }
            ++n5;
        }
        return n;
    }

    public void setChanged(boolean bl) {
        this.dataModel.setChanged(bl);
    }

    public void setColumnClass(int n, Class clazz) {
        this.dataModel.setColumnClass(this.convertColumnIndexToModel(n), clazz);
    }

    public void setColumnName(int n, String string) {
        String string2 = Utilities.deleteChars(FSDS, string);
        int n2 = 0;
        String string3 = string2.trim();
        while (this.isNameInUse(n, string3)) {
            string3 = string2 + "-" + ++n2;
        }
        this.dataModel.setColumnName(this.convertColumnIndexToModel(n), string3);
    }

    void setColumnNameEdited(boolean bl) {
        String string = this.columnNameEditor.getText();
        this.setColumnName(this.clickedColumn, string);
        if (!bl || this.clickedColumn >= this.getColumnCount() - 1) {
            this.columnNameEditor.setVisible(false);
        } else {
            ++this.clickedColumn;
            this.editColumnName(this.clickedColumn);
        }
    }

    public void setData(double[] dArray, int n, String string) {
        this.setColumnClass(n, class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double);
        int n2 = this.getRowCount();
        if (string == null) {
            int n3 = 0;
            while (n3 < dArray.length) {
                if (n3 >= n2) {
                    this.addRow();
                }
                this.setValueAt(new Double(dArray[n3]), n3, n);
                ++n3;
            }
        } else {
            int n4 = 0;
            int n5 = this.getColumnIndex(string);
            int n6 = 0;
            while (n6 < n2) {
                if (this.getValueAt(n6, n5) != null) {
                    this.setValueAt(new Double(dArray[n4++]), n6, n);
                }
                ++n6;
            }
        }
    }

    public void setDefaultColumnClass(Class clazz) {
        this.dataModel.setDefaultColumnClass(clazz);
    }

    public void setEditable(boolean bl) {
        this.dataModel.setEditable(bl);
    }

    /*
     * Unable to fully structure code
     */
    private void sort(int var1_1, int var2_2, int var3_3, boolean var4_4) {
        var5_5 = var2_2;
        var6_6 = var3_3;
        var7_7 = this.getValueAt((var2_2 + var3_3) / 2, var1_1);
        do {
            block8: {
                if (!var4_4) ** GOTO lbl14
                while (var5_5 < var3_3 && Sort.compare(var7_7, this.getValueAt(var5_5, var1_1), true) > 0) {
                    ++var5_5;
                }
                while (var6_6 > var2_2 && Sort.compare(var7_7, this.getValueAt(var6_6, var1_1), true) < 0) {
                    --var6_6;
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    ++var5_5;
lbl14:
                    // 2 sources

                    ** while (var5_5 < var3_3 && Sort.compare((Object)var7_7, (Object)this.getValueAt((int)var5_5, (int)var1_1), (boolean)false) < 0)
                }
lbl15:
                // 2 sources

                while (var6_6 > var2_2 && Sort.compare(var7_7, this.getValueAt(var6_6, var1_1), false) > 0) {
                    --var6_6;
                }
            }
            if (var5_5 < var6_6) {
                this.dataModel.swapRow(var5_5, var6_6);
            }
            if (var5_5 > var6_6) continue;
            ++var5_5;
            --var6_6;
        } while (var5_5 <= var6_6);
        if (var2_2 < var6_6) {
            this.sort(var1_1, var2_2, var6_6, var4_4);
        }
        if (var5_5 < var3_3) {
            this.sort(var1_1, var5_5, var3_3, var4_4);
        }
    }

    public void sortRows(String string, boolean bl) {
        int n = this.getColumnIndex(string);
        int n2 = 0;
        int n3 = this.getRowCount() - 1;
        this.dataModel.addRow();
        this.sort(n, n2, n3, bl);
        this.dataModel.removeRow(this.getRowCount() - 1);
        this.dataModel.fireTableDataChanged();
    }

    public void subset(String string, JList jList, boolean bl) {
        int n = this.getRowCount();
        int n2 = this.getColumnIndex(string);
        Object[] objectArray = jList.getSelectedValues();
        int n3 = objectArray.length;
        int n4 = n - 1;
        while (n4 >= 0) {
            Object object = this.getValueAt(n4, n2);
            if (object != null) {
                boolean bl2 = false;
                int n5 = 0;
                while (n5 < n3) {
                    String string2 = object.toString();
                    if (string2.equals(objectArray[n5].toString())) {
                        bl2 = true;
                        break;
                    }
                    ++n5;
                }
                if (bl && !bl2) {
                    this.dataModel.removeRow(n4);
                } else if (!bl && bl2) {
                    this.dataModel.removeRow(n4);
                }
            }
            --n4;
        }
        this.dataModel.fireTableDataChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int transform(String string, int n) {
        int n2 = this.addColumn();
        this.setColumnClass(n2, class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double);
        int n3 = this.getRowCount();
        int n4 = this.getColumnIndex(string);
        double d = 0.0;
        int n5 = 0;
        while (n5 < n3) {
            block15: {
                double d2;
                block14: {
                    Object object;
                    block13: {
                        object = this.getValueAt(n5, n4);
                        if (!(object instanceof Double)) break block13;
                        d2 = (Double)object;
                        break block14;
                    }
                    if (!(object instanceof Integer)) break block15;
                    Integer n6 = (Integer)object;
                    d2 = n6.doubleValue();
                }
                switch (n) {
                    case 1: {
                        d = d2 * d2;
                        break;
                    }
                    case 2: {
                        if (!(d2 < 0.0)) {
                            d = Math.sqrt(d2);
                            break;
                        }
                        break block15;
                    }
                    case 3: {
                        if (!(d2 <= 0.0)) {
                            d = Math.log(d2);
                            break;
                        }
                        break block15;
                    }
                    case 6: {
                        if (!(d2 <= 0.0)) {
                            d = Maths.log10(d2);
                            break;
                        }
                        break block15;
                    }
                    case 4: {
                        if (!(d2 <= 0.0)) {
                            d = Math.sqrt(1.0 / d2);
                            break;
                        }
                        break block15;
                    }
                    case 5: {
                        if (d2 == 0.0) break block15;
                        d = 1.0 / d2;
                    }
                }
                this.setValueAt(new Double(d), n5, n2);
            }
            ++n5;
        }
        return n2;
    }

    public void updateData() {
        this.dataModel.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StringCellEditor
    extends DefaultCellEditor {
        public StringCellEditor() {
            super(DataTable.this.illegalCharsField);
        }

        public Object getCellEditorValue() {
            String string = DataTable.this.illegalCharsField.getText();
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
    }

    class IntegerListener
    implements ActionListener {
        IntegerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DataTable.this.isColumnDataDouble(DataTable.this.clickedColumn)) {
                return;
            }
            if (DataTable.this.getColumnClass(DataTable.this.clickedColumn) == (class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String)) {
                DataTable.this.convertStringToInteger(DataTable.this.clickedColumn);
            } else if (DataTable.this.getColumnClass(DataTable.this.clickedColumn) == (class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double)) {
                DataTable.this.convertDoubleToInteger(DataTable.this.clickedColumn);
            }
            DataTable.this.setColumnClass(DataTable.this.clickedColumn, class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
    }

    class IntegerCellEditor
    extends DefaultCellEditor {
        public IntegerCellEditor() {
            super(DataTable.this.integerField);
        }

        public Object getCellEditorValue() {
            String string = DataTable.this.integerField.getText();
            if (string.length() == 0) {
                return null;
            }
            return new Integer(DataTable.this.integerField.getValue());
        }
    }

    class DoubleCellEditor
    extends DefaultCellEditor {
        public DoubleCellEditor() {
            super(DataTable.this.realField);
        }

        public Object getCellEditorValue() {
            String string = DataTable.this.realField.getText();
            if (string.length() == 0) {
                return null;
            }
            return new Double(DataTable.this.realField.getValue());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string;
            if (object instanceof Double) {
                double d = (Double)object;
                string = DataTable.this.realFormat.format(d);
            } else {
                string = "";
            }
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }
    }

    class ContinuousListener
    implements ActionListener {
        ContinuousListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DataTable.this.isColumnDataDouble(DataTable.this.clickedColumn)) {
                return;
            }
            if (DataTable.this.getColumnClass(DataTable.this.clickedColumn) == (class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String)) {
                DataTable.this.convertStringToDouble(DataTable.this.clickedColumn);
            } else if (DataTable.this.getColumnClass(DataTable.this.clickedColumn) == (class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                DataTable.this.convertIntegerToDouble(DataTable.this.clickedColumn);
            }
            DataTable.this.setColumnClass(DataTable.this.clickedColumn, class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double);
        }
    }

    class ColumnNameFocusHandler
    extends FocusAdapter {
        ColumnNameFocusHandler() {
        }

        public void focusLost(FocusEvent focusEvent) {
            DataTable.this.columnNameEditor.setVisible(false);
        }
    }

    class ColumnNameEditorListener
    extends KeyAdapter {
        ColumnNameEditorListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                DataTable.this.setColumnNameEdited(true);
            } else if (n == 27) {
                DataTable.this.setColumnNameEdited(false);
            } else if (n == 18) {
                DataTable.this.columnNameEditor.setVisible(false);
            } else {
                return;
            }
        }
    }

    class CategoricalListener
    implements ActionListener {
        CategoricalListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataTable.this.getColumnClass(DataTable.this.clickedColumn) == (class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double)) {
                DataTable.this.convertDoubleToString(DataTable.this.clickedColumn);
            } else if (DataTable.this.getColumnClass(DataTable.this.clickedColumn) == (class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                DataTable.this.convertIntegerToString(DataTable.this.clickedColumn);
            }
            DataTable.this.setColumnClass(DataTable.this.clickedColumn, class$java$lang$String == null ? (class$java$lang$String = DataTable.class$("java.lang.String")) : class$java$lang$String);
        }
    }
}

