/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.datatable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jsc.swt.datatable.DataClipboard;
import jsc.swt.text.SigFigFormat;

public class Table
extends JTable {
    AbstractTableModel tableModel;
    SigFigFormat realFormat;
    NumberFormat integerFormat;
    public static DataClipboard copiedData = new DataClipboard();
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public Table(AbstractTableModel abstractTableModel) {
        super(abstractTableModel);
        this.tableModel = abstractTableModel;
        this.createDefaultColumnsFromModel();
        this.createDefaultRenderers();
        this.realFormat = new SigFigFormat(6);
        RealRenderer realRenderer = new RealRenderer();
        this.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = Table.class$("java.lang.Double")) : class$java$lang$Double, realRenderer);
        this.integerFormat = NumberFormat.getNumberInstance();
        IntegerRenderer integerRenderer = new IntegerRenderer();
        this.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = Table.class$("java.lang.Integer")) : class$java$lang$Integer, integerRenderer);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public void copy() {
        this.copyToSystemClipboard();
        if (this.getCellSelectionEnabled()) {
            this.copyCells();
        } else if (this.getColumnSelectionAllowed()) {
            this.copyColumns();
        } else if (this.getRowSelectionAllowed()) {
            this.copyRows();
        }
    }

    public void copyCells() {
        int n = this.getSelectedColumnCount();
        int n2 = this.getSelectedRowCount();
        if (n < 1 && n2 < 1) {
            return;
        }
        copiedData = new DataClipboard(3, n2, n);
        int[] nArray = this.getSelectedColumns();
        int[] nArray2 = this.getSelectedRows();
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            copiedData.setColumnClass(n3, this.getColumnClass(n4));
            int n5 = 0;
            while (n5 < n2) {
                int n6 = nArray2[n5];
                copiedData.setValueAt(this.getValueAt(n6, n4), n5, n3);
                ++n5;
            }
            ++n3;
        }
    }

    public void copyColumns() {
        int n = this.getRowCount();
        int n2 = this.getSelectedColumnCount();
        if (n2 < 1) {
            return;
        }
        copiedData = new DataClipboard(2, n, n2);
        int[] nArray = this.getSelectedColumns();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            copiedData.setColumnClass(n3, this.getColumnClass(n4));
            copiedData.setColumnName(n3, this.getColumnName(n4));
            int n5 = 0;
            while (n5 < n) {
                copiedData.setValueAt(this.getValueAt(n5, n4), n5, n3);
                ++n5;
            }
            ++n3;
        }
    }

    public void copyRows() {
        int n = this.getColumnCount();
        int n2 = this.getSelectedRowCount();
        if (n2 < 1) {
            return;
        }
        copiedData = new DataClipboard(1, n2, n);
        int[] nArray = this.getSelectedRows();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = 0;
            while (n5 < n) {
                copiedData.setValueAt(this.getValueAt(n4, n5), n3, n5);
                ++n5;
            }
            ++n3;
        }
    }

    public void copyToSystemClipboard() {
        StringBuffer stringBuffer = this.getDataAsStringBuffer(false, false, "\t");
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    public StringBuffer getDataAsStringBuffer(boolean bl, boolean bl2, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getColumnCount();
        if (bl2) {
            n = 0;
            while (n < n2) {
                if (bl || this.isColumnSelected(n)) {
                    stringBuffer.append(this.getColumnName(n) + string);
                }
                ++n;
            }
            stringBuffer.append("\n");
        }
        int n3 = 0;
        while (n3 < this.getRowCount()) {
            boolean bl3 = false;
            n = 0;
            while (n < n2) {
                if (bl || this.isCellSelected(n3, n)) {
                    bl3 = true;
                    stringBuffer.append(this.getValueAt(n3, n) + string);
                }
                ++n;
            }
            if (bl3) {
                stringBuffer.append("\n");
            }
            ++n3;
        }
        return stringBuffer;
    }

    public int getSignificantDigits() {
        return this.realFormat.getSignificantDigits();
    }

    public SigFigFormat getRealFormat() {
        return this.realFormat;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyStroke.equals(KeyStroke.getKeyStroke(67, 2, false)) || keyStroke.equals(KeyStroke.getKeyStroke(88, 2, false)) || keyStroke.equals(KeyStroke.getKeyStroke(86, 2, false))) {
            return false;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void resetColumnOrder() {
        this.tableModel.fireTableStructureChanged();
    }

    public void setSignificantDigits(int n) {
        this.realFormat.setSignificantDigits(n);
        this.tableModel.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RealRenderer
    extends DefaultTableCellRenderer {
        RealRenderer() {
        }

        public void RealRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            this.setHorizontalAlignment(4);
            if (object instanceof Double) {
                double d = (Double)object;
                string = Table.this.realFormat.format(d);
            } else {
                string = "";
            }
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    class IntegerRenderer
    extends DefaultTableCellRenderer {
        IntegerRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            this.setHorizontalAlignment(4);
            if (object instanceof Integer) {
                int n3 = (Integer)object;
                string = Table.this.integerFormat.format(n3);
            } else {
                string = "";
            }
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }
}

